/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.truffle.api.SubstrateKnownTruffleTypes;
import java.lang.ref.Reference;
import java.lang.reflect.Type;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class SubstrateTruffleGraphBuilderPlugins {
    static void registerInvocationPlugins(InvocationPlugins plugins, boolean canDelayIntrinsification, SubstrateKnownTruffleTypes types) {
        SubstrateTruffleGraphBuilderPlugins.registerCompilationFinalReferencePlugins(plugins, canDelayIntrinsification, types);
    }

    private static void registerCompilationFinalReferencePlugins(InvocationPlugins plugins, final boolean canDelayIntrinsification, final SubstrateKnownTruffleTypes types) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Reference.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant reference;
                Constant constant;
                if (!canDelayIntrinsification && (constant = receiver.get(false).asConstant()) instanceof JavaConstant && (reference = (JavaConstant)constant).isNonNull()) {
                    JavaConstant referent = b.getConstantReflection().readFieldValue(types.Reference_referent, reference);
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)referent, (MetaAccessProvider)b.getMetaAccess()));
                    return true;
                }
                return false;
            }
        });
    }
}

