/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.TruffleRuntimeCompilationSupport;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.graph.SourceLanguagePositionProvider;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.ParameterPlugin;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.replacements.PEGraphDecoder;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;

public class SubstratePEGraphDecoder
extends PEGraphDecoder {
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache = EconomicMap.create();

    public SubstratePEGraphDecoder(Architecture architecture, StructuredGraph graph, CoreProviders providers, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, ResolvedJavaMethod peRootForInlining, SourceLanguagePositionProvider sourceLanguagePosition, ConcurrentHashMap<PEGraphDecoder.SpecialCallTargetCacheKey, Object> specialCallTargetCache, ConcurrentHashMap<ResolvedJavaMethod, Object> invocationPluginsCache) {
        super(architecture, graph, providers, loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, peRootForInlining, sourceLanguagePosition, specialCallTargetCache, invocationPluginsCache, false, false);
    }

    protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider) {
        EncodedGraph result = (EncodedGraph)this.graphCache.get((Object)method);
        if (result == null) {
            result = this.createGraph(method, this.graph.trackNodeSourcePosition());
        }
        return result;
    }

    private EncodedGraph createGraph(ResolvedJavaMethod method, boolean trackNodeSourcePosition) {
        EncodedGraph result = TruffleRuntimeCompilationSupport.encodedGraph((SharedRuntimeMethod)((SharedRuntimeMethod)method), (boolean)trackNodeSourcePosition);
        if (result == null) {
            throw VMError.shouldNotReachHere((String)("Graph not available for runtime compilation: " + method.format("%H.%n(%p)")));
        }
        this.graphCache.put((Object)method, (Object)result);
        return result;
    }
}

