/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.truffle.TruffleFeature;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.truffle.host.HostInliningPhase;
import jdk.graal.compiler.truffle.host.TruffleHostEnvironment;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class SubstrateHostInliningPhase
extends HostInliningPhase {
    private final TruffleFeature truffleFeature = (TruffleFeature)ImageSingletons.lookup(TruffleFeature.class);

    SubstrateHostInliningPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer, -1.0);
    }

    protected StructuredGraph parseGraph(HighTierContext context, StructuredGraph graph, ResolvedJavaMethod method) {
        return ((HostedMethod)method).compilationInfo.createGraph(graph.getDebug(), graph.getOptions(), (CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID, true);
    }

    protected boolean isEnabledFor(TruffleHostEnvironment env, ResolvedJavaMethod method) {
        HostedMethod hostedMethod = (HostedMethod)method;
        if (hostedMethod.isDeoptTarget()) {
            return false;
        }
        if (super.isEnabledFor(env, method)) {
            return true;
        }
        return this.truffleFeature.runtimeCompiledMethods.contains(this.translateMethod(method)) && this.isTruffleBoundary(env, method) == null;
    }

    protected String isTruffleBoundary(TruffleHostEnvironment env, ResolvedJavaMethod targetMethod) {
        ResolvedJavaMethod translatedMethod = this.translateMethod(targetMethod);
        String boundary = super.isTruffleBoundary(env, targetMethod);
        if (boundary != null) {
            return boundary;
        }
        if (this.truffleFeature.isBlocklisted(translatedMethod)) {
            return "SVM block listed";
        }
        return null;
    }

    protected ResolvedJavaMethod translateMethod(ResolvedJavaMethod method) {
        return ((HostedMethod)method).getWrapped();
    }
}

