/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;

public record TranslateFieldOffsetFieldValueTransformer(ResolvedJavaField original, Class<?> targetClass) implements FieldValueTransformerWithAvailability
{
    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        return TranslateFieldOffsetFieldValueTransformer.translateFieldOffset(this.original, GraalAccess.getOriginalSnippetReflection().forObject(receiver), this.targetClass);
    }

    static Object translateFieldOffset(ResolvedJavaField original, JavaConstant receiver, Class<?> tclass) {
        long searchOffset = GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(original, receiver).asLong();
        for (Field f : tclass.getDeclaredFields()) {
            long fieldOffset;
            if (Modifier.isStatic(f.getModifiers()) || (fieldOffset = Unsafe.getUnsafe().objectFieldOffset(f)) != searchOffset) continue;
            int location = ((ReflectionSubstitutionSupport)ImageSingletons.lookup(ReflectionSubstitutionSupport.class)).getFieldOffset(f, true);
            VMError.guarantee(location > 0, "Location is missing for field whose offset is stored: %s.", f);
            return (long)location;
        }
        throw VMError.shouldNotReachHere("unknown field offset class: " + String.valueOf(tclass) + ", offset = " + searchOffset);
    }
}

