/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.MissingRegistrationSupport;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneWithExceptionNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.FarReturnNode;
import com.oracle.svm.core.graal.nodes.FieldOffsetNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.ReadReturnAddressNode;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.nodes.SubstrateReflectionGetCallerClassNode;
import com.oracle.svm.core.graal.nodes.TestDeoptimizeNode;
import com.oracle.svm.core.graal.stackvalue.LateStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.graal.stackvalue.UnsafeLateStackValue;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceAccessImpl;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.identityhashcode.SubstrateIdentityHashCodeNode;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.imagelayer.LoadImageSingletonFactory;
import com.oracle.svm.core.layeredimagesingleton.ApplicationLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.nodes.ReadReservedRegister;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.io.ObjectInputFilter;
import java.lang.ref.Reference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DynamicPiNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceWithExceptionNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.java.ValidateNewInstanceClassNode;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.type.NarrowOopStamp;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.replacements.StandardGraphBuilderPlugins;
import jdk.graal.compiler.replacements.nodes.AESNode;
import jdk.graal.compiler.replacements.nodes.CipherBlockChainingAESNode;
import jdk.graal.compiler.replacements.nodes.CounterModeAESNode;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.VectorizedHashCodeNode;
import jdk.graal.compiler.replacements.nodes.VectorizedMismatchNode;
import jdk.graal.compiler.word.WordCastNode;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.RuntimeProxyCreation;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.hosted.RuntimeSerialization;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class SubstrateGraphBuilderPlugins {
    public static void registerInvocationPlugins(AnnotationSubstitutionProcessor annotationSubstitutions, ImageClassLoader loader, InvocationPlugins plugins, Replacements replacements, ParsingReason parsingReason, Architecture architecture, boolean supportsStubBasedPlugins) {
        SubstrateGraphBuilderPlugins.registerSystemPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerReflectionPlugins(plugins, replacements);
        SubstrateGraphBuilderPlugins.registerImageInfoPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerProxyPlugins(annotationSubstitutions, plugins, parsingReason);
        SubstrateGraphBuilderPlugins.registerSerializationPlugins(loader, plugins, parsingReason);
        SubstrateGraphBuilderPlugins.registerAtomicUpdaterPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerObjectPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(plugins);
        SubstrateGraphBuilderPlugins.registerKnownIntrinsicsPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerStackValuePlugins(plugins);
        SubstrateGraphBuilderPlugins.registerArrayPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerClassPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerVMConfigurationPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerPlatformPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerSizeOfPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerReferencePlugins(plugins, parsingReason);
        SubstrateGraphBuilderPlugins.registerReferenceAccessPlugins(plugins);
        if (supportsStubBasedPlugins) {
            SubstrateGraphBuilderPlugins.registerAESPlugins(plugins, replacements, architecture);
            SubstrateGraphBuilderPlugins.registerArraysSupportPlugins(plugins, replacements, architecture);
        }
    }

    private static void registerSerializationPlugins(final ImageClassLoader loader, InvocationPlugins plugins, final ParsingReason reason) {
        if (reason.duringAnalysis() && reason != ParsingReason.JITCompilation) {
            InvocationPlugins.Registration serializationFilter = new InvocationPlugins.Registration(plugins, ObjectInputFilter.Config.class);
            serializationFilter.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("createFilter", new Type[]{String.class}){

                public boolean isDecorator() {
                    return true;
                }

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode patternNode) {
                    String pattern = SubstrateGraphBuilderPlugins.asConstantObject(b, String.class, patternNode);
                    if (pattern != null) {
                        b.add((Node)ReachabilityRegistrationNode.create(() -> SubstrateGraphBuilderPlugins.parsePatternAndRegister(loader, pattern), reason));
                        return true;
                    }
                    return false;
                }
            });
            if (ModuleLayer.boot().findModule("jdk.unsupported").isPresent()) {
                InvocationPlugins.Registration customConstructor = new InvocationPlugins.Registration(plugins, loader.findClassOrFail("sun.reflect.ReflectionFactory"));
                customConstructor.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newConstructorForSerialization", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

                    public boolean isDecorator() {
                        return true;
                    }

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazzNode) {
                        Class clazz = SubstrateGraphBuilderPlugins.asConstantObject(b, Class.class, clazzNode);
                        if (clazz != null) {
                            b.add((Node)ReachabilityRegistrationNode.create(() -> RuntimeSerialization.register((Class[])new Class[]{clazz}), reason));
                            return true;
                        }
                        return false;
                    }
                });
                customConstructor.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newConstructorForSerialization", new Type[]{InvocationPlugin.Receiver.class, Class.class, Constructor.class}){

                    public boolean isDecorator() {
                        return true;
                    }

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazzNode, ValueNode constructorNode) {
                        Class clazz = SubstrateGraphBuilderPlugins.asConstantObject(b, Class.class, clazzNode);
                        Constructor constructor = SubstrateGraphBuilderPlugins.asConstantObject(b, Constructor.class, constructorNode);
                        if (clazz != null && constructor != null) {
                            b.add((Node)ReachabilityRegistrationNode.create(() -> RuntimeSerialization.registerWithTargetConstructorClass((Class)clazz, constructor.getDeclaringClass()), reason));
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
    }

    public static <T> T asConstantObject(GraphBuilderContext b, Class<T> type, ValueNode node) {
        return (T)StandardGraphBuilderPlugins.asConstantObject((GraphBuilderContext)b, type, (ValueNode)node);
    }

    public static int asConstantIntegerOrMinusOne(ValueNode node) {
        ConstantNode constantNode;
        Constant constant;
        if (node instanceof ConstantNode && (constant = (constantNode = (ConstantNode)node).getValue()) instanceof JavaConstant) {
            JavaConstant javaConstant = (JavaConstant)constant;
            return javaConstant.asInt();
        }
        return -1;
    }

    private static boolean isLimitPattern(String pattern) {
        int eqNdx = pattern.indexOf(61);
        return eqNdx >= 0;
    }

    private static void parsePatternAndRegister(ImageClassLoader loader, String pattern) {
        String[] patterns;
        for (String p : patterns = pattern.split(";")) {
            boolean negate;
            int poffset;
            int slash;
            int nameLen = p.length();
            if (nameLen == 0 || SubstrateGraphBuilderPlugins.isLimitPattern(p) || (slash = p.indexOf(47, poffset = (negate = p.charAt(0) == '!') ? 1 : 0)) == poffset) continue;
            int n = poffset = slash >= 0 ? slash + 1 : poffset;
            if (p.endsWith("*")) {
                if (p.endsWith(".*") || p.endsWith(".**")) continue;
                String className = p.substring(poffset, nameLen - 1);
                if (negate || !className.endsWith("$$Lambda")) continue;
                String lambdaHolderName = LambdaUtils.capturingClass((String)className);
                loader.findClass(lambdaHolderName).ifPresent(RuntimeSerialization::registerLambdaCapturingClass);
                continue;
            }
            Object name = p.substring(poffset);
            if (((String)name).isEmpty()) {
                return;
            }
            if (negate) continue;
            if (((String)name).startsWith("[") && ((String)name).contains("[L") && !((String)name).endsWith(";")) {
                name = (String)name + ";";
            }
            loader.findClass((String)name).ifPresent(xva$0 -> RuntimeSerialization.register((Class[])new Class[]{xva$0}));
        }
    }

    private static void registerSystemPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, System.class);
        if (SubstrateOptions.FoldSecurityManagerGetter.getValue().booleanValue()) {
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getSecurityManager", new Type[0]){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.NULL_POINTER, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                    return true;
                }
            });
        }
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("identityHashCode", new Type[]{Object.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Int, SubstrateIdentityHashCodeNode.create(object, b.bci(), (CoreProviders)b));
                return true;
            }
        });
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.reflect.Reflection", replacements);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("getCallerClass", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)new SubstrateReflectionGetCallerClassNode(MacroNode.MacroParams.of((GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (ValueNode[])new ValueNode[0])));
                return true;
            }
        });
    }

    private static void registerImageInfoPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration registration = new InvocationPlugins.Registration(plugins, ImageInfo.class);
        registration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("inImageCode", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.TRUE, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                return true;
            }
        });
        registration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("inImageBuildtimeCode", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.FALSE, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                return true;
            }
        });
        registration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("inImageRuntimeCode", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.TRUE, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                return true;
            }
        });
    }

    private static void registerProxyPlugins(AnnotationSubstitutionProcessor annotationSubstitutions, InvocationPlugins plugins, ParsingReason reason) {
        InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, Proxy.class);
        SubstrateGraphBuilderPlugins.registerProxyPlugin(proxyRegistration, annotationSubstitutions, reason, "getProxyClass", ClassLoader.class, Class[].class);
        SubstrateGraphBuilderPlugins.registerProxyPlugin(proxyRegistration, annotationSubstitutions, reason, "newProxyInstance", ClassLoader.class, Class[].class, InvocationHandler.class);
    }

    private static void registerProxyPlugin(InvocationPlugins.Registration proxyRegistration, final AnnotationSubstitutionProcessor annotationSubstitutions, final ParsingReason reason, String name, Class<?> ... parameterTypes) {
        proxyRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(name, parameterTypes){

            public boolean isDecorator() {
                return true;
            }

            public boolean defaultHandler(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode ... args) {
                Runnable proxyRegistrationRunnable = SubstrateGraphBuilderPlugins.interceptProxyInterfaces(b, targetMethod, annotationSubstitutions, args[1]);
                if (proxyRegistrationRunnable != null) {
                    Class callerClass = OriginalClassProvider.getJavaClass((JavaType)b.getMethod().getDeclaringClass());
                    boolean callerInScope = MissingRegistrationSupport.singleton().reportMissingRegistrationErrors(callerClass);
                    if (callerInScope && reason.duringAnalysis() && reason != ParsingReason.JITCompilation) {
                        b.add((Node)ReachabilityRegistrationNode.create(proxyRegistrationRunnable, reason));
                        return true;
                    }
                    proxyRegistrationRunnable.run();
                    return false;
                }
                return false;
            }
        });
    }

    private static Runnable interceptProxyInterfaces(GraphBuilderContext b, ResolvedJavaMethod targetMethod, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode interfacesNode) {
        Class[] interfaces = SubstrateGraphBuilderPlugins.extractClassArray(b, annotationSubstitutions, interfacesNode);
        if (interfaces != null) {
            ResolvedJavaMethod caller = b.getGraph().method();
            ResolvedJavaMethod method = b.getMethod();
            int bci = b.bci();
            return () -> {
                RuntimeProxyCreation.register((Class[])interfaces);
                if (ImageSingletons.contains(FallbackFeature.class)) {
                    ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).addAutoProxyInvoke(method, bci);
                }
                if (Options.DynamicProxyTracing.getValue().booleanValue()) {
                    System.out.println("Successfully determined constant value for interfaces argument of call to " + targetMethod.format("%H.%n(%p)") + " reached from " + caller.format("%H.%n(%p)") + ". Registered proxy class for " + Arrays.toString(interfaces) + ".");
                }
            };
        }
        if (Options.DynamicProxyTracing.getValue().booleanValue() && !b.parsingIntrinsic()) {
            System.out.println("Could not determine constant value for interfaces argument of call to " + targetMethod.format("%H.%n(%p)") + " reached from " + b.getGraph().method().format("%H.%n(%p)") + ".");
        }
        return null;
    }

    static Class<?>[] extractClassArray(GraphBuilderContext b, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode arrayNode) {
        Class<?>[] classes = SubstrateGraphBuilderPlugins.extractClassArray(b, annotationSubstitutions, arrayNode, false);
        return classes == null ? null : (Stream.of(classes).allMatch(Objects::nonNull) ? classes : null);
    }

    static Class<?>[] extractClassArray(GraphBuilderContext b, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode arrayNode, boolean exact) {
        ValueNode originalArrayNode = SubstrateGraphBuilderPlugins.getDeoptProxyOriginalValue(arrayNode);
        if (originalArrayNode.isJavaConstant() && !exact) {
            return (Class[])b.getSnippetReflection().asObject(Class[].class, originalArrayNode.asJavaConstant());
        }
        if (originalArrayNode instanceof AllocatedObjectNode && StampTool.isAlwaysArray((ValueNode)originalArrayNode)) {
            AllocatedObjectNode allocatedObjectNode = (AllocatedObjectNode)originalArrayNode;
            if (!allocatedObjectNode.getVirtualObject().type().equals((Object)b.getMetaAccess().lookupJavaType(Class[].class))) {
                return null;
            }
            CommitAllocationNode commitAllocationNode = allocatedObjectNode.getCommit();
            if (SubstrateGraphBuilderPlugins.skipNonInterferingNodes(commitAllocationNode.next()) != null) {
                return null;
            }
            int objectStartIndex = 0;
            for (VirtualObjectNode virtualObject : commitAllocationNode.getVirtualObjects()) {
                if (virtualObject == allocatedObjectNode.getVirtualObject()) {
                    assert (virtualObject instanceof VirtualArrayNode) : virtualObject;
                    Class[] result = new Class[virtualObject.entryCount()];
                    for (int i = 0; i < result.length; ++i) {
                        JavaConstant valueConstant = ((ValueNode)commitAllocationNode.getValues().get(objectStartIndex + i)).asJavaConstant();
                        if (SubstrateGraphBuilderPlugins.storeClassArrayConstant(b, result, i, valueConstant, annotationSubstitutions)) continue;
                        return null;
                    }
                    return result;
                }
                objectStartIndex += virtualObject.entryCount();
            }
            throw VMError.shouldNotReachHere("Must have found the virtual object");
        }
        if (originalArrayNode instanceof NewArrayNode) {
            NewArrayNode newArray = (NewArrayNode)originalArrayNode;
            if (!newArray.elementType().equals((Object)b.getMetaAccess().lookupJavaType(Class.class))) {
                return null;
            }
            ValueNode newArrayLengthNode = newArray.length();
            if (!newArrayLengthNode.isJavaConstant()) {
                return null;
            }
            assert (newArrayLengthNode.asJavaConstant().getJavaKind() == JavaKind.Int);
            int newArrayLength = newArrayLengthNode.asJavaConstant().asInt();
            Class[] result = new Class[newArrayLength];
            FixedNode successor = SubstrateGraphBuilderPlugins.unwrapNode(newArray.next());
            while (successor instanceof StoreIndexedNode) {
                StoreIndexedNode store = (StoreIndexedNode)successor;
                if (SubstrateGraphBuilderPlugins.getDeoptProxyOriginalValue(store.array()).equals(newArray)) {
                    JavaConstant valueConstant;
                    if (!store.index().isJavaConstant()) {
                        return null;
                    }
                    int index = store.index().asJavaConstant().asInt();
                    if (!SubstrateGraphBuilderPlugins.storeClassArrayConstant(b, result, index, valueConstant = store.value().asJavaConstant(), annotationSubstitutions)) {
                        return null;
                    }
                }
                successor = SubstrateGraphBuilderPlugins.unwrapNode(store.next());
            }
            if (successor != null && exact) {
                return null;
            }
            return result;
        }
        return null;
    }

    private static boolean storeClassArrayConstant(GraphBuilderContext b, Class<?>[] result, int index, JavaConstant valueConstant, AnnotationSubstitutionProcessor annotationSubstitutions) {
        if (valueConstant == null || valueConstant.getJavaKind() != JavaKind.Object) {
            return false;
        }
        if (valueConstant.isNull()) {
            result[index] = null;
        } else {
            Class<?> clazz = (Class<?>)b.getSnippetReflection().asObject(Class.class, valueConstant);
            if (clazz == null) {
                return false;
            }
            result[index] = annotationSubstitutions == null ? clazz : annotationSubstitutions.getTargetClass(clazz);
        }
        return true;
    }

    private static FixedNode skipNonInterferingNodes(FixedNode node) {
        FixedNode cur = node;
        while (cur instanceof AbstractBeginNode || cur instanceof FullInfopointNode) {
            cur = ((FixedWithNextNode)cur).next();
        }
        return cur;
    }

    private static ValueNode getDeoptProxyOriginalValue(ValueNode node) {
        ValueNode original = node;
        while (original instanceof DeoptProxyNode) {
            original = ((DeoptProxyNode)original).getOriginalNode();
        }
        return original;
    }

    private static FixedNode unwrapNode(FixedNode node) {
        FixedNode successor = node;
        while (true) {
            if (successor instanceof EnsureClassInitializedNode) {
                successor = ((EnsureClassInitializedNode)successor).next();
                continue;
            }
            if (successor instanceof FullInfopointNode) {
                successor = ((FullInfopointNode)successor).next();
                continue;
            }
            if (successor instanceof DeoptEntryNode) {
                assert (SubstrateCompilationDirectives.isDeoptTarget(successor.graph().method()));
                successor = ((DeoptEntryNode)successor).next();
                continue;
            }
            if (!(successor instanceof AbstractBeginNode)) break;
            successor = ((AbstractBeginNode)successor).next();
        }
        return successor;
    }

    private static void registerAtomicUpdaterPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration referenceUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicReferenceFieldUpdater.class);
        referenceUpdaterRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newUpdater", new Type[]{Class.class, Class.class, String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode vclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(b, tclassNode, fieldNameNode);
                return false;
            }
        });
        InvocationPlugins.Registration integerUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicIntegerFieldUpdater.class);
        integerUpdaterRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newUpdater", new Type[]{Class.class, String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(b, tclassNode, fieldNameNode);
                return false;
            }
        });
        InvocationPlugins.Registration longUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicLongFieldUpdater.class);
        longUpdaterRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newUpdater", new Type[]{Class.class, String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(b, tclassNode, fieldNameNode);
                return false;
            }
        });
    }

    private static void interceptUpdaterInvoke(GraphBuilderContext b, ValueNode tclassNode, ValueNode fieldNameNode) {
        Class tclass = SubstrateGraphBuilderPlugins.asConstantObject(b, Class.class, tclassNode);
        String fieldName = SubstrateGraphBuilderPlugins.asConstantObject(b, String.class, fieldNameNode);
        if (tclass != null && fieldName != null) {
            try {
                Field field = tclass.getDeclaredField(fieldName);
                RuntimeReflection.register((Class[])new Class[]{tclass});
                RuntimeReflection.register((Field[])new Field[]{field});
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    private static void registerObjectPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Object.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("clone", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get(true);
                b.addPush(JavaKind.Object, (ValueNode)new SubstrateObjectCloneWithExceptionNode(MacroNode.MacroParams.of((GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (ValueNode[])new ValueNode[]{object})));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("hashCode", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get(true);
                b.addPush(JavaKind.Int, SubstrateIdentityHashCodeNode.create(object, b.bci(), (CoreProviders)b));
                return true;
            }
        });
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins) {
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(new InvocationPlugins.Registration(plugins, "sun.misc.Unsafe"), true);
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe");
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(r, false);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("objectFieldOffset", new Type[]{InvocationPlugin.Receiver.class, Class.class, String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classNode, ValueNode nameNode) {
                Class clazz = SubstrateGraphBuilderPlugins.asConstantObject(b, Class.class, classNode);
                String fieldName = SubstrateGraphBuilderPlugins.asConstantObject(b, String.class, nameNode);
                if (clazz != null && fieldName != null) {
                    Field targetField;
                    try {
                        targetField = clazz.getDeclaredField(fieldName);
                    }
                    catch (LinkageError | ReflectiveOperationException e) {
                        return false;
                    }
                    return SubstrateGraphBuilderPlugins.processFieldOffset(b, receiver, targetField, false);
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new StandardGraphBuilderPlugins.AllocateUninitializedArrayPlugin("allocateUninitializedArray", true));
    }

    private static void registerUnsafePlugins(InvocationPlugins.Registration r, final boolean isSunMiscUnsafe) {
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("staticFieldOffset", new Type[]{InvocationPlugin.Receiver.class, Field.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode fieldNode) {
                Field targetField = SubstrateGraphBuilderPlugins.asConstantObject(b, Field.class, fieldNode);
                if (targetField != null) {
                    return SubstrateGraphBuilderPlugins.processFieldOffset(b, receiver, targetField, isSunMiscUnsafe);
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("staticFieldBase", new Type[]{InvocationPlugin.Receiver.class, Field.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode fieldNode) {
                Field targetField = SubstrateGraphBuilderPlugins.asConstantObject(b, Field.class, fieldNode);
                if (targetField != null) {
                    return SubstrateGraphBuilderPlugins.processStaticFieldBase(b, receiver, targetField, isSunMiscUnsafe);
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("objectFieldOffset", new Type[]{InvocationPlugin.Receiver.class, Field.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode fieldNode) {
                Field targetField = SubstrateGraphBuilderPlugins.asConstantObject(b, Field.class, fieldNode);
                if (targetField != null) {
                    return SubstrateGraphBuilderPlugins.processFieldOffset(b, receiver, targetField, isSunMiscUnsafe);
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("allocateInstance", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode clazz) {
                unsafe.get(true);
                ValueNode clazzNonNull = b.nullCheckedValue(clazz, DeoptimizationAction.None);
                EnsureClassInitializedNode ensureInitialized = (EnsureClassInitializedNode)b.append((Node)new EnsureClassInitializedNode(clazzNonNull));
                ensureInitialized.setStateAfter(b.getInvocationPluginBeforeState());
                ValidateNewInstanceClassNode clazzLegal = (ValidateNewInstanceClassNode)b.add((Node)new ValidateNewInstanceClassNode(clazzNonNull));
                if (b.currentBlockCatchesOOME()) {
                    b.addPush(JavaKind.Object, (ValueNode)new DynamicNewInstanceWithExceptionNode((ValueNode)clazzLegal, true));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)new DynamicNewInstanceNode((ValueNode)clazzLegal, true));
                }
                return true;
            }
        });
    }

    private static boolean processFieldOffset(GraphBuilderContext b, InvocationPlugin.Receiver receiver, Field targetField, boolean isSunMiscUnsafe) {
        if (!SubstrateGraphBuilderPlugins.isValidField(targetField, isSunMiscUnsafe)) {
            return false;
        }
        receiver.get(true);
        b.addPush(JavaKind.Long, FieldOffsetNode.create(JavaKind.Long, b.getMetaAccess().lookupJavaField(targetField)));
        return true;
    }

    private static boolean isValidField(Field targetField, boolean isSunMiscUnsafe) {
        if (targetField == null) {
            return false;
        }
        return !isSunMiscUnsafe || !targetField.getDeclaringClass().isRecord() && !targetField.getDeclaringClass().isHidden();
    }

    private static boolean processStaticFieldBase(GraphBuilderContext b, InvocationPlugin.Receiver receiver, Field targetField, boolean isSunMiscUnsafe) {
        if (!SubstrateGraphBuilderPlugins.isValidField(targetField, isSunMiscUnsafe)) {
            return false;
        }
        receiver.get(true);
        b.addPush(JavaKind.Object, (ValueNode)StaticFieldsSupport.createStaticFieldBaseNode(b.getMetaAccess().lookupJavaField(targetField)));
        return true;
    }

    private static void registerArrayPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Array.class).setAllowOverwrite(true);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newInstance", new Type[]{Class.class, int[].class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazzNode, ValueNode dimensionsNode) {
                Class clazz = SubstrateGraphBuilderPlugins.asConstantObject(b, Class.class, clazzNode);
                int dimensionCount = SubstrateGraphBuilderPlugins.asConstantIntegerOrMinusOne(GraphUtil.arrayLength((ValueNode)dimensionsNode, (ArrayLengthProvider.FindLengthMode)ArrayLengthProvider.FindLengthMode.SEARCH_ONLY, (ConstantReflectionProvider)b.getConstantReflection()));
                if (clazz != null && dimensionCount > 0) {
                    AnalysisType type = (AnalysisType)b.getMetaAccess().lookupJavaType(clazz);
                    for (int i = 0; i < dimensionCount && type.getArrayDimension() < 255; ++i) {
                        type = type.getArrayClass();
                        type.registerAsInstantiated((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)clazzNode));
                    }
                }
                return false;
            }
        });
    }

    private static void registerKnownIntrinsicsPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, KnownIntrinsics.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("heapBase", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, ReadReservedRegister.createReadHeapBaseNode(b.getGraph()));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("readHub", new Type[]{Object.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                ValueNode nonNullObject = b.nullCheckedValue(object);
                b.addPush(JavaKind.Object, (ValueNode)new LoadHubNode(b.getStampProvider(), nonNullObject));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("nonNullPointer", new Type[]{Pointer.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Object, (ValueNode)new PiNode(object, (Stamp)SubstrateGraphBuilderPlugins.nonZeroWord()));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("readStackPointer", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, ReadReservedRegister.createReadStackPointerNode(b.getGraph()));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("readCallerStackPointer", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                SubstrateGraphBuilderPlugins.checkNeverInline(b);
                b.addPush(JavaKind.Object, (ValueNode)new ReadCallerStackPointerNode());
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("readReturnAddress", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                SubstrateGraphBuilderPlugins.checkNeverInline(b);
                b.addPush(JavaKind.Object, (ValueNode)new ReadReturnAddressNode());
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("farReturn", new Type[]{Object.class, Pointer.class, CodePointer.class, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode result, ValueNode sp, ValueNode ip, ValueNode fromMethodWithCalleeSavedRegisters) {
                if (!fromMethodWithCalleeSavedRegisters.isConstant()) {
                    throw b.bailout("parameter fromMethodWithCalleeSavedRegisters is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + String.valueOf(b.getMethod().asStackTraceElement(b.bci())));
                }
                b.add((Node)new FarReturnNode(result, sp, ip, fromMethodWithCalleeSavedRegisters.asJavaConstant().asInt() != 0));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("testDeoptimize", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (!SubstrateCompilationDirectives.isDeoptTarget(b.getMethod())) {
                    b.add((Node)new TestDeoptimizeNode());
                }
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("isDeoptimizationTarget", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)SubstrateCompilationDirectives.isDeoptTarget(b.getGraph().method())));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("unvalidatedAllocateInstance", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode clazz) {
                ValueNode clazzNonNull = b.nullCheckedValue(clazz, DeoptimizationAction.None);
                if (b.currentBlockCatchesOOME()) {
                    b.addPush(JavaKind.Object, (ValueNode)new DynamicNewInstanceWithExceptionNode(clazzNonNull, true));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)new DynamicNewInstanceNode(clazzNonNull, true));
                }
                return true;
            }
        });
        SubstrateGraphBuilderPlugins.registerCastExact(r);
    }

    public static void registerCastExact(InvocationPlugins.Registration r) {
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("castExact", new Type[]{Object.class, Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode javaClass) {
                ValueNode nullCheckedClass = b.nullCheckedValue(javaClass);
                LogicNode condition = (LogicNode)b.append((Node)InstanceOfDynamicNode.create((Assumptions)b.getAssumptions(), (ConstantReflectionProvider)b.getConstantReflection(), (ValueNode)nullCheckedClass, (ValueNode)object, (boolean)true, (boolean)true));
                AbstractBeginNode guard = b.emitBytecodeExceptionCheck(condition, true, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{object, nullCheckedClass});
                if (guard != null) {
                    b.addPush(JavaKind.Object, DynamicPiNode.create((Assumptions)b.getAssumptions(), (ConstantReflectionProvider)b.getConstantReflection(), (ValueNode)object, (GuardingNode)guard, (ValueNode)nullCheckedClass, (boolean)true, (boolean)true));
                } else {
                    b.addPush(JavaKind.Object, object);
                }
                return true;
            }
        });
    }

    private static void checkNeverInline(GraphBuilderContext b) {
        if (!AnnotationAccess.isAnnotationPresent((AnnotatedElement)b.getMethod(), NeverInline.class)) {
            throw VMError.shouldNotReachHere("Accessing the stack pointer or instruction pointer of the caller frame is only safe and deterministic if the method is not inlined. Therefore, the method " + b.getMethod().format("%H.%n(%p)") + " must be annotated with @" + NeverInline.class.getSimpleName());
        }
    }

    private static IntegerStamp nonZeroWord() {
        return StampFactory.forUnsignedInteger((int)64, (long)1L, (long)-1L);
    }

    private static void registerStackValuePlugins(InvocationPlugins plugins) {
        SubstrateGraphBuilderPlugins.registerStackValuePlugins(new InvocationPlugins.Registration(plugins, StackValue.class), true);
        SubstrateGraphBuilderPlugins.registerStackValuePlugins(new InvocationPlugins.Registration(plugins, UnsafeStackValue.class), false);
        InvocationPlugins.Registration unsafeLateStackValue = new InvocationPlugins.Registration(plugins, UnsafeLateStackValue.class);
        unsafeLateStackValue.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sizeNode) {
                b.addPush(JavaKind.Object, (ValueNode)LateStackValueNode.create(sizeNode, b.getGraph().method(), b.bci(), false));
                return true;
            }
        });
    }

    private static void registerStackValuePlugins(InvocationPlugins.Registration r, final boolean disallowVirtualThread) {
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sizeNode) {
                long size = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, sizeNode, "size");
                b.addPush(JavaKind.Object, StackValueNode.create(1L, size, b, disallowVirtualThread));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = SubstrateGraphBuilderPlugins.constantObjectParameter(b, targetMethod, 0, Class.class, classNode);
                int size = SizeOf.get((Class)clazz);
                b.addPush(JavaKind.Object, StackValueNode.create(1L, size, b, disallowVirtualThread));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode numElementsNode, ValueNode elementSizeNode) {
                long numElements = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, numElementsNode, "numElements");
                long elementSize = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, elementSizeNode, "elementSize");
                b.addPush(JavaKind.Object, StackValueNode.create(numElements, elementSize, b, disallowVirtualThread));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Integer.TYPE, Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode numElementsNode, ValueNode classNode) {
                long numElements = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, numElementsNode, "numElements");
                Class clazz = SubstrateGraphBuilderPlugins.constantObjectParameter(b, targetMethod, 0, Class.class, classNode);
                int size = SizeOf.get((Class)clazz);
                b.addPush(JavaKind.Object, StackValueNode.create(numElements, size, b, disallowVirtualThread));
                return true;
            }
        });
    }

    private static void registerClassPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class);
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("getName", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ResolvedJavaType type;
                JavaConstant constantReceiver = receiver.get(false).asJavaConstant();
                if (constantReceiver != null && (type = b.getConstantReflection().asJavaType((Constant)constantReceiver)) != null) {
                    String className = type.toClassName().intern();
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getConstantReflection().forString(className), (MetaAccessProvider)b.getMetaAccess()));
                    return true;
                }
                return false;
            }
        });
        SubstrateGraphBuilderPlugins.registerClassDesiredAssertionStatusPlugin(plugins);
    }

    public static void registerClassDesiredAssertionStatusPlugin(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("desiredAssertionStatus", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                boolean desiredAssertionStatus;
                Object clazzOrHub = SubstrateGraphBuilderPlugins.asConstantObject(b, Object.class, receiver.get(false));
                if (clazzOrHub instanceof Class) {
                    Class clazz = (Class)clazzOrHub;
                    desiredAssertionStatus = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(clazz);
                } else if (clazzOrHub instanceof DynamicHub) {
                    DynamicHub hub = (DynamicHub)clazzOrHub;
                    desiredAssertionStatus = hub.desiredAssertionStatus();
                } else {
                    return false;
                }
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)desiredAssertionStatus));
                return true;
            }
        });
    }

    protected static long longValue(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode node, String name) {
        if (!node.isConstant()) {
            throw b.bailout("parameter " + name + " is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + String.valueOf(b.getMethod().asStackTraceElement(b.bci())));
        }
        return node.asJavaConstant().asLong();
    }

    private static void registerVMConfigurationPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, ImageSingletons.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("contains", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class key = SubstrateGraphBuilderPlugins.constantObjectParameter(b, targetMethod, 0, Class.class, classNode);
                boolean result = ImageSingletons.contains((Class)key);
                if (!result && ImageLayerBuildingSupport.buildingImageLayer() && (ApplicationLayerOnlyImageSingleton.isAssignableFrom(key) || MultiLayeredImageSingleton.class.isAssignableFrom(key))) {
                    result = true;
                }
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)result));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("lookup", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                LayeredImageSingleton layeredSingleton;
                Class key = SubstrateGraphBuilderPlugins.constantObjectParameter(b, targetMethod, 0, Class.class, classNode);
                if (ApplicationLayerOnlyImageSingleton.isAssignableFrom(key) && ImageLayerBuildingSupport.buildingSharedLayer()) {
                    b.addPush(JavaKind.Object, (ValueNode)LoadImageSingletonFactory.loadApplicationOnlyImageSingleton(key, b.getMetaAccess()));
                    return true;
                }
                Object singleton = LayeredImageSingletonSupport.singleton().runtimeLookup(key);
                if (singleton instanceof LayeredImageSingleton && !(layeredSingleton = (LayeredImageSingleton)singleton).getImageBuilderFlags().contains((Object)LayeredImageSingletonBuilderFlags.RUNTIME_ACCESS) && !RuntimeCompilation.isEnabled()) {
                    throw VMError.shouldNotReachHere("Layered image singleton without runtime access is in runtime graph: " + String.valueOf(singleton));
                }
                b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject(singleton), (MetaAccessProvider)b.getMetaAccess()));
                return true;
            }
        });
    }

    private static void registerPlatformPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Platform.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("includedIn", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classNode) {
                Class platform = SubstrateGraphBuilderPlugins.constantObjectParameter(b, targetMethod, 0, Class.class, classNode);
                boolean result = Platform.includedIn((Class)platform);
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)result));
                return true;
            }
        });
    }

    private static void registerSizeOfPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, SizeOf.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = SubstrateGraphBuilderPlugins.constantObjectParameter(b, targetMethod, 0, Class.class, classNode);
                int result = SizeOf.get((Class)clazz);
                b.addPush(JavaKind.Int, (ValueNode)ConstantNode.forInt((int)result));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("unsigned", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = SubstrateGraphBuilderPlugins.constantObjectParameter(b, targetMethod, 0, Class.class, classNode);
                UnsignedWord result = SizeOf.unsigned((Class)clazz);
                b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject((Object)result), (MetaAccessProvider)b.getMetaAccess()));
                return true;
            }
        });
    }

    private static void registerReferencePlugins(InvocationPlugins plugins, final ParsingReason parsingReason) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Reference.class);
        r.register((InvocationPlugin)new StandardGraphBuilderPlugins.ReachabilityFencePlugin(){

            protected boolean useExplicitReachabilityFence(GraphBuilderContext b) {
                return parsingReason != ParsingReason.JITCompilation;
            }
        });
    }

    private static void registerReferenceAccessPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, ReferenceAccessImpl.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getCompressedRepresentation", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode objectNode) {
                receiver.get(true);
                if (ReferenceAccess.singleton().haveCompressedReferences()) {
                    SubstrateCompressionNode compressedObj = SubstrateCompressionNode.compress(b.getGraph(), objectNode, (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class));
                    JavaKind compressedIntKind = JavaKind.fromWordSize((int)ConfigurationValues.getObjectLayout().getReferenceSize());
                    ValueNode compressedValue = (ValueNode)b.add((Node)WordCastNode.narrowOopToUntrackedWord((ValueNode)compressedObj, (JavaKind)compressedIntKind));
                    b.addPush(JavaKind.Object, ZeroExtendNode.convertUnsigned((ValueNode)compressedValue, (Stamp)FrameAccess.getWordStamp(), (NodeView)NodeView.DEFAULT));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)WordCastNode.objectToUntrackedPointer((ValueNode)objectNode, (JavaKind)ConfigurationValues.getWordKind()));
                }
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("uncompressReference", new Type[]{InvocationPlugin.Receiver.class, UnsignedWord.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode wordNode) {
                receiver.get(true);
                if (ReferenceAccess.singleton().haveCompressedReferences()) {
                    CompressEncoding encoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
                    JavaKind compressedIntKind = JavaKind.fromWordSize((int)ConfigurationValues.getObjectLayout().getReferenceSize());
                    NarrowOopStamp compressedStamp = (NarrowOopStamp)SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)StampFactory.object(), encoding);
                    ValueNode narrowNode = (ValueNode)b.add((Node)NarrowNode.convertUnsigned((ValueNode)wordNode, (Stamp)StampFactory.forKind((JavaKind)compressedIntKind), (NodeView)NodeView.DEFAULT));
                    WordCastNode compressedObj = (WordCastNode)b.add((Node)WordCastNode.wordToNarrowObject((ValueNode)narrowNode, (NarrowOopStamp)compressedStamp));
                    b.addPush(JavaKind.Object, (ValueNode)SubstrateCompressionNode.uncompress(b.getGraph(), (ValueNode)compressedObj, encoding));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)WordCastNode.wordToObject((ValueNode)wordNode, (JavaKind)ConfigurationValues.getWordKind()));
                }
                return true;
            }
        });
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport", replacements);
        r.registerConditional(VectorizedMismatchNode.isSupported((Architecture)arch), new InvocationPlugin("vectorizedMismatch", new Type[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode aObject, ValueNode aOffset, ValueNode bObject, ValueNode bOffset, ValueNode length, ValueNode log2ArrayIndexScale) {
                ValueNode aAddr = (ValueNode)b.add((Node)new ComputeObjectAddressNode(aObject, aOffset));
                ValueNode bAddr = (ValueNode)b.add((Node)new ComputeObjectAddressNode(bObject, bOffset));
                b.addPush(JavaKind.Int, (ValueNode)new VectorizedMismatchNode(aAddr, bAddr, length, log2ArrayIndexScale));
                return true;
            }
        });
        r.registerConditional(VectorizedHashCodeNode.isSupported((Architecture)arch), (InvocationPlugin)new StandardGraphBuilderPlugins.VectorizedHashCodeInvocationPlugin("vectorizedHashCode"));
    }

    private static void registerAESPlugins(InvocationPlugins plugins, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CounterMode", replacements);
        r.registerConditional(CounterModeAESNode.isSupported((Architecture)arch), (InvocationPlugin)new StandardGraphBuilderPlugins.CounterModeCryptPlugin(){

            protected boolean canApply(GraphBuilderContext b) {
                return b instanceof BytecodeParser;
            }

            protected ValueNode getFieldOffset(GraphBuilderContext b, ResolvedJavaField field) {
                return FieldOffsetNode.create(JavaKind.Long, field);
            }

            protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) throws ClassNotFoundException {
                Class<?> classAESCrypt = Class.forName("com.sun.crypto.provider.AESCrypt", true, ClassLoader.getSystemClassLoader());
                return metaAccess.lookupJavaType(classAESCrypt);
            }
        });
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CipherBlockChaining", replacements);
        r.registerConditional(CipherBlockChainingAESNode.isSupported((Architecture)arch), (InvocationPlugin)new SubstrateCipherBlockChainingCryptPlugin(AESNode.CryptMode.ENCRYPT));
        r.registerConditional(CipherBlockChainingAESNode.isSupported((Architecture)arch), (InvocationPlugin)new SubstrateCipherBlockChainingCryptPlugin(AESNode.CryptMode.DECRYPT));
    }

    private static <T> T constantObjectParameter(GraphBuilderContext b, ResolvedJavaMethod targetMethod, int parameterIndex, Class<T> declaredType, ValueNode classNode) {
        SubstrateGraphBuilderPlugins.checkParameterUsage(classNode.isConstant(), b, targetMethod, parameterIndex, "parameter is not a compile time constant");
        Object result = b.getSnippetReflection().asObject(declaredType, classNode.asJavaConstant());
        SubstrateGraphBuilderPlugins.checkParameterUsage(result != null, b, targetMethod, parameterIndex, "parameter is null");
        return (T)result;
    }

    public static void checkParameterUsage(boolean condition, GraphBuilderContext b, ResolvedJavaMethod targetMethod, int parameterIndex, String message) {
        Local variable;
        if (condition) {
            return;
        }
        String parameterName = null;
        LocalVariableTable variableTable = targetMethod.getLocalVariableTable();
        if (variableTable != null && (variable = variableTable.getLocal(parameterIndex, 0)) != null) {
            parameterName = variable.getName();
        }
        if (parameterName == null) {
            parameterName = String.valueOf(parameterIndex);
        }
        throw UserError.abort("%s: parameter %s of call to %s in %s", message, parameterName, targetMethod, b.getMethod().asStackTraceElement(b.bci()));
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> DynamicProxyTracing = new HostedOptionKey<Boolean>(false);
    }

    private static class SubstrateCipherBlockChainingCryptPlugin
    extends StandardGraphBuilderPlugins.CipherBlockChainingCryptPlugin {
        SubstrateCipherBlockChainingCryptPlugin(AESNode.CryptMode mode) {
            super(mode);
        }

        protected boolean canApply(GraphBuilderContext b) {
            return b instanceof BytecodeParser;
        }

        protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) throws ClassNotFoundException {
            Class<?> classAESCrypt = Class.forName("com.sun.crypto.provider.AESCrypt", true, ClassLoader.getSystemClassLoader());
            return metaAccess.lookupJavaType(classAESCrypt);
        }
    }
}

