/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.util.ConstantFoldUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

public final class ConstantFoldLoadFieldPlugin
implements NodePlugin {
    private final ParsingReason reason;

    public ConstantFoldLoadFieldPlugin(ParsingReason reason) {
        this.reason = reason;
    }

    public boolean handleLoadField(GraphBuilderContext b, ValueNode receiver, ResolvedJavaField field) {
        if (receiver.isConstant()) {
            JavaConstant asJavaConstant = receiver.asJavaConstant();
            return this.tryConstantFold(b, field, asJavaConstant);
        }
        return false;
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField staticField) {
        return this.tryConstantFold(b, staticField, null);
    }

    private boolean tryConstantFold(GraphBuilderContext b, ResolvedJavaField field, JavaConstant receiver) {
        ConstantNode result;
        try {
            result = ConstantFoldUtil.tryConstantFold((ConstantFieldProvider)b.getConstantFieldProvider(), (ConstantReflectionProvider)b.getConstantReflection(), (MetaAccessProvider)b.getMetaAccess(), (ResolvedJavaField)field, (JavaConstant)receiver, (OptionValues)b.getOptions(), (Object)b.getGraph().currentNodeSourcePosition());
        }
        catch (UnsupportedFeatureException e) {
            if (this.reason.duringAnalysis()) {
                AnalysisMetaAccess metaAccess = (AnalysisMetaAccess)b.getMetaAccess();
                ObjectScanner.unsupportedFeatureDuringFieldFolding((BigBang)metaAccess.getUniverse().getBigbang(), (AnalysisField)((AnalysisField)field), (JavaConstant)receiver, (Throwable)e, (AnalysisMethod)((AnalysisMethod)b.getMethod()), (int)b.bci());
                b.add((Node)new LoweredDeadEndNode());
                return true;
            }
            throw e;
        }
        if (result != null) {
            assert (result.asJavaConstant() != null);
            result = (ConstantNode)b.getGraph().unique((Node)result);
            b.push(field.getJavaKind(), (ValueNode)result);
            return true;
        }
        return false;
    }
}

