/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedPrimitiveType;
import com.oracle.svm.hosted.meta.HostedType;
import java.io.PrintWriter;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class HostedUniverse
implements Universe {
    protected final Inflation bb;
    protected final Map<AnalysisType, HostedType> types = new HashMap<AnalysisType, HostedType>();
    protected final Map<AnalysisField, HostedField> fields = new HashMap<AnalysisField, HostedField>();
    protected final Map<AnalysisMethod, HostedMethod> methods = new HashMap<AnalysisMethod, HostedMethod>();
    protected final Map<ResolvedSignature<AnalysisType>, ResolvedSignature<HostedType>> signatures = new HashMap<ResolvedSignature<AnalysisType>, ResolvedSignature<HostedType>>();
    protected final Map<ConstantPool, WrappedConstantPool> constantPools = new HashMap<ConstantPool, WrappedConstantPool>();
    protected EnumMap<JavaKind, HostedType> kindToType = new EnumMap(JavaKind.class);
    protected List<HostedType> orderedTypes;
    protected List<HostedField> orderedFields;
    protected List<HostedMethod> orderedMethods;
    public static final Comparator<HostedType> TYPE_COMPARATOR = new TypeComparator();
    public static final Comparator<HostedMethod> METHOD_COMPARATOR = new MethodComparator(TYPE_COMPARATOR);
    static final Comparator<HostedField> FIELD_COMPARATOR_RELAXED = Comparator.comparing(JavaField::getJavaKind).reversed();

    public HostedUniverse(Inflation bb) {
        this.bb = bb;
    }

    public HostedType getType(JavaKind kind) {
        assert (this.kindToType.containsKey(kind));
        return this.kindToType.get(kind);
    }

    public HostedInstanceClass getObjectClass() {
        HostedInstanceClass result = (HostedInstanceClass)this.kindToType.get(JavaKind.Object);
        assert (result != null);
        return result;
    }

    public boolean contains(JavaType type) {
        return this.types.containsKey(type);
    }

    public SVMHost hostVM() {
        return this.bb.getHostVM();
    }

    public SnippetReflectionProvider getSnippetReflection() {
        return this.bb.getSnippetReflectionProvider();
    }

    public HostedType lookup(JavaType type) {
        JavaType result = this.lookupAllowUnresolved(type);
        if (result == null) {
            return null;
        }
        if (result instanceof ResolvedJavaType) {
            return (HostedType)result;
        }
        throw new UnsupportedFeatureException("Unresolved type found. Probably there are some compilation or classpath problems. " + type.toJavaName(true));
    }

    public JavaType lookupAllowUnresolved(JavaType type) {
        if (!(type instanceof ResolvedJavaType)) {
            return type;
        }
        assert (this.types.containsKey(type)) : type;
        return this.optionalLookup(type);
    }

    public HostedType optionalLookup(JavaType type) {
        return this.types.get(type);
    }

    public HostedType[] optionalLookup(JavaType ... javaTypes) {
        HostedType[] result = new HostedType[javaTypes.length];
        for (int i = 0; i < javaTypes.length; ++i) {
            result[i] = this.optionalLookup(javaTypes[i]);
            if (result[i] != null) continue;
            return null;
        }
        return result;
    }

    public HostedField lookup(JavaField field) {
        JavaField result = this.lookupAllowUnresolved(field);
        if (result instanceof ResolvedJavaField) {
            return (HostedField)result;
        }
        throw new UnsupportedFeatureException("Unresolved field found. Probably there are some compilation or classpath problems. " + field.format("%H.%n"));
    }

    public JavaField lookupAllowUnresolved(JavaField field) {
        if (!(field instanceof ResolvedJavaField)) {
            return field;
        }
        assert (this.fields.containsKey(field)) : field;
        return this.optionalLookup(field);
    }

    public HostedField optionalLookup(JavaField field) {
        return this.fields.get(field);
    }

    private static void ensureOriginalMethod(JavaMethod method) {
        if (method instanceof MultiMethod) {
            MultiMethod.MultiMethodKey key = ((MultiMethod)method).getMultiMethodKey();
            VMError.guarantee(key == MultiMethod.ORIGINAL_METHOD, "looking up method with wrong id: %s", key);
        }
    }

    public HostedMethod lookup(JavaMethod method) {
        HostedUniverse.ensureOriginalMethod(method);
        JavaMethod result = this.lookupAllowUnresolved(method);
        if (result instanceof ResolvedJavaMethod) {
            return (HostedMethod)result;
        }
        throw new UnsupportedFeatureException("Unresolved method found: " + (method != null ? method.format("%H.%n(%p)") : "null") + ". Probably there are some compilation or classpath problems. ");
    }

    public JavaMethod lookupAllowUnresolved(JavaMethod method) {
        HostedUniverse.ensureOriginalMethod(method);
        if (!(method instanceof ResolvedJavaMethod)) {
            return method;
        }
        assert (this.methods.containsKey(method)) : method;
        return this.optionalLookup(method);
    }

    public HostedMethod optionalLookup(JavaMethod method) {
        HostedUniverse.ensureOriginalMethod(method);
        return this.methods.get(method);
    }

    public HostedMethod[] lookup(JavaMethod[] inputs) {
        HostedMethod[] result = new HostedMethod[inputs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.lookup(inputs[i]);
        }
        return result;
    }

    public ResolvedSignature<HostedType> lookup(Signature signature, ResolvedJavaType defaultAccessingClass) {
        assert (this.signatures.containsKey(signature)) : signature;
        return this.signatures.get(signature);
    }

    public WrappedConstantPool lookup(ConstantPool constantPool, ResolvedJavaType defaultAccessingClass) {
        assert (this.constantPools.containsKey(constantPool)) : constantPool;
        return this.constantPools.get(constantPool);
    }

    public JavaConstant lookup(JavaConstant c) {
        VMError.guarantee(c == null || c.isNull() || c.getJavaKind().isPrimitive() || c instanceof ImageHeapConstant);
        return c;
    }

    public Collection<HostedType> getTypes() {
        return this.orderedTypes;
    }

    public Collection<HostedField> getFields() {
        return this.orderedFields;
    }

    public Collection<HostedMethod> getMethods() {
        return this.orderedMethods;
    }

    public Inflation getBigBang() {
        return this.bb;
    }

    public HostedType objectType() {
        return this.types.get(this.bb.getUniverse().objectType());
    }

    public void printTypes() {
        String reportsPath = SubstrateOptions.reportsPath();
        ReportUtils.report((String)"hosted universe", (String)reportsPath, (String)"universe_analysis", (String)"txt", writer -> this.printTypes((PrintWriter)writer));
    }

    private void printTypes(PrintWriter writer) {
        for (HostedType type : this.getTypes()) {
            Object arrayType;
            int n;
            writer.format("%8d %s  ", type.getTypeID(), type.toJavaName(true));
            if (type.getSuperclass() != null) {
                writer.format("extends %d %s  ", type.getSuperclass().getTypeID(), type.getSuperclass().toJavaName(false));
            }
            if (type.getInterfaces().length > 0) {
                writer.print("implements ");
                String sep = "";
                HostedInterface[] hostedInterfaceArray = type.getInterfaces();
                int n2 = hostedInterfaceArray.length;
                for (n = 0; n < n2; ++n) {
                    HostedInterface interf = hostedInterfaceArray[n];
                    writer.format("%s%d %s", sep, interf.getTypeID(), interf.toJavaName(false));
                    sep = ", ";
                }
                writer.print("  ");
            }
            if (type.getWrapped().isInstantiated()) {
                writer.print("instantiated  ");
            }
            if (type.getWrapped().isReachable()) {
                writer.print("reachable  ");
            }
            if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
                writer.format("type check start %d range %d slot # %d ", type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot());
                writer.format("type check slots %s  ", HostedUniverse.slotsToString(type.getClosedTypeWorldTypeCheckSlots()));
            } else {
                writer.format("type id %s depth %s num class types %s num interface types %s ", type.getTypeID(), type.getTypeIDDepth(), type.getNumClassTypes(), type.getNumInterfaceTypes());
                writer.format("type check slots %s  ", String.join((CharSequence)" ", (CharSequence[])Arrays.stream(type.getOpenTypeWorldTypeCheckSlots()).mapToObj(Integer::toString).toArray(String[]::new)));
            }
            int le = type.getHub().getLayoutEncoding();
            if (LayoutEncoding.isPrimitive(le)) {
                writer.print("primitive  ");
            } else if (LayoutEncoding.isInterface(le)) {
                writer.print("interface  ");
            } else if (LayoutEncoding.isAbstract(le)) {
                writer.print("abstract  ");
            } else if (LayoutEncoding.isPureInstance(le)) {
                writer.format("instance size %d  ", LayoutEncoding.getPureInstanceAllocationSize(le).rawValue());
            } else if (LayoutEncoding.isArrayLike(le)) {
                arrayType = LayoutEncoding.isHybrid(le) ? "hybrid" : "array";
                String elements = LayoutEncoding.isArrayLikeWithPrimitiveElements(le) ? "primitives" : "objects";
                writer.format("%s containing %s, base %d shift %d scale %d  ", arrayType, elements, LayoutEncoding.getArrayBaseOffset(le).rawValue(), LayoutEncoding.getArrayIndexShift(le), LayoutEncoding.getArrayIndexScale(le));
            } else {
                throw VMError.shouldNotReachHereUnexpectedInput(le);
            }
            writer.println();
            arrayType = type.getSubTypes();
            int elements = ((HostedType[])arrayType).length;
            for (n = 0; n < elements; ++n) {
                HostedType sub = arrayType[n];
                writer.format("               s %d %s%n", sub.getTypeID(), sub.toJavaName(false));
            }
            if (type.isInterface()) {
                for (HostedMethod method : this.getMethods()) {
                    if (!method.getDeclaringClass().equals(type)) continue;
                    HostedUniverse.printMethod(writer, method, -1);
                }
                continue;
            }
            if (!type.isInstanceClass()) continue;
            HostedField[] instanceFields = type.getInstanceFields(false);
            instanceFields = Arrays.copyOf(instanceFields, instanceFields.length);
            Arrays.sort(instanceFields, Comparator.comparing(HostedField::toString));
            HostedField[] method = instanceFields;
            n = method.length;
            for (int sub = 0; sub < n; ++sub) {
                HostedField field = method[sub];
                writer.println("               f " + field.getLocation() + ": " + field.format("%T %n"));
            }
            HostedMethod[] vtable = type.getVTable();
            for (int i = 0; i < vtable.length; ++i) {
                if (vtable[i] == null) continue;
                HostedUniverse.printMethod(writer, vtable[i], i);
            }
            for (HostedMethod method2 : this.getMethods()) {
                if (!method2.getDeclaringClass().equals(type) || method2.hasVTableIndex()) continue;
                HostedUniverse.printMethod(writer, method2, -1);
            }
        }
    }

    private static void printMethod(PrintWriter writer, HostedMethod method, int vtableIndex) {
        if (vtableIndex != -1) {
            writer.print("               v " + vtableIndex + " ");
        } else {
            writer.print("               m ");
        }
        if (method.hasVTableIndex()) {
            writer.print(method.getVTableIndex() + " ");
        }
        writer.print(method.format("%r %n(%p)") + ": " + method.getImplementations().length + " [");
        if (method.getImplementations().length <= 10) {
            String sep = "";
            for (HostedMethod impl : method.getImplementations()) {
                writer.print(sep + impl.getDeclaringClass().toJavaName(false));
                sep = ", ";
            }
        }
        writer.println("]");
    }

    private static String slotsToString(short[] slots) {
        if (slots == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder();
        for (short slot : slots) {
            result.append(Short.toUnsignedInt(slot)).append(" ");
        }
        return result.toString();
    }

    private static final class TypeComparator
    implements Comparator<HostedType> {
        private TypeComparator() {
        }

        private static Optional<HostedType[]> proxyType(HostedType type) {
            HostedType baseType = type.getBaseType();
            boolean isProxy = Proxy.isProxyClass(baseType.getJavaClass());
            assert (isProxy == (baseType.toJavaName(false).startsWith("$Proxy") && !(type.getWrapped().getWrapped() instanceof BaseLayerType)));
            if (isProxy) {
                return Optional.of(baseType.getInterfaces());
            }
            return Optional.empty();
        }

        @Override
        public int compare(HostedType o1, HostedType o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            Optional<HostedType[]> o1ProxyType = TypeComparator.proxyType(o1);
            Optional<HostedType[]> o2ProxyType = TypeComparator.proxyType(o2);
            if (o1ProxyType.isPresent() || o2ProxyType.isPresent()) {
                HostedType[] array2;
                HostedType[] array1 = o1ProxyType.orElseGet(() -> new HostedType[]{o1});
                int result = Arrays.compare(array1, array2 = o2ProxyType.orElseGet(() -> new HostedType[]{o2}), TYPE_COMPARATOR);
                if (result == 0) {
                    result = Boolean.compare(o1ProxyType.isPresent(), o2ProxyType.isPresent());
                }
                if (result == 0) {
                    assert (o1.isArray() || o2.isArray());
                    result = Integer.compare(o1.getArrayDimension(), o2.getArrayDimension());
                }
                VMError.guarantee(result != 0, "HostedType proxies not distinguishable: %s, %s", o1, o2);
                return result;
            }
            if (!o1.getClass().equals(o2.getClass())) {
                int result = Integer.compare(TypeComparator.ordinal(o1), TypeComparator.ordinal(o2));
                VMError.guarantee(result != 0, "HostedType objects not distinguishable by ordinal number: %s, %s", o1, o2);
                return result;
            }
            if (o1.isPrimitive() && o2.isPrimitive()) {
                assert (o1 instanceof HostedPrimitiveType && o2 instanceof HostedPrimitiveType);
                int result = o1.getJavaKind().compareTo((Enum)o2.getJavaKind());
                VMError.guarantee(result != 0, "HostedPrimitiveType objects not distinguishable by javaKind: %s, %s", o1, o2);
                return result;
            }
            if (o1.isArray() && o2.isArray()) {
                assert (o1 instanceof HostedArrayClass && o2 instanceof HostedArrayClass);
                int result = this.compare(o1.getComponentType(), o2.getComponentType());
                VMError.guarantee(result != 0, "HostedArrayClass objects not distinguishable by componentType: %s, %s", o1, o2);
                return result;
            }
            int result = o1.getName().compareTo(o2.getName());
            if (result != 0) {
                return result;
            }
            ClassLoader l1 = Optional.ofNullable(o1.getJavaClass()).map(Class::getClassLoader).orElse(null);
            ClassLoader l2 = Optional.ofNullable(o2.getJavaClass()).map(Class::getClassLoader).orElse(null);
            result = SubstrateUtil.runtimeClassLoaderNameAndId(l1).compareTo(SubstrateUtil.runtimeClassLoaderNameAndId(l2));
            VMError.guarantee(result != 0, "HostedType objects not distinguishable by name and classloader: %s, %s", o1, o2);
            return result;
        }

        private static int ordinal(HostedType type) {
            if (type.isInterface()) {
                return 4;
            }
            if (type.isArray()) {
                return 3;
            }
            if (type.isInstanceClass()) {
                return 2;
            }
            if (type.getJavaKind() != JavaKind.Object) {
                return 1;
            }
            throw VMError.shouldNotReachHereUnexpectedInput(type);
        }
    }

    private static final class MethodComparator
    implements Comparator<HostedMethod> {
        private final Comparator<HostedType> typeComparator;

        private MethodComparator(Comparator<HostedType> typeComparator) {
            this.typeComparator = typeComparator;
        }

        @Override
        public int compare(HostedMethod o1, HostedMethod o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            int result = Boolean.compare(o1.isDeoptTarget(), o2.isDeoptTarget());
            if (result != 0) {
                return result;
            }
            result = this.typeComparator.compare(o1.getDeclaringClass(), o2.getDeclaringClass());
            if (result != 0) {
                return result;
            }
            result = o1.getName().compareTo(o2.getName());
            if (result != 0) {
                return result;
            }
            ResolvedSignature<HostedType> signature1 = o1.getSignature();
            ResolvedSignature<HostedType> signature2 = o2.getSignature();
            int parameterCount1 = signature1.getParameterCount(false);
            result = Integer.compare(parameterCount1, signature2.getParameterCount(false));
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < parameterCount1; ++i) {
                result = this.typeComparator.compare((HostedType)signature1.getParameterType(i), (HostedType)signature2.getParameterType(i));
                if (result == 0) continue;
                return result;
            }
            result = this.typeComparator.compare((HostedType)signature1.getReturnType(), (HostedType)signature2.getReturnType());
            if (result != 0) {
                return result;
            }
            throw VMError.shouldNotReachHere("HostedMethod objects not distinguishable: " + String.valueOf(o1) + ", " + String.valueOf(o2));
        }
    }
}

