/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted.runtimecompilation;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptEntrySupport;
import com.oracle.svm.core.graal.nodes.DeoptProxyAnchorNode;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.graal.TruffleRuntimeCompilationSupport;
import com.oracle.svm.graal.hosted.runtimecompilation.GraalGraphObjectReplacer;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantFieldProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.DeoptimizationUtils;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedConstantFieldProvider;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.phases.AnalysisGraphBuilderPhase;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.Phase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DominatorBasedGlobalValueNumberingPhase;
import jdk.graal.compiler.phases.common.IterativeConditionalEliminationPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.MacroWithExceptionNode;
import jdk.graal.compiler.truffle.nodes.ObjectLocationIdentity;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.word.LocationIdentity;

public class RuntimeCompiledMethodSupport {
    public static void onCompileQueueCreation(BigBang bb, HostedUniverse hUniverse, CompileQueue compileQueue, HostedProviders hostedProviders, Function<ConstantFieldProvider, ConstantFieldProvider> constantFieldProviderWrapper, GraalGraphObjectReplacer objectReplacer, Set<AnalysisMethod> registeredRuntimeCompilations, Stream<HostedMethod> methodsToCompile) {
        ImageHeapScanner imageScanner = bb.getUniverse().getHeapScanner();
        RuntimeCompilationGraphEncoder graphEncoder = new RuntimeCompilationGraphEncoder(ConfigurationValues.getTarget().arch, imageScanner);
        HostedProviders runtimeCompilationProviders = hostedProviders.copyWith(constantFieldProviderWrapper.apply((ConstantFieldProvider)new RuntimeCompilationFieldProvider(hostedProviders.getMetaAccess(), hUniverse))).copyWith((ConstantReflectionProvider)new RuntimeCompilationReflectionProvider(bb, hUniverse.hostVM().getClassInitializationSupport()));
        SubstrateCompilationDirectives.singleton().resetDeoptEntries();
        CompilationState compilationState = new CompilationState(objectReplacer, graphEncoder, runtimeCompilationProviders, imageScanner, new ConcurrentHashMap<HostedMethod, StructuredGraph>(), registeredRuntimeCompilations);
        CompletionExecutor executor = compileQueue.getExecutor();
        try {
            compileQueue.runOnExecutor(() -> methodsToCompile.forEach(method -> executor.execute((CompletionExecutor.DebugContextRunnable)new RuntimeCompileTask((HostedMethod)method, compilationState))));
        }
        catch (InterruptedException exception) {
            VMError.shouldNotReachHere(exception);
        }
        RuntimeCompiledMethodSupport.encodeRuntimeCompiledMethods(hUniverse, compilationState);
        CompileQueue.ParseHooks deoptParseHooks = new CompileQueue.ParseHooks(compileQueue){

            @Override
            protected PhaseSuite<HighTierContext> getAfterParseSuite() {
                PhaseSuite<HighTierContext> suite = super.getAfterParseSuite();
                if (Options.RemoveUnneededDeoptSupport.getValue().booleanValue()) {
                    suite.prependPhase((BasePhase)new RemoveUnneededDeoptSupport());
                }
                return suite;
            }
        };
        hUniverse.getMethods().stream().map(method -> method.getMultiMethod(SubstrateCompilationDirectives.DEOPT_TARGET_METHOD)).filter(method -> {
            if (method != null) {
                return compileQueue.isRegisteredDeoptTarget((HostedMethod)method);
            }
            return false;
        }).forEach(method -> method.compilationInfo.setCustomParseHooks(deoptParseHooks));
    }

    static boolean verifyNodes(StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            boolean invalidNodeKind;
            boolean bl = invalidNodeKind = node instanceof BytecodeExceptionNode || node instanceof ThrowBytecodeExceptionNode;
            assert (!invalidNodeKind) : "illegal node in graph: " + String.valueOf(node) + " method: " + String.valueOf(graph.method());
        }
        return true;
    }

    private static void encodeRuntimeCompiledMethods(HostedUniverse hUniverse, CompilationState compilationState) {
        compilationState.graphEncoder.finishPrepare();
        SubstrateCompilationDirectives.singleton().sealDeoptimizationInfo();
        for (Map.Entry<HostedMethod, StructuredGraph> runtimeInfo : compilationState.runtimeGraphs.entrySet()) {
            StructuredGraph graph = runtimeInfo.getValue();
            HostedMethod method = runtimeInfo.getKey();
            DebugContext debug = new DebugContext.Builder(graph.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory(compilationState.runtimeCompilationProviders.getSnippetReflection())).build();
            graph.resetDebug(debug);
            try {
                DebugContext.Scope s = debug.scope((Object)"Graph Encoding", (Object)graph);
                try {
                    DebugContext.Activation a = debug.activate();
                    try {
                        long startOffset = compilationState.graphEncoder.encode(graph);
                        compilationState.objectReplacer.createMethod(method).setEncodedGraphStartOffset(startOffset);
                    }
                    finally {
                        if (a == null) continue;
                        a.close();
                    }
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
        }
        HeapBreakdownProvider.singleton().setGraphEncodingByteLength(compilationState.graphEncoder.getEncoding().length);
        TruffleRuntimeCompilationSupport.setGraphEncoding(null, compilationState.graphEncoder.getEncoding(), compilationState.graphEncoder.getObjects(), compilationState.graphEncoder.getNodeClasses());
        compilationState.objectReplacer.setMethodsImplementations(hUniverse);
    }

    public static class RuntimeCompilationGraphEncoder
    extends GraphEncoder {
        private final ImageHeapScanner heapScanner;
        private final Map<ImageHeapConstant, LocationIdentity> locationIdentityCache;

        public RuntimeCompilationGraphEncoder(Architecture architecture, ImageHeapScanner heapScanner) {
            super(architecture);
            this.heapScanner = heapScanner;
            this.locationIdentityCache = new ConcurrentHashMap<ImageHeapConstant, LocationIdentity>();
        }

        protected GraphDecoder graphDecoderForVerification(StructuredGraph decodedGraph) {
            return new RuntimeCompilationGraphDecoder(this.architecture, decodedGraph, this.heapScanner);
        }

        protected Object replaceObjectForEncoding(Object object) {
            ObjectLocationIdentity oli;
            JavaConstant javaConstant;
            if (object instanceof ImageHeapConstant) {
                ImageHeapConstant heapConstant = (ImageHeapConstant)object;
                return SubstrateGraalUtils.hostedToRuntime(heapConstant, this.heapScanner.getConstantReflection());
            }
            if (object instanceof ObjectLocationIdentity && (javaConstant = (oli = (ObjectLocationIdentity)object).getObject()) instanceof ImageHeapConstant) {
                ImageHeapConstant heapConstant = (ImageHeapConstant)javaConstant;
                return this.locationIdentityCache.computeIfAbsent(heapConstant, hc -> ObjectLocationIdentity.create((JavaConstant)SubstrateGraalUtils.hostedToRuntime(hc, this.heapScanner.getConstantReflection())));
            }
            return object;
        }
    }

    static class RuntimeCompilationFieldProvider
    extends AnalysisConstantFieldProvider {
        final HostedUniverse hUniverse;

        RuntimeCompilationFieldProvider(MetaAccessProvider metaAccess, HostedUniverse hUniverse) {
            super(metaAccess, hUniverse.hostVM());
            this.hUniverse = hUniverse;
        }

        @Override
        public boolean isFinalField(ResolvedJavaField f, ConstantFieldProvider.ConstantFieldTool<?> tool) {
            HostedField hField = this.hUniverse.lookup((JavaField)f);
            if (HostedConstantFieldProvider.isFinalField(hField)) {
                return true;
            }
            return super.isFinalField(f, tool);
        }
    }

    static class RuntimeCompilationReflectionProvider
    extends AnalysisConstantReflectionProvider {
        RuntimeCompilationReflectionProvider(BigBang bb, ClassInitializationSupport classInitializationSupport) {
            super(bb.getUniverse(), (UniverseMetaAccess)bb.getMetaAccess(), classInitializationSupport);
        }

        @Override
        public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
            return this.readValue((AnalysisField)field, receiver, true, false);
        }
    }

    private record CompilationState(GraalGraphObjectReplacer objectReplacer, GraphEncoder graphEncoder, HostedProviders runtimeCompilationProviders, ImageHeapScanner heapScanner, Map<HostedMethod, StructuredGraph> runtimeGraphs, Set<AnalysisMethod> registeredRuntimeCompilations) {
    }

    private static class RuntimeCompileTask
    implements CompletionExecutor.DebugContextRunnable {
        final HostedMethod method;
        final CompilationState compilationState;

        RuntimeCompileTask(HostedMethod method, CompilationState compilationState) {
            this.method = method;
            this.compilationState = compilationState;
        }

        public DebugContext getDebug(OptionValues options, List<DebugHandlersFactory> factories) {
            return new DebugContext.Builder(options, factories).description(this.getDescription()).build();
        }

        public void run(DebugContext debug) {
            this.compileRuntimeCompiledMethod(debug);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void compileRuntimeCompiledMethod(DebugContext debug) {
            assert (this.method.getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
            boolean trackNodeSourcePosition = SubstrateOptions.IncludeNodeSourcePositions.getValue();
            AnalysisMethod aMethod = this.method.getWrapped();
            StructuredGraph graph = aMethod.decodeAnalyzedGraph(debug, null, trackNodeSourcePosition, false, (arch, analyzedGraph) -> new RuntimeCompilationGraphDecoder((Architecture)arch, (StructuredGraph)analyzedGraph, this.compilationState.heapScanner));
            if (graph == null) {
                throw VMError.shouldNotReachHere("Method not parsed during static analysis: " + aMethod.format("%r %H.%n(%p)"));
            }
            aMethod.clearAnalyzedGraph();
            if (!trackNodeSourcePosition) {
                for (Node node : graph.getNodes()) {
                    node.clearNodeSourcePosition();
                }
            }
            try (DebugContext.Scope s = debug.scope((Object)"RuntimeOptimize", (Object)graph, (Object)this.method, (Object)this);){
                CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
                canonicalizer.apply(graph, (Object)this.compilationState.runtimeCompilationProviders);
                new DominatorBasedGlobalValueNumberingPhase(canonicalizer).apply(graph, (Object)this.compilationState.runtimeCompilationProviders);
                new IterativeConditionalEliminationPhase(canonicalizer, true).apply(graph, (Object)this.compilationState.runtimeCompilationProviders);
                new ConvertDeoptimizeToGuardPhase(canonicalizer).apply(graph, (Object)this.compilationState.runtimeCompilationProviders);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            AnalysisMethod origMethod = this.method.getMultiMethod(MultiMethod.ORIGINAL_METHOD).getWrapped();
            DeoptimizationUtils.registerDeoptEntries(graph, this.compilationState.registeredRuntimeCompilations.contains(origMethod), deoptEntryMethod -> {
                PointsToAnalysisMethod deoptMethod = (PointsToAnalysisMethod)((PointsToAnalysisMethod)deoptEntryMethod).getMultiMethod(SubstrateCompilationDirectives.DEOPT_TARGET_METHOD);
                VMError.guarantee(deoptMethod != null, "New deopt target method seen: %s", deoptEntryMethod);
                return deoptMethod;
            });
            assert (RuntimeCompiledMethodSupport.verifyNodes(graph));
            StructuredGraph previous = this.compilationState.runtimeGraphs.put(this.method, graph);
            assert (previous == null);
            GraphEncoder graphEncoder = this.compilationState.graphEncoder;
            synchronized (graphEncoder) {
                this.compilationState.graphEncoder.prepare(graph);
            }
        }
    }

    private static class RemoveUnneededDeoptSupport
    extends Phase {
        private RemoveUnneededDeoptSupport() {
        }

        protected void run(StructuredGraph graph) {
            EconomicMap decisionCache = EconomicMap.create();
            for (DeoptProxyNode proxyNode : graph.getNodes(DeoptProxyNode.TYPE).snapshot()) {
                ValueNode proxyPoint = proxyNode.getProxyPoint();
                if (!(proxyPoint instanceof StateSplit) || this.getDecision((StateSplit)proxyPoint, (EconomicMap<StateSplit, RemovalDecision>)decisionCache) != RemovalDecision.REMOVE) continue;
                proxyNode.replaceAtAllUsages((Node)proxyNode.getOriginalNode(), true);
                proxyNode.safeDelete();
            }
            for (DeoptEntryNode deoptEntry : graph.getNodes().filter(DeoptEntryNode.class).snapshot()) {
                switch (this.getDecision(deoptEntry, (EconomicMap<StateSplit, RemovalDecision>)decisionCache).ordinal()) {
                    case 2: {
                        deoptEntry.killExceptionEdge();
                        graph.removeSplit((ControlSplitNode)deoptEntry, deoptEntry.getPrimarySuccessor());
                        break;
                    }
                    case 1: {
                        deoptEntry.killExceptionEdge();
                        DeoptProxyAnchorNode newAnchor = (DeoptProxyAnchorNode)graph.add((Node)new DeoptProxyAnchorNode(deoptEntry.getProxifiedInvokeBci()));
                        newAnchor.setStateAfter(deoptEntry.stateAfter());
                        graph.replaceSplitWithFixed((ControlSplitNode)deoptEntry, (FixedWithNextNode)newAnchor, deoptEntry.getPrimarySuccessor());
                    }
                }
            }
            for (DeoptProxyAnchorNode proxyAnchor : graph.getNodes().filter(DeoptProxyAnchorNode.class).snapshot()) {
                if (this.getDecision(proxyAnchor, (EconomicMap<StateSplit, RemovalDecision>)decisionCache) != RemovalDecision.REMOVE) continue;
                graph.removeFixed((FixedWithNextNode)proxyAnchor);
            }
        }

        RemovalDecision getDecision(StateSplit node, EconomicMap<StateSplit, RemovalDecision> decisionCache) {
            int proxifiedInvokeBci;
            DeoptEntrySupport proxyNode;
            RemovalDecision cached = (RemovalDecision)((Object)decisionCache.get((Object)node));
            if (cached != null) {
                return cached;
            }
            if (node instanceof ExceptionObjectNode) {
                ExceptionObjectNode exceptionObject = (ExceptionObjectNode)node;
                proxyNode = (DeoptEntrySupport)exceptionObject.predecessor();
            } else {
                proxyNode = (DeoptEntrySupport)node;
            }
            RemovalDecision decision = RemovalDecision.REMOVE;
            SubstrateCompilationDirectives directive = SubstrateCompilationDirectives.singleton();
            FrameState state = proxyNode.stateAfter();
            HostedMethod method = (HostedMethod)state.getMethod();
            if (proxyNode instanceof DeoptEntryNode && directive.isDeoptEntry(method, state.bci, state.getStackState())) {
                decision = RemovalDecision.KEEP;
            }
            if (decision == RemovalDecision.REMOVE && (proxifiedInvokeBci = proxyNode.getProxifiedInvokeBci()) != -5 && directive.isDeoptEntry(method, proxifiedInvokeBci, FrameState.StackState.AfterPop)) {
                decision = proxyNode instanceof DeoptEntryNode ? RemovalDecision.PROXIFY : RemovalDecision.KEEP;
            }
            decisionCache.put((Object)node, (Object)decision);
            if (proxyNode != node) {
                decisionCache.put((Object)proxyNode, (Object)decision);
            }
            return decision;
        }

        public CharSequence getName() {
            return "RemoveUnneededDeoptSupport";
        }

        static enum RemovalDecision {
            KEEP,
            PROXIFY,
            REMOVE;

        }
    }

    public static class ConvertMacroNodes
    extends Phase {
        protected void run(StructuredGraph graph) {
            for (Node n : graph.getNodes().snapshot()) {
                VMError.guarantee(!(n instanceof MacroNode), "DeoptTarget Methods do not support Macro Nodes: method %s, node %s", graph.method(), n);
                if (!(n instanceof MacroWithExceptionNode)) continue;
                MacroWithExceptionNode macro = (MacroWithExceptionNode)n;
                macro.replaceWithInvoke();
            }
        }
    }

    private static final class RuntimeBytecodeParser
    extends AnalysisGraphBuilderPhase.AnalysisBytecodeParser {
        RuntimeBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, SVMHost svmHost) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, svmHost, false);
        }

        @Override
        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            boolean result = super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
            if (result) {
                SubstrateCompilationDirectives.singleton().registerAsDeoptInlininingExclude(targetMethod);
            }
            return result;
        }

        @Override
        protected boolean shouldVerifyFrameStates() {
            return Options.VerifyRuntimeCompilationFrameStates.getValue();
        }
    }

    static final class RuntimeGraphBuilderPhase
    extends AnalysisGraphBuilderPhase {
        private RuntimeGraphBuilderPhase(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, SVMHost hostVM) {
            super((CoreProviders)providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, hostVM);
        }

        static RuntimeGraphBuilderPhase createRuntimeGraphBuilderPhase(BigBang bb, Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts) {
            GraphBuilderConfiguration newGraphBuilderConfig = graphBuilderConfig.withEagerResolving(true).withUnresolvedIsError(false);
            return new RuntimeGraphBuilderPhase(providers, newGraphBuilderConfig, optimisticOpts, null, (SVMHost)bb.getHostVM());
        }

        @Override
        protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            return new RuntimeBytecodeParser((GraphBuilderPhase.Instance)this, graph, parent, method, entryBCI, intrinsicContext, this.hostVM);
        }
    }

    static class RuntimeCompilationGraphDecoder
    extends GraphDecoder {
        private final ImageHeapScanner heapScanner;
        private final Map<JavaConstant, LocationIdentity> locationIdentityCache;

        RuntimeCompilationGraphDecoder(Architecture architecture, StructuredGraph graph, ImageHeapScanner heapScanner) {
            super(architecture, graph);
            this.heapScanner = heapScanner;
            this.locationIdentityCache = new ConcurrentHashMap<JavaConstant, LocationIdentity>();
        }

        protected Object readObject(GraphDecoder.MethodScope methodScope) {
            Object object = super.readObject(methodScope);
            if (object instanceof JavaConstant) {
                JavaConstant constant2 = (JavaConstant)object;
                return SubstrateGraalUtils.runtimeToHosted(constant2, this.heapScanner);
            }
            if (object instanceof ObjectLocationIdentity) {
                ObjectLocationIdentity oli = (ObjectLocationIdentity)object;
                return this.locationIdentityCache.computeIfAbsent(oli.getObject(), constant -> ObjectLocationIdentity.create((JavaConstant)SubstrateGraalUtils.runtimeToHosted(constant, this.heapScanner)));
            }
            return object;
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> RemoveUnneededDeoptSupport = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> VerifyRuntimeCompilationFrameStates = new HostedOptionKey<Boolean>(false);
    }
}

