/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.jni.headers.JNIJavaVM;
import com.oracle.svm.core.jni.headers.JNIJavaVMPointer;
import com.oracle.svm.core.memory.NativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JNIJavaVMList {
    private static final UnsignedWord INITIAL_CAPACITY = WordFactory.unsigned((int)8);
    private static final CGlobalData<Pointer> HEAD = CGlobalDataFactory.createWord((WordBase)((Pointer)WordFactory.nullPointer()));

    public static void addJavaVM(JNIJavaVM newEntry) {
        UnsignedWord wordSize = SizeOf.unsigned(WordPointer.class);
        Pointer nextPointer = HEAD.get();
        UnsignedWord capacity = (UnsignedWord)WordFactory.zero();
        while (true) {
            Pointer p;
            if ((p = (Pointer)nextPointer.readWord(0)).isNull()) {
                UnsignedWord newCapacity = capacity.notEqual(0) ? capacity.multiply(2) : INITIAL_CAPACITY;
                Pointer newArray = (Pointer)NativeMemory.calloc(newCapacity.add(2).multiply(wordSize), NmtCategory.JNI);
                newArray.writeWord(0, (WordBase)newCapacity);
                newArray.writeWord((WordBase)wordSize, (WordBase)newEntry);
                p = (Pointer)nextPointer.compareAndSwapWord(0, (WordBase)((Pointer)WordFactory.nullPointer()), (WordBase)newArray, LocationIdentity.ANY_LOCATION);
                if (p.equal((UnsignedWord)WordFactory.nullPointer())) {
                    return;
                }
                NativeMemory.free((PointerBase)newArray);
            }
            capacity = (UnsignedWord)p.readWord(0);
            p = p.add(wordSize);
            Pointer end = p.add(capacity.multiply(wordSize));
            while (p.belowThan((UnsignedWord)end)) {
                JNIJavaVM entry = (JNIJavaVM)p.readWord(0);
                if (entry.isNull() && p.logicCompareAndSwapWord(0, (WordBase)WordFactory.nullPointer(), (WordBase)newEntry, LocationIdentity.ANY_LOCATION)) {
                    return;
                }
                p = p.add(wordSize);
            }
            nextPointer = p;
        }
    }

    public static boolean removeJavaVM(JNIJavaVM javavm) {
        WordPointer p = (WordPointer)HEAD.get().readWord(0);
        while (p.isNonNull()) {
            Word capacity = (Word)p.read(0);
            Word i = (Word)WordFactory.unsigned((int)1);
            while (i.belowOrEqual(capacity)) {
                JNIJavaVM entry = (JNIJavaVM)p.read((SignedWord)i);
                if (entry.equal((ComparableWord)javavm)) {
                    p.write((SignedWord)i, (WordBase)WordFactory.nullPointer());
                    return true;
                }
                i = i.add(1);
            }
            p = (WordPointer)p.read((SignedWord)capacity.add(1));
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void gather(JNIJavaVMPointer buffer, int bufferLength, CIntPointer totalCountPointer) {
        int totalCount = 0;
        WordPointer p = (WordPointer)HEAD.get().readWord(0);
        while (p.isNonNull()) {
            Word capacity = (Word)p.read(0);
            Word i = (Word)WordFactory.unsigned((int)1);
            while (i.belowOrEqual(capacity)) {
                JNIJavaVM entry = (JNIJavaVM)p.read((SignedWord)i);
                if (entry.isNonNull()) {
                    if (totalCount < bufferLength) {
                        buffer.write(totalCount, entry);
                    }
                    ++totalCount;
                }
                i = i.add(1);
            }
            p = (WordPointer)p.read((SignedWord)capacity.add(1));
        }
        if (totalCountPointer.isNonNull()) {
            totalCountPointer.write(totalCount);
        }
    }

    private JNIJavaVMList() {
    }
}

