/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK21OrEarlier;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.internal.misc.Unsafe;

@TargetClass(className="java.util.concurrent.atomic.AtomicLongFieldUpdater$LockedUpdater", onlyWith={JDK21OrEarlier.class})
final class Target_java_util_concurrent_atomic_AtomicLongFieldUpdater_LockedUpdater {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.AtomicFieldUpdaterOffset)
    private long offset;
    @Alias
    private Class<?> cclass;
    @Alias
    private Class<?> tclass;

    @Substitute
    Target_java_util_concurrent_atomic_AtomicLongFieldUpdater_LockedUpdater(Class<?> tclass, String fieldName, Class<?> caller) {
        Field field = null;
        int modifiers = 0;
        try {
            field = tclass.getDeclaredField(fieldName);
            modifiers = field.getModifiers();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (field.getType() != Long.TYPE) {
            throw new IllegalArgumentException("Must be long type");
        }
        if (!Modifier.isVolatile(modifiers)) {
            throw new IllegalArgumentException("Must be volatile type");
        }
        this.cclass = tclass;
        this.tclass = tclass;
        this.offset = Unsafe.getUnsafe().objectFieldOffset(field);
    }
}

