/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.interpreter;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public abstract class InterpreterSupport {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private CFunctionPointer leaveStubPointer;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private int leaveStubLength;

    @Fold
    public static boolean isEnabled() {
        return ImageSingletons.contains(InterpreterSupport.class);
    }

    @Fold
    public static InterpreterSupport singleton() {
        return (InterpreterSupport)ImageSingletons.lookup(InterpreterSupport.class);
    }

    public abstract boolean isInterpreterRoot(Class<?> var1);

    public abstract FrameSourceInfo getInterpretedMethodFrameInfo(FrameInfoQueryResult var1, Pointer var2);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setLeaveStubPointer(CFunctionPointer leaveStubPointer, int length) {
        assert (InterpreterSupport.singleton().leaveStubPointer == null) : "multiple leave stub methods registered";
        InterpreterSupport.singleton().leaveStubPointer = leaveStubPointer;
        InterpreterSupport.singleton().leaveStubLength = length;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInInterpreterLeaveStub(CodePointer ip) {
        Pointer start = (Pointer)InterpreterSupport.singleton().leaveStubPointer;
        Pointer end = start.add(InterpreterSupport.singleton().leaveStubLength);
        return start.belowOrEqual((UnsignedWord)ip) && end.aboveOrEqual((UnsignedWord)ip);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called by GC walker", mayBeInlined=true)
    public static void walkInterpreterLeaveStubFrame(ObjectReferenceVisitor visitor, Pointer actualSP, Pointer sp) {
        int wordSize = FrameAccess.wordSize();
        int referenceIndex = 0;
        for (long gcReferenceMap = actualSP.readLong(2 * wordSize); gcReferenceMap != 0L; gcReferenceMap >>= 1) {
            int trail0 = Long.numberOfTrailingZeros(gcReferenceMap);
            gcReferenceMap >>= trail0;
            int baseOffset = wordSize;
            Pointer objRef = sp.add(baseOffset + wordSize * (referenceIndex += trail0));
            InterpreterSupport.callVisitor(visitor, objRef);
            ++referenceIndex;
        }
    }

    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static boolean callVisitor(ObjectReferenceVisitor visitor, Pointer address) {
        return visitor.visitObjectReference(address, false, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public abstract void buildMethodIdMapping(ResolvedJavaMethod[] var1);
}

