/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.imagelayer;

import com.oracle.svm.util.ModuleSupport;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.util.ObjectCopier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class ImageLayerBuildingSupport {
    public final boolean buildingImageLayer;
    private final boolean buildingInitialLayer;
    private final boolean buildingApplicationLayer;

    protected ImageLayerBuildingSupport(boolean buildingImageLayer, boolean buildingInitialLayer, boolean buildingApplicationLayer) {
        this.buildingImageLayer = buildingImageLayer;
        this.buildingInitialLayer = buildingInitialLayer;
        this.buildingApplicationLayer = buildingApplicationLayer;
    }

    public static void openModules() {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ObjectCopier.class, (boolean)false, (String)"java.base", (String[])new String[]{"java.lang"});
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ObjectCopier.class, (boolean)false, (String)"java.base", (String[])new String[]{"java.util"});
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ObjectCopier.class, (boolean)false, (String)"java.base", (String[])new String[]{"java.util.concurrent"});
    }

    private static ImageLayerBuildingSupport singleton() {
        return (ImageLayerBuildingSupport)ImageSingletons.lookup(ImageLayerBuildingSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean firstImageBuild() {
        return !ImageLayerBuildingSupport.buildingImageLayer() || ImageLayerBuildingSupport.buildingInitialLayer();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean lastImageBuild() {
        return !ImageLayerBuildingSupport.buildingImageLayer() || ImageLayerBuildingSupport.buildingApplicationLayer();
    }

    @Fold
    public static boolean buildingImageLayer() {
        return ImageLayerBuildingSupport.singleton().buildingImageLayer;
    }

    @Fold
    public static boolean buildingInitialLayer() {
        return ImageLayerBuildingSupport.singleton().buildingInitialLayer;
    }

    @Fold
    public static boolean buildingApplicationLayer() {
        return ImageLayerBuildingSupport.singleton().buildingApplicationLayer;
    }

    @Fold
    public static boolean buildingExtensionLayer() {
        return ImageLayerBuildingSupport.singleton().buildingImageLayer && !ImageLayerBuildingSupport.singleton().buildingInitialLayer;
    }

    @Fold
    public static boolean buildingSharedLayer() {
        return ImageLayerBuildingSupport.singleton().buildingImageLayer && !ImageLayerBuildingSupport.singleton().buildingApplicationLayer;
    }
}

