/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public class CompareAndSetVMThreadLocalNode
extends AbstractStateSplit
implements VMThreadLocalAccess,
Lowerable,
SingleMemoryKill {
    public static final NodeClass<CompareAndSetVMThreadLocalNode> TYPE = NodeClass.create(CompareAndSetVMThreadLocalNode.class);
    private final VMThreadLocalInfo threadLocalInfo;
    @Node.Input
    protected ValueNode holder;
    @Node.Input
    protected ValueNode expect;
    @Node.Input
    protected ValueNode update;

    public CompareAndSetVMThreadLocalNode(VMThreadLocalInfo threadLocalInfo, ValueNode holder, ValueNode expect, ValueNode update) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Boolean.getStackKind()));
        this.threadLocalInfo = threadLocalInfo;
        this.holder = holder;
        this.expect = expect;
        this.update = update;
    }

    public ValueNode getUpdate() {
        return this.update;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public void lower(LoweringTool tool) {
        assert (this.threadLocalInfo.offset >= 0);
        ConstantNode offset = ConstantNode.forLong((long)this.threadLocalInfo.offset, (StructuredGraph)this.holder.graph());
        UnsafeCompareAndSwapNode atomic = (UnsafeCompareAndSwapNode)this.graph().add((Node)new UnsafeCompareAndSwapNode(this.holder, (ValueNode)offset, this.expect, this.update, this.threadLocalInfo.storageKind, this.threadLocalInfo.locationIdentity, MemoryOrderMode.VOLATILE));
        atomic.setStateAfter(this.stateAfter());
        this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)atomic);
        tool.getLowerer().lower((Node)atomic, tool);
    }
}

