/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public class MethodReturnNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<MethodReturnNode> TYPE = NodeClass.create(MethodReturnNode.class);
    @Node.Input
    protected ValueNode result;

    protected MethodReturnNode(ValueNode result) {
        super(TYPE, StampFactory.object());
        this.result = result;
    }

    public void lower(LoweringTool tool) {
        FixedNode originalNext = this.next();
        this.replaceFirstSuccessor((Node)originalNext, null);
        GraphUtil.killCFG((FixedNode)originalNext);
        this.replaceAtPredecessor(this.graph().add((Node)new ReturnNode(this.result)));
        this.safeDelete();
    }

    @Node.NodeIntrinsic
    public static native RuntimeException methodReturn(Object var0);
}

