/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.amd64.AMD64CalleeSavedRegisters;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64BlockEndOp;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="FAR_RETURN")
public final class AMD64FarReturnOp
extends AMD64BlockEndOp {
    public static final LIRInstructionClass<AMD64FarReturnOp> TYPE = LIRInstructionClass.create(AMD64FarReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue sp;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue ip;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue cfiTargetRegister;
    private final boolean fromMethodWithCalleeSavedRegisters;

    public AMD64FarReturnOp(AllocatableValue result, AllocatableValue sp, AllocatableValue ip, boolean fromMethodWithCalleeSavedRegisters) {
        super(TYPE);
        this.result = result;
        this.sp = sp;
        this.ip = ip;
        this.fromMethodWithCalleeSavedRegisters = fromMethodWithCalleeSavedRegisters;
        this.cfiTargetRegister = (SubstrateOptions.PreserveFramePointer.getValue() != false || fromMethodWithCalleeSavedRegisters) && SubstrateControlFlowIntegrity.useSoftwareCFI() ? SubstrateControlFlowIntegrity.singleton().getCFITargetRegister().asValue() : Value.ILLEGAL;
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (!SubstrateOptions.PreserveFramePointer.getValue().booleanValue() && !this.fromMethodWithCalleeSavedRegisters) {
            masm.movq(AMD64.rsp, ValueUtil.asRegister((Value)this.sp));
            masm.jmp(ValueUtil.asRegister((Value)this.ip));
            return;
        }
        Label notSameFrame = new Label();
        masm.cmpqAndJcc(AMD64.rsp, ValueUtil.asRegister((Value)this.sp), AMD64Assembler.ConditionFlag.NotEqual, notSameFrame, true);
        masm.jmp(ValueUtil.asRegister((Value)this.ip));
        masm.bind(notSameFrame);
        int calleeFrameSize = FrameAccess.returnAddressSize();
        if (this.fromMethodWithCalleeSavedRegisters || SubstrateOptions.PreserveFramePointer.getValue().booleanValue()) {
            calleeFrameSize += FrameAccess.wordSize();
        }
        if (this.fromMethodWithCalleeSavedRegisters) {
            calleeFrameSize += CalleeSavedRegisters.singleton().getSaveAreaSize();
        }
        masm.leaq(AMD64.rsp, masm.makeAddress(ValueUtil.asRegister((Value)this.sp), -calleeFrameSize));
        masm.movq(masm.makeAddress(AMD64.rsp, calleeFrameSize - FrameAccess.returnAddressSize()), ValueUtil.asRegister((Value)this.ip));
        if (this.fromMethodWithCalleeSavedRegisters) {
            AMD64CalleeSavedRegisters.singleton().emitRestore(masm, calleeFrameSize, ValueUtil.asRegister((Value)this.result), crb);
            masm.incrementq(AMD64.rsp, CalleeSavedRegisters.singleton().getSaveAreaSize());
        }
        if (this.fromMethodWithCalleeSavedRegisters || SubstrateOptions.PreserveFramePointer.getValue().booleanValue()) {
            masm.pop(AMD64.rbp);
        }
        if (SubstrateControlFlowIntegrity.useSoftwareCFI()) {
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{this.result, this.cfiTargetRegister})) : Assertions.errorMessage((Object[])new Object[]{this.result, this.cfiTargetRegister});
            Register targetRegister = ValueUtil.asRegister((Value)this.cfiTargetRegister);
            masm.pop(targetRegister);
            masm.jmp(targetRegister);
        } else {
            masm.ret(0);
        }
    }

    public boolean modifiesStackPointer() {
        return true;
    }
}

