/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.log.Log;

final class Timers {
    final Timer blackenImageHeapRoots = new Timer("blackenImageHeapRoots");
    final Timer blackenDirtyCardRoots = new Timer("blackenDirtyCardRoots");
    final Timer blackenStackRoots = new Timer("blackenStackRoots");
    final Timer scanFromRoots = new Timer("scanFromRoots");
    final Timer scanFromDirtyRoots = new Timer("scanFromDirtyRoots");
    final Timer collection = new Timer("collection");
    final Timer cleanCodeCache = new Timer("cleanCodeCache");
    final Timer referenceObjects = new Timer("referenceObjects");
    final Timer promotePinnedObjects = new Timer("promotePinnedObjects");
    final Timer rootScan = new Timer("rootScan");
    final Timer scanGreyObjects = new Timer("scanGreyObjects");
    final Timer oldPlanning = new Timer("oldPlanning");
    final Timer oldFixup = new Timer("oldFixup");
    final Timer oldFixupAlignedChunks = new Timer("oldFixupAlignedChunks");
    final Timer oldFixupImageHeap = new Timer("oldFixupImageHeap");
    final Timer oldFixupThreadLocals = new Timer("oldFixupThreadLocals");
    final Timer oldFixupRuntimeCodeCache = new Timer("oldFixupRuntimeCodeCache");
    final Timer oldFixupStack = new Timer("oldFixupStack");
    final Timer oldFixupUnalignedChunks = new Timer("oldFixupUnalignedChunks");
    final Timer oldCompaction = new Timer("oldCompaction");
    final Timer oldCompactionRememberedSets = new Timer("oldCompactionRememberedSets");
    final Timer releaseSpaces = new Timer("releaseSpaces");
    final Timer walkThreadLocals = new Timer("walkThreadLocals");
    final Timer walkRuntimeCodeCache = new Timer("walkRuntimeCodeCache");
    final Timer cleanRuntimeCodeCache = new Timer("cleanRuntimeCodeCache");
    final Timer mutator = new Timer("mutator");

    Timers() {
    }

    void resetAllExceptMutator() {
        this.collection.reset();
        this.rootScan.reset();
        this.scanFromRoots.reset();
        this.scanFromDirtyRoots.reset();
        this.promotePinnedObjects.reset();
        this.blackenStackRoots.reset();
        this.walkThreadLocals.reset();
        this.walkRuntimeCodeCache.reset();
        this.cleanRuntimeCodeCache.reset();
        this.blackenImageHeapRoots.reset();
        this.blackenDirtyCardRoots.reset();
        this.scanGreyObjects.reset();
        if (SerialGCOptions.useCompactingOldGen()) {
            this.oldPlanning.reset();
            this.oldFixup.reset();
            this.oldFixupAlignedChunks.reset();
            this.oldFixupImageHeap.reset();
            this.oldFixupThreadLocals.reset();
            this.oldFixupRuntimeCodeCache.reset();
            this.oldFixupStack.reset();
            this.oldFixupUnalignedChunks.reset();
            this.oldCompaction.reset();
            this.oldCompactionRememberedSets.reset();
        }
        this.cleanCodeCache.reset();
        this.referenceObjects.reset();
        this.releaseSpaces.reset();
    }

    void logAfterCollection(Log log) {
        if (log.isEnabled()) {
            log.newline();
            log.string("  [GC nanoseconds:");
            Timers.logOneTimer(log, "    ", this.collection);
            Timers.logOneTimer(log, "      ", this.rootScan);
            Timers.logOneTimer(log, "        ", this.scanFromRoots);
            Timers.logOneTimer(log, "        ", this.scanFromDirtyRoots);
            Timers.logOneTimer(log, "          ", this.promotePinnedObjects);
            Timers.logOneTimer(log, "          ", this.blackenStackRoots);
            Timers.logOneTimer(log, "          ", this.walkThreadLocals);
            Timers.logOneTimer(log, "          ", this.walkRuntimeCodeCache);
            Timers.logOneTimer(log, "          ", this.cleanRuntimeCodeCache);
            Timers.logOneTimer(log, "          ", this.blackenImageHeapRoots);
            Timers.logOneTimer(log, "          ", this.blackenDirtyCardRoots);
            Timers.logOneTimer(log, "          ", this.scanGreyObjects);
            if (SerialGCOptions.useCompactingOldGen()) {
                Timers.logOneTimer(log, "      ", this.oldPlanning);
                Timers.logOneTimer(log, "      ", this.oldFixup);
                Timers.logOneTimer(log, "          ", this.oldFixupAlignedChunks);
                Timers.logOneTimer(log, "          ", this.oldFixupImageHeap);
                Timers.logOneTimer(log, "          ", this.oldFixupThreadLocals);
                Timers.logOneTimer(log, "          ", this.oldFixupRuntimeCodeCache);
                Timers.logOneTimer(log, "          ", this.oldFixupStack);
                Timers.logOneTimer(log, "          ", this.oldFixupUnalignedChunks);
                Timers.logOneTimer(log, "      ", this.oldCompaction);
                Timers.logOneTimer(log, "          ", this.oldCompactionRememberedSets);
            }
            Timers.logOneTimer(log, "      ", this.cleanCodeCache);
            Timers.logOneTimer(log, "      ", this.referenceObjects);
            Timers.logOneTimer(log, "      ", this.releaseSpaces);
            Timers.logGCLoad(log, "    ", "GCLoad", this.collection, this.mutator);
            log.string("]");
        }
    }

    static void logOneTimer(Log log, String prefix, Timer timer) {
        if (timer.getMeasuredNanos() > 0L) {
            log.newline().string(prefix).string(timer.getName()).string(": ").signed(timer.getMeasuredNanos());
        }
    }

    private static void logGCLoad(Log log, String prefix, String label, Timer cTimer, Timer mTimer) {
        long collectionNanos = cTimer.getLastIntervalNanos();
        long mutatorNanos = mTimer.getLastIntervalNanos();
        long intervalNanos = mutatorNanos + collectionNanos;
        long intervalGCPercent = (100L * collectionNanos + intervalNanos / 2L) / intervalNanos;
        log.newline().string(prefix).string(label).string(": ").signed(intervalGCPercent).string("%");
    }
}

