/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.ImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.image.ImageHeapObject;
import java.nio.ByteBuffer;
import java.util.List;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import sun.nio.ch.DirectBuffer;

public class RuntimeImageHeapChunkWriter
implements ImageHeapChunkWriter {
    private final Pointer heapBegin;
    private final Word layoutToBufferOffsetAddend;

    RuntimeImageHeapChunkWriter(ByteBuffer buffer, long layoutToBufferOffsetAddend) {
        DirectBuffer direct = (DirectBuffer)((Object)buffer);
        this.heapBegin = (Pointer)WordFactory.pointer((long)direct.address());
        this.layoutToBufferOffsetAddend = (Word)WordFactory.signed((long)layoutToBufferOffsetAddend);
    }

    private Pointer getChunkPointerInBuffer(int chunkPosition) {
        return this.heapBegin.add(chunkPosition).add((UnsignedWord)this.layoutToBufferOffsetAddend);
    }

    @Override
    public void initializeAlignedChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        AlignedHeapChunk.AlignedHeader header = (AlignedHeapChunk.AlignedHeader)this.getChunkPointerInBuffer(chunkPosition);
        header.setTopOffset(WordFactory.unsigned((long)topOffset));
        header.setEndOffset(WordFactory.unsigned((long)endOffset));
        header.setSpace(null);
        header.setOffsetToPreviousChunk((SignedWord)WordFactory.unsigned((long)offsetToPreviousChunk));
        header.setOffsetToNextChunk((SignedWord)WordFactory.unsigned((long)offsetToNextChunk));
        header.setIdentityHashSalt((UnsignedWord)WordFactory.zero(), IdentityHashCodeSupport.IDENTITY_HASHCODE_SALT_LOCATION);
    }

    @Override
    public void initializeUnalignedChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        UnalignedHeapChunk.UnalignedHeader header = (UnalignedHeapChunk.UnalignedHeader)this.getChunkPointerInBuffer(chunkPosition);
        header.setTopOffset(WordFactory.unsigned((long)topOffset));
        header.setEndOffset(WordFactory.unsigned((long)endOffset));
        header.setSpace(null);
        header.setOffsetToPreviousChunk((SignedWord)WordFactory.unsigned((long)offsetToPreviousChunk));
        header.setOffsetToNextChunk((SignedWord)WordFactory.unsigned((long)offsetToNextChunk));
        header.setIdentityHashSalt((UnsignedWord)WordFactory.zero(), IdentityHashCodeSupport.IDENTITY_HASHCODE_SALT_LOCATION);
    }

    @Override
    public void enableRememberedSetForAlignedChunk(int chunkPosition, List<ImageHeapObject> objects) {
        AlignedHeapChunk.AlignedHeader header = (AlignedHeapChunk.AlignedHeader)this.getChunkPointerInBuffer(chunkPosition);
        RememberedSet.get().enableRememberedSetForChunk(header);
    }

    @Override
    public void enableRememberedSetForUnalignedChunk(int chunkPosition) {
        UnalignedHeapChunk.UnalignedHeader header = (UnalignedHeapChunk.UnalignedHeader)this.getChunkPointerInBuffer(chunkPosition);
        RememberedSet.get().enableRememberedSetForChunk(header);
    }
}

