/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

final class SerializationMetadataParser<C>
extends SerializationConfigurationParser<C> {
    SerializationMetadataParser(ConfigurationConditionResolver<C> conditionResolver, RuntimeSerializationSupport<C> serializationSupport, boolean strictConfiguration) {
        super(conditionResolver, serializationSupport, strictConfiguration);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        Object serializationJson = this.getFromGlobalFile(json, "serialization");
        if (serializationJson != null) {
            this.parseSerializationTypes(SerializationMetadataParser.asList(serializationJson, "The serialization property must be an array of serialization descriptor object"), false);
        }
    }

    @Override
    protected void parseSerializationDescriptorObject(EconomicMap<String, Object> data, boolean lambdaCapturingType) {
        this.checkAttributes(data, "serialization descriptor object", List.of("type"), List.of("condition", "customTargetConstructorClass"));
        Optional<ConfigurationTypeDescriptor> targetSerializationClass = SerializationMetadataParser.parseTypeContents(data.get((Object)"type"));
        if (targetSerializationClass.isEmpty()) {
            return;
        }
        UnresolvedConfigurationCondition unresolvedCondition = this.parseCondition(data, true);
        TypeResult condition = this.conditionResolver.resolveCondition(unresolvedCondition);
        if (!condition.isPresent()) {
            return;
        }
        Object optionalCustomCtorValue = data.get((Object)"customTargetConstructorClass");
        this.registerType(targetSerializationClass.get(), condition.get(), optionalCustomCtorValue);
    }
}

