/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.util.AbstractTypeReader;

public class ReusableTypeReader
extends AbstractTypeReader {
    private NonmovableArray<Byte> data;
    private long byteIndex = -1L;

    public ReusableTypeReader() {
    }

    public ReusableTypeReader(NonmovableArray<Byte> data, long byteIndex) {
        this.data = data;
        this.byteIndex = byteIndex;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ReusableTypeReader reset() {
        this.data = NonmovableArrays.nullArray();
        this.byteIndex = -1L;
        return this;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isValid() {
        return this.data != null && this.byteIndex >= 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getByteIndex() {
        return this.byteIndex;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setByteIndex(long byteIndex) {
        this.byteIndex = byteIndex;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public NonmovableArray<Byte> getData() {
        return this.data;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setData(NonmovableArray<Byte> data) {
        this.data = data;
    }

    public int getS1() {
        throw VMError.intentionallyUnimplemented();
    }

    public int getS2() {
        throw VMError.intentionallyUnimplemented();
    }

    public int getU2() {
        throw VMError.intentionallyUnimplemented();
    }

    public int getS4() {
        throw VMError.intentionallyUnimplemented();
    }

    public long getU4() {
        throw VMError.intentionallyUnimplemented();
    }

    public long getS8() {
        throw VMError.intentionallyUnimplemented();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getU1() {
        int result = NonmovableByteArrayReader.getU1(this.data, this.byteIndex);
        ++this.byteIndex;
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getUVInt() {
        return ReusableTypeReader.asS4(this.getUV());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSVInt() {
        return ReusableTypeReader.asS4(this.getSV());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getSV() {
        return ReusableTypeReader.decodeSign(this.read());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getUV() {
        return this.read();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long decodeSign(long value) {
        return value >>> 1 ^ -(value & 1L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long read() {
        int b0 = this.getU1();
        if ((long)b0 < 192L) {
            return b0;
        }
        return this.readPacked(b0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long readPacked(int b0) {
        assert ((long)b0 >= 192L);
        long sum = b0;
        long shift = 6L;
        int i = 2;
        while (true) {
            long b = this.getU1();
            sum += b << (int)shift;
            if (b < 192L || (long)i == 11L) {
                return sum;
            }
            shift += 6L;
            ++i;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isS4(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int asS4(long value) {
        assert (ReusableTypeReader.isS4(value));
        return (int)value;
    }
}

