/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.nmt.NmtCategory;
import java.nio.ByteOrder;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public interface ReferenceAdjuster {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> void setConstantTargetInArray(NonmovableObjectArray<T> var1, int var2, JavaConstant var3);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> void setObjectInArray(NonmovableObjectArray<T> var1, int var2, T var3);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setConstantTargetAt(PointerBase var1, int var2, JavaConstant var3);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    default public <T extends Constant> NonmovableObjectArray<Object> copyOfObjectConstantArray(T[] constants, NmtCategory nmtCategory) {
        NonmovableObjectArray<Object> objects = NonmovableArrays.createObjectArray(Object[].class, constants.length, nmtCategory);
        for (int i = 0; i < constants.length; ++i) {
            this.setConstantTargetInArray(objects, i, (JavaConstant)constants[i]);
        }
        return objects;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> NonmovableObjectArray<T> copyOfObjectArray(T[] var1, NmtCategory var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isFinished();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void writeReference(Pointer address, int length, Object obj) {
        if (length == 8 && length > ConfigurationValues.getObjectLayout().getReferenceSize()) {
            if (!1.$assertionsDisabled && ReferenceAdjuster.nativeByteOrder() != ByteOrder.LITTLE_ENDIAN) {
                throw new AssertionError();
            }
            address.writeLong(0, 0L);
        } else if (!1.$assertionsDisabled && length != ConfigurationValues.getObjectLayout().getReferenceSize()) {
            throw new AssertionError((Object)"Unsupported reference constant size");
        }
        boolean compressed = ReferenceAccess.singleton().haveCompressedReferences();
        ReferenceAccess.singleton().writeObjectAt(address, obj, compressed);
    }

    @Fold
    public static ByteOrder nativeByteOrder() {
        return ConfigurationValues.getTarget().arch.getByteOrder();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

