/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.nmt.NmtCategory;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.DebugContext;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton
public final class InstalledCodeObserverSupport {
    private static final InstalledCodeObserverHandleAction ACTION_ATTACH = h -> InstalledCodeObserverSupport.getAccessor(h).attachToCurrentIsolate(h);
    private static final InstalledCodeObserverHandleAction ACTION_DETACH = h -> InstalledCodeObserverSupport.getAccessor(h).detachFromCurrentIsolate(h);
    private static final InstalledCodeObserverHandleAction ACTION_RELEASE = h -> InstalledCodeObserverSupport.getAccessor(h).release(h);
    private static final InstalledCodeObserverHandleAction ACTION_ACTIVATE = h -> InstalledCodeObserverSupport.getAccessor(h).activate(h);
    private final List<InstalledCodeObserver.Factory> observerFactories = new ArrayList<InstalledCodeObserver.Factory>();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    InstalledCodeObserverSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addObserverFactory(InstalledCodeObserver.Factory observerFactory) {
        this.observerFactories.add(observerFactory);
    }

    public InstalledCodeObserver[] createObservers(DebugContext debug, SharedMethod method, CompilationResult compilation, Pointer code, int codeSize) {
        ArrayList<InstalledCodeObserver> observers = new ArrayList<InstalledCodeObserver>();
        for (InstalledCodeObserver.Factory factory : this.observerFactories) {
            InstalledCodeObserver observer = factory.create(debug, method, compilation, code, codeSize);
            if (observer == null) continue;
            observers.add(observer);
        }
        return observers.toArray(new InstalledCodeObserver[0]);
    }

    public static NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> installObservers(InstalledCodeObserver[] observers) {
        if (observers.length == 0) {
            return NonmovableArrays.nullArray();
        }
        NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles = NonmovableArrays.createWordArray(observers.length, NmtCategory.Code);
        for (int i = 0; i < observers.length; ++i) {
            InstalledCodeObserver.InstalledCodeObserverHandle handle = observers[i].install();
            NonmovableArrays.setWord(observerHandles, i, handle);
        }
        return observerHandles;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static InstalledCodeObserver.InstalledCodeObserverHandleAccessor getAccessor(InstalledCodeObserver.InstalledCodeObserverHandle handle) {
        return handle.getAccessor();
    }

    public static void activateObservers(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles) {
        InstalledCodeObserverSupport.forEach(observerHandles, ACTION_ACTIVATE);
    }

    public static void detachFromCurrentIsolate(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles) {
        InstalledCodeObserverSupport.forEach(observerHandles, ACTION_DETACH);
    }

    public static void attachToCurrentIsolate(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles) {
        InstalledCodeObserverSupport.forEach(observerHandles, ACTION_ATTACH);
    }

    public static void removeObservers(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles) {
        InstalledCodeObserverSupport.forEach(observerHandles, ACTION_RELEASE);
    }

    private static void forEach(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> array, InstalledCodeObserverHandleAction action) {
        if (array.isNonNull()) {
            int length = NonmovableArrays.lengthOf(array);
            for (int i = 0; i < length; ++i) {
                InstalledCodeObserver.InstalledCodeObserverHandle handle = NonmovableArrays.getWord(array, i);
                if (!handle.isNonNull()) continue;
                action.invoke(handle);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void removeObserversOnTearDown(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles) {
        if (observerHandles.isNonNull()) {
            int length = NonmovableArrays.lengthOf(observerHandles);
            for (int i = 0; i < length; ++i) {
                InstalledCodeObserver.InstalledCodeObserverHandle handle = NonmovableArrays.getWord(observerHandles, i);
                if (!handle.isNonNull()) continue;
                InstalledCodeObserverSupport.getAccessor(handle).releaseOnTearDown(handle);
                NonmovableArrays.setWord(observerHandles, i, (InstalledCodeObserver.InstalledCodeObserverHandle)WordFactory.nullPointer());
            }
        }
    }

    private static interface InstalledCodeObserverHandleAction {
        public void invoke(InstalledCodeObserver.InstalledCodeObserverHandle var1);
    }
}

