/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.SubstrateCompilationResult;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.truffle.SubstrateTruffleCompilationIdentifier;
import com.oracle.svm.truffle.TruffleSupport;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstratePostPartialEvaluationSuite;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import java.io.PrintStream;
import java.util.Map;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PostPartialEvaluationSuite;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.TruffleTierConfiguration;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentationSuite;
import org.graalvm.compiler.truffle.compiler.phases.TruffleTier;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateTruffleCompilerImpl
extends TruffleCompilerImpl
implements SubstrateTruffleCompiler {
    private final String compilerConfigurationName = GraalConfiguration.runtimeInstance().getCompilerConfigurationName();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompilerImpl(TruffleCompilerConfiguration config) {
        super(config);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PartialEvaluator createPartialEvaluator(TruffleCompilerConfiguration configuration) {
        return TruffleSupport.singleton().createPartialEvaluator(configuration, this.builderConfig);
    }

    public void initialize(Map<String, Object> optionsMap, CompilableTruffleAST compilable, boolean firstInitialization) {
        super.initialize(optionsMap, compilable, firstInitialization);
        for (Backend backend : this.getConfig().backends()) {
            SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures(backend);
        }
    }

    protected TruffleTier newTruffleTier(org.graalvm.options.OptionValues options) {
        return new TruffleTier(options, this.partialEvaluator, new InstrumentationSuite(this.partialEvaluator.instrumentationCfg, this.config.snippetReflection(), this.partialEvaluator.getInstrumentation()), (PostPartialEvaluationSuite)new SubstratePostPartialEvaluationSuite((Boolean)options.get(PolyglotCompilerOptions.IterativePartialEscape)));
    }

    public PhaseSuite<HighTierContext> createGraphBuilderSuite(TruffleTierConfiguration tier) {
        return null;
    }

    public String getCompilerConfigurationName() {
        return this.compilerConfigurationName;
    }

    @Override
    public void teardown() {
    }

    protected CompilationResult createCompilationResult(String name, CompilationIdentifier compilationIdentifier, CompilableTruffleAST compilable) {
        return new SubstrateCompilationResult(compilationIdentifier, name);
    }

    public TruffleCompilationIdentifier createCompilationIdentifier(CompilableTruffleAST optimizedCallTarget) {
        return new SubstrateTruffleCompilationIdentifier((OptimizedCallTarget)optimizedCallTarget);
    }

    public DebugContext createDebugContext(OptionValues options, CompilationIdentifier compilationId, CompilableTruffleAST callTarget, PrintStream logStream) {
        return GraalSupport.get().openDebugContext(options, compilationId, callTarget, logStream);
    }

    protected DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return GraalSupport.get().getDebugOutputDirectory();
    }

    protected Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return GraalSupport.get().getCompilationProblemsPerAction();
    }

    protected InstalledCode createInstalledCode(CompilableTruffleAST compilable) {
        return ((SubstrateCompilableTruffleAST)compilable).createPreliminaryInstalledCode();
    }
}

