/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.truffle.api.SubstrateThreadLocalHandshake;
import java.util.Arrays;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleSafepointNode;
import org.graalvm.word.LocationIdentity;

public final class SubstrateThreadLocalHandshakeSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    private static void pollSnippet(Object node) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (SubstrateThreadLocalHandshake.PENDING.get() != 0 ? 1 : 0) != 0)) {
            SubstrateThreadLocalHandshakeSnippets.foreignPoll(SubstrateThreadLocalHandshake.FOREIGN_POLL, node);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void foreignPoll(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    public SubstrateThreadLocalHandshakeSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        lowerings.put(TruffleSafepointNode.class, new SafepointLowering());
    }

    private static LocationIdentity[] getPollKilledLocations() {
        int newLength = SubstrateAllocationSnippets.TLAB_LOCATIONS.length + 1;
        LocationIdentity[] locations = Arrays.copyOf(SubstrateAllocationSnippets.TLAB_LOCATIONS, newLength);
        locations[newLength - 1] = SubstrateThreadLocalHandshake.PENDING.getLocationIdentity();
        return locations;
    }

    class SafepointLowering
    implements NodeLoweringProvider<TruffleSafepointNode> {
        private final SnippetTemplate.SnippetInfo pollSnippet;

        SafepointLowering() {
            this.pollSnippet = SubstrateThreadLocalHandshakeSnippets.this.snippet(SubstrateThreadLocalHandshakeSnippets.class, "pollSnippet", SubstrateThreadLocalHandshakeSnippets.getPollKilledLocations());
        }

        @Override
        public void lower(TruffleSafepointNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
                StructuredGraph graph = node.graph();
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.pollSnippet, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("node", (Object)node.location());
                SnippetTemplate template = SubstrateThreadLocalHandshakeSnippets.this.template((ValueNode)node, args);
                template.instantiate(SubstrateThreadLocalHandshakeSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

