/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.snippets.IntrinsificationPluginRegistry;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.DeletedElementException;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

public final class ReflectionPlugins {
    private static final Object NULL_MARKER = new Object();
    private final ImageClassLoader imageClassLoader;
    private final SnippetReflectionProvider snippetReflection;
    private final AnnotationSubstitutionProcessor annotationSubstitutions;
    private final ClassInitializationPlugin classInitializationPlugin;
    private final AnalysisUniverse aUniverse;
    private final ParsingReason reason;
    private static final Set<Class<?>> ALLOWED_CONSTANT_CLASSES = new HashSet<Class>(Arrays.asList(Class.class, String.class, ClassLoader.class, Method.class, Constructor.class, Field.class, MethodHandle.class, MethodHandles.Lookup.class, MethodType.class, VarHandle.class, ByteOrder.class));
    private static final Constructor<MethodHandles.Lookup> LOOKUP_CONSTRUCTOR = ReflectionUtil.lookupConstructor(MethodHandles.Lookup.class, (Class[])new Class[]{Class.class});
    private static final Predicate<Object[]> alwaysAllowConstantFolding = args -> true;
    private final boolean parseOnce = SubstrateOptions.parseOnce();

    private ReflectionPlugins(ImageClassLoader imageClassLoader, SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, ClassInitializationPlugin classInitializationPlugin, AnalysisUniverse aUniverse, ParsingReason reason) {
        this.imageClassLoader = imageClassLoader;
        this.snippetReflection = snippetReflection;
        this.annotationSubstitutions = annotationSubstitutions;
        this.classInitializationPlugin = classInitializationPlugin;
        this.aUniverse = aUniverse;
        this.reason = reason;
    }

    public static void registerInvocationPlugins(ImageClassLoader imageClassLoader, SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, ClassInitializationPlugin classInitializationPlugin, InvocationPlugins plugins, AnalysisUniverse aUniverse, ParsingReason reason) {
        if (reason == ParsingReason.PointsToAnalysis && !ImageSingletons.contains(ReflectionPluginRegistry.class)) {
            ImageSingletons.add(ReflectionPluginRegistry.class, (Object)new ReflectionPluginRegistry());
        }
        ReflectionPlugins rp = new ReflectionPlugins(imageClassLoader, snippetReflection, annotationSubstitutions, classInitializationPlugin, aUniverse, reason);
        rp.registerMethodHandlesPlugins(plugins);
        rp.registerClassPlugins(plugins);
    }

    private void registerMethodHandlesPlugins(InvocationPlugins plugins) {
        this.registerFoldInvocationPlugins(plugins, MethodHandles.class, "publicLookup", "privateLookupIn", "arrayConstructor", "arrayLength", "arrayElementGetter", "arrayElementSetter", "arrayElementVarHandle", "byteArrayViewVarHandle", "byteBufferViewVarHandle");
        this.registerFoldInvocationPlugins(plugins, MethodHandles.Lookup.class, "in", "findStatic", "findVirtual", "findConstructor", "findClass", "accessClass", "findSpecial", "findGetter", "findSetter", "findVarHandle", "findStaticGetter", "findStaticSetter", "unreflect", "unreflectSpecial", "unreflectConstructor", "unreflectGetter", "unreflectSetter");
        this.registerFoldInvocationPlugins(plugins, MethodType.class, "methodType", "genericMethodType", "changeParameterType", "insertParameterTypes", "appendParameterTypes", "replaceParameterTypes", "dropParameterTypes", "changeReturnType", "erase", "generic", "wrap", "unwrap", "parameterType", "parameterCount", "returnType", "lastParameterType");
        this.registerConditionalFoldInvocationPlugins(plugins);
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, MethodHandles.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("lookup", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return ReflectionPlugins.this.processMethodHandlesLookup(b, targetMethod);
            }
        });
    }

    private void registerConditionalFoldInvocationPlugins(InvocationPlugins plugins) {
        Method methodHandlesLookupFindStaticVarHandle = ReflectionUtil.lookupMethod(MethodHandles.Lookup.class, (String)"findStaticVarHandle", (Class[])new Class[]{Class.class, String.class, Class.class});
        this.registerFoldInvocationPlugin(plugins, methodHandlesLookupFindStaticVarHandle, args -> {
            Object classArg = args[0];
            if (classArg instanceof Class && ReflectionPlugins.shouldInitializeAtRuntime((Class)classArg)) {
                Field field;
                if (this.reason == ParsingReason.PointsToAnalysis && (field = ReflectionUtil.lookupField((boolean)true, (Class)((Class)args[0]), (String)((String)args[1]))) != null) {
                    RuntimeReflection.register((Field[])new Field[]{field});
                }
                return false;
            }
            return true;
        });
        Method methodHandlesLookupUnreflectVarHandle = ReflectionUtil.lookupMethod(MethodHandles.Lookup.class, (String)"unreflectVarHandle", (Class[])new Class[]{Field.class});
        this.registerFoldInvocationPlugin(plugins, methodHandlesLookupUnreflectVarHandle, args -> {
            Field field;
            Object fieldArg = args[0];
            if (fieldArg instanceof Field && ReflectionPlugins.isStatic(field = (Field)fieldArg) && ReflectionPlugins.shouldInitializeAtRuntime(field.getDeclaringClass())) {
                if (this.reason == ParsingReason.PointsToAnalysis) {
                    RuntimeReflection.register((Field[])new Field[]{field});
                }
                return false;
            }
            return true;
        });
    }

    private void registerClassPlugins(InvocationPlugins plugins) {
        this.registerFoldInvocationPlugins(plugins, Class.class, "getField", "getMethod", "getConstructor", "getDeclaredField", "getDeclaredMethod", "getDeclaredConstructor");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("forName", new Type[]{String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode nameNode) {
                return ReflectionPlugins.this.processClassForName(b, targetMethod, nameNode, (ValueNode)ConstantNode.forBoolean((boolean)true));
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("forName", new Type[]{String.class, Boolean.TYPE, ClassLoader.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode nameNode, ValueNode initializeNode, ValueNode classLoaderNode) {
                return ReflectionPlugins.this.processClassForName(b, targetMethod, nameNode, initializeNode);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getClassLoader", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return ReflectionPlugins.this.processClassGetClassLoader(b, targetMethod, receiver);
            }
        });
    }

    private boolean processMethodHandlesLookup(GraphBuilderContext b, ResolvedJavaMethod targetMethod) {
        MethodHandles.Lookup lookup;
        Supplier<String> targetParameters = () -> "";
        if (StackTraceUtils.ignoredBySecurityStackWalk(b.getMetaAccess(), b.getMethod())) {
            return false;
        }
        Class callerClass = OriginalClassProvider.getJavaClass((SnippetReflectionProvider)this.snippetReflection, (ResolvedJavaType)b.getMethod().getDeclaringClass());
        try {
            lookup = LOOKUP_CONSTRUCTOR.newInstance(callerClass);
        }
        catch (Throwable ex) {
            return this.throwException(b, targetMethod, targetParameters, ex.getClass(), ex.getMessage());
        }
        return this.pushConstant(b, targetMethod, targetParameters, JavaKind.Object, lookup, false) != null;
    }

    private boolean processClassForName(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode nameNode, ValueNode initializeNode) {
        Object classNameValue = this.unbox(b, nameNode, JavaKind.Object);
        Object initializeValue = this.unbox(b, initializeNode, JavaKind.Boolean);
        if (!(classNameValue instanceof String) || !(initializeValue instanceof Boolean)) {
            return false;
        }
        String className = (String)classNameValue;
        boolean initialize = (Boolean)initializeValue;
        Supplier<String> targetParameters = () -> className + ", " + initialize;
        TypeResult<Class<?>> typeResult = this.imageClassLoader.findClass(className);
        if (!typeResult.isPresent()) {
            Throwable e = typeResult.getException();
            return this.throwException(b, targetMethod, targetParameters, e.getClass(), e.getMessage());
        }
        Class<?> clazz = typeResult.get();
        if (PredefinedClassesSupport.isPredefined(clazz)) {
            return false;
        }
        JavaConstant classConstant = this.pushConstant(b, targetMethod, targetParameters, JavaKind.Object, clazz, false);
        if (classConstant == null) {
            return false;
        }
        if (initialize) {
            this.classInitializationPlugin.apply(b, b.getMetaAccess().lookupJavaType(clazz), () -> null, null);
        }
        return true;
    }

    private boolean processClassGetClassLoader(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
        Object classValue = this.unbox(b, receiver.get(false), JavaKind.Object);
        if (!(classValue instanceof Class)) {
            return false;
        }
        Class clazz = (Class)classValue;
        if (PredefinedClassesSupport.isPredefined(clazz)) {
            return false;
        }
        return this.pushConstant(b, targetMethod, () -> clazz.getName(), JavaKind.Object, clazz.getClassLoader(), true) != null;
    }

    private void registerFoldInvocationPlugins(InvocationPlugins plugins, Class<?> declaringClass, String ... methodNames) {
        HashSet<String> methodNamesSet = new HashSet<String>(Arrays.asList(methodNames));
        ModuleSupport.accessModuleByClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ReflectionPlugins.class, declaringClass);
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!methodNamesSet.contains(method.getName()) || method.isSynthetic()) continue;
            this.registerFoldInvocationPlugin(plugins, method);
        }
    }

    private void registerFoldInvocationPlugin(InvocationPlugins plugins, Method reflectionMethod) {
        this.registerFoldInvocationPlugin(plugins, reflectionMethod, alwaysAllowConstantFolding);
    }

    private void registerFoldInvocationPlugin(InvocationPlugins plugins, final Method reflectionMethod, final Predicate<Object[]> allowConstantFolding) {
        if (!ALLOWED_CONSTANT_CLASSES.contains(reflectionMethod.getReturnType()) && !reflectionMethod.getReturnType().isPrimitive()) {
            throw VMError.shouldNotReachHere("Return type of method " + reflectionMethod + " is not on the allow-list for types that are immutable");
        }
        reflectionMethod.setAccessible(true);
        ArrayList parameterTypes = new ArrayList();
        if (!Modifier.isStatic(reflectionMethod.getModifiers())) {
            parameterTypes.add(InvocationPlugin.Receiver.class);
        }
        parameterTypes.addAll(Arrays.asList(reflectionMethod.getParameterTypes()));
        plugins.register(reflectionMethod.getDeclaringClass(), (InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(reflectionMethod.getName(), parameterTypes.toArray(new Class[0])){

            public boolean defaultHandler(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode ... args) {
                return ReflectionPlugins.this.foldInvocationUsingReflection(b, targetMethod, reflectionMethod, receiver, args, allowConstantFolding);
            }
        });
    }

    private boolean foldInvocationUsingReflection(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Method reflectionMethod, InvocationPlugin.Receiver receiver, ValueNode[] args, Predicate<Object[]> allowConstantFolding) {
        Object returnValue;
        Object receiverValue;
        assert (b.getMetaAccess().lookupJavaMethod((Executable)reflectionMethod).equals(targetMethod)) : "Fold method mismatch: " + reflectionMethod + " != " + targetMethod;
        if (targetMethod.isStatic()) {
            receiverValue = null;
        } else {
            receiverValue = this.unbox(b, receiver.get(false), JavaKind.Object);
            if (receiverValue == null || receiverValue == NULL_MARKER) {
                return false;
            }
        }
        Object[] argValues = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object argValue = this.unbox(b, args[i], targetMethod.getSignature().getParameterKind(i));
            if (argValue == null) {
                return false;
            }
            argValues[i] = argValue == NULL_MARKER ? null : argValue;
        }
        if (!allowConstantFolding.test(argValues)) {
            return false;
        }
        Supplier<String> targetParameters = () -> (String)(receiverValue == null ? "" : receiverValue.toString() + "; ") + Stream.of(argValues).map(arg -> arg instanceof Object[] ? Arrays.toString((Object[])arg) : Objects.toString(arg)).collect(Collectors.joining(", "));
        try {
            returnValue = reflectionMethod.invoke(receiverValue, argValues);
        }
        catch (InvocationTargetException ex) {
            return this.throwException(b, targetMethod, targetParameters, ex.getTargetException().getClass(), ex.getTargetException().getMessage());
        }
        catch (Throwable ex) {
            return this.throwException(b, targetMethod, targetParameters, ex.getClass(), ex.getMessage());
        }
        JavaKind returnKind = targetMethod.getSignature().getReturnKind();
        if (returnKind == JavaKind.Void) {
            ReflectionPlugins.traceConstant(b, targetMethod, targetParameters, JavaKind.Void);
            return true;
        }
        return this.pushConstant(b, targetMethod, targetParameters, returnKind, returnValue, false) != null;
    }

    private static boolean shouldInitializeAtRuntime(Class<?> classArg) {
        ClassInitializationSupport classInitializationSupport = (ClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        return classInitializationSupport.shouldInitializeAtRuntime(classArg);
    }

    private static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    private Object unbox(GraphBuilderContext b, ValueNode arg, JavaKind argKind) {
        if (!arg.isJavaConstant()) {
            return SubstrateGraphBuilderPlugins.extractClassArray(this.annotationSubstitutions, this.snippetReflection, arg, true);
        }
        JavaConstant argConstant = arg.asJavaConstant();
        if (argConstant.isNull()) {
            return NULL_MARKER;
        }
        switch (argKind) {
            case Boolean: {
                return (long)argConstant.asInt() != 0L;
            }
            case Byte: {
                return (byte)argConstant.asInt();
            }
            case Short: {
                return (short)argConstant.asInt();
            }
            case Char: {
                return Character.valueOf((char)argConstant.asInt());
            }
            case Int: {
                return argConstant.asInt();
            }
            case Long: {
                return argConstant.asLong();
            }
            case Float: {
                return Float.valueOf(argConstant.asFloat());
            }
            case Double: {
                return argConstant.asDouble();
            }
            case Object: {
                return this.unboxObjectConstant(b, argConstant);
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private Object unboxObjectConstant(GraphBuilderContext b, JavaConstant argConstant) {
        ResolvedJavaType javaType = b.getConstantReflection().asJavaType((Constant)argConstant);
        if (javaType != null) {
            return OriginalClassProvider.getJavaClass((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaType)javaType);
        }
        Object result = this.snippetReflection.asObject(Object.class, argConstant);
        if (ALLOWED_CONSTANT_CLASSES.contains(result.getClass())) {
            return result;
        }
        return null;
    }

    private <T> T getIntrinsic(GraphBuilderContext context, T element) {
        if (this.reason == ParsingReason.UnsafeSubstitutionAnalysis || this.reason == ParsingReason.EarlyClassInitializerAnalysis) {
            return element;
        }
        if (context.bciCanBeDuplicated()) {
            return null;
        }
        if (this.parseOnce || this.reason == ParsingReason.PointsToAnalysis) {
            if (ReflectionPlugins.isDeleted(element, context.getMetaAccess())) {
                return null;
            }
            Object replaced = this.aUniverse.replaceObject(element);
            if (this.parseOnce) {
                return (T)replaced;
            }
            ((ReflectionPluginRegistry)ImageSingletons.lookup(ReflectionPluginRegistry.class)).add(context.getMethod(), context.bci(), replaced);
        }
        return ((ReflectionPluginRegistry)ImageSingletons.lookup(ReflectionPluginRegistry.class)).get(context.getMethod(), context.bci());
    }

    private static <T> boolean isDeleted(T element, MetaAccessProvider metaAccess) {
        ResolvedJavaMethod annotated = null;
        try {
            if (element instanceof Executable) {
                annotated = metaAccess.lookupJavaMethod((Executable)element);
            } else if (element instanceof Field) {
                annotated = metaAccess.lookupJavaField((Field)element);
            }
        }
        catch (DeletedElementException ex) {
            return true;
        }
        return annotated != null && annotated.isAnnotationPresent(Delete.class);
    }

    private JavaConstant pushConstant(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Supplier<String> targetParameters, JavaKind returnKind, Object returnValue, boolean allowNullReturnValue) {
        Object intrinsicValue = this.getIntrinsic(b, returnValue == null && allowNullReturnValue ? NULL_MARKER : returnValue);
        if (intrinsicValue == null) {
            return null;
        }
        Object intrinsicConstant = returnKind.isPrimitive() ? JavaConstant.forBoxedPrimitive((Object)intrinsicValue) : (intrinsicValue == NULL_MARKER ? JavaConstant.NULL_POINTER : this.snippetReflection.forObject(intrinsicValue));
        b.addPush(returnKind, (ValueNode)ConstantNode.forConstant((JavaConstant)intrinsicConstant, (MetaAccessProvider)b.getMetaAccess()));
        ReflectionPlugins.traceConstant(b, targetMethod, targetParameters, intrinsicValue);
        return intrinsicConstant;
    }

    private boolean throwException(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Supplier<String> targetParameters, Class<? extends Throwable> exceptionClass, String originalMessage) {
        Method exceptionMethod = ExceptionSynthesizer.throwExceptionMethodOrNull(exceptionClass, String.class);
        if (exceptionMethod == null) {
            return false;
        }
        Method intrinsic = this.getIntrinsic(b, exceptionMethod);
        if (intrinsic == null) {
            return false;
        }
        String message = originalMessage + ". This exception was synthesized during native image building from a call to " + targetMethod.format("%H.%n(%p)") + " with constant arguments.";
        ExceptionSynthesizer.throwException(b, exceptionMethod, message);
        ReflectionPlugins.traceException(b, targetMethod, targetParameters, exceptionClass);
        return true;
    }

    private static void traceConstant(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Supplier<String> targetParameters, Object value) {
        if (Options.ReflectionPluginTracing.getValue().booleanValue()) {
            System.out.println("Call to " + targetMethod.format("%H.%n(%p)") + " reached in " + b.getMethod().format("%H.%n(%p)") + " with parameters (" + targetParameters.get() + ") was reduced to the constant " + value);
        }
    }

    private static void traceException(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Supplier<String> targetParameters, Class<? extends Throwable> exceptionClass) {
        if (Options.ReflectionPluginTracing.getValue().booleanValue()) {
            System.out.println("Call to " + targetMethod.format("%H.%n(%p)") + " reached in " + b.getMethod().format("%H.%n(%p)") + " with parameters (" + targetParameters.get() + ") was reduced to a \"throw new " + exceptionClass.getName() + "(...)\"");
        }
    }

    static class Options {
        static final HostedOptionKey<Boolean> ReflectionPluginTracing = new HostedOptionKey<Boolean>(false);

        Options() {
        }
    }

    public static class ReflectionPluginRegistry
    extends IntrinsificationPluginRegistry {
    }
}

