/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.UniqueShortNameProviderDefaultImpl;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.image.NativeImageBFDNameProvider;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class NativeImageDebugInfoFeature
implements InternalFeature {
    NativeImageDebugInfoFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (!UniqueShortNameProviderDefaultImpl.UseDefault.useDefaultProvider() && !ImageSingletons.contains(UniqueShortNameProvider.class)) {
            FeatureImpl.AfterRegistrationAccessImpl accessImpl = (FeatureImpl.AfterRegistrationAccessImpl)access;
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            ClassLoader appLoader = accessImpl.getApplicationClassLoader();
            ClassLoader imageLoader = accessImpl.getImageClassLoader().getClassLoader();
            ClassLoader imageLoaderParent = imageLoader.getParent();
            assert (imageLoaderParent == appLoader.getParent());
            List<ClassLoader> ignored = List.of(systemLoader, imageLoaderParent, appLoader, imageLoader);
            ImageSingletons.add(UniqueShortNameProvider.class, (Object)new NativeImageBFDNameProvider(ignored));
        }
    }
}

