/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

class HeapDumpHostedUtils {
    HeapDumpHostedUtils() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static byte[] dumpFieldsMap(Collection<? extends SharedType> types) {
        UnsafeArrayTypeWriter writeBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        HeapDumpHostedUtils.writeFieldsInfo(writeBuffer, types);
        int length = TypeConversion.asS4((long)writeBuffer.getBytesWritten());
        return writeBuffer.toArray(new byte[length]);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void writeFieldsInfo(UnsafeArrayTypeWriter writeBuffer, Collection<? extends SharedType> types) {
        for (SharedType sharedType : types) {
            SharedField field;
            if (!sharedType.isInstanceClass()) continue;
            ResolvedJavaField[] fields = sharedType.getInstanceFields(false);
            ResolvedJavaField[] sfields = sharedType.getStaticFields();
            if (fields.length == 0 && sfields.length == 0) continue;
            HeapDumpHostedUtils.writeString(writeBuffer, sharedType.toClassName());
            for (ResolvedJavaField resolvedJavaField : HeapDumpHostedUtils.inHotSpotFieldOrder(fields)) {
                if (!(resolvedJavaField instanceof SharedField)) continue;
                field = (SharedField)resolvedJavaField;
                HeapDumpHostedUtils.writeField(field, writeBuffer);
            }
            writeBuffer.putU1(0L);
            for (ResolvedJavaField resolvedJavaField : HeapDumpHostedUtils.inHotSpotFieldOrder(sfields)) {
                if (!(resolvedJavaField instanceof SharedField) || !(field = (SharedField)resolvedJavaField).isWritten() || !field.isAccessed()) continue;
                HeapDumpHostedUtils.writeField(field, writeBuffer);
            }
            writeBuffer.putU1(0L);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void writeField(SharedField field, UnsafeArrayTypeWriter writeBuffer) {
        int location = field.getLocation();
        if (location < 0) {
            return;
        }
        HeapDumpHostedUtils.writeString(writeBuffer, field.getName());
        writeBuffer.putU1((long)field.getJavaKind().getTypeChar());
        writeBuffer.putU1((long)field.getStorageKind().getTypeChar());
        writeBuffer.putU1((long)(location >>> 24 & 0xFF));
        writeBuffer.putU1((long)(location >>> 16 & 0xFF));
        writeBuffer.putU1((long)(location >>> 8 & 0xFF));
        writeBuffer.putU1((long)(location >>> 0 & 0xFF));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static ResolvedJavaField[] inHotSpotFieldOrder(ResolvedJavaField[] fields) {
        ResolvedJavaField[] reversed = new ResolvedJavaField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            reversed[fields.length - 1 - i] = fields[i];
        }
        return reversed;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void writeString(UnsafeArrayTypeWriter writeBuffer, String name) {
        try {
            byte[] buf;
            for (byte b : buf = name.getBytes("UTF-8")) {
                writeBuffer.putU1((long)b);
            }
            writeBuffer.putU1(0L);
        }
        catch (UnsupportedEncodingException ex) {
            VMError.shouldNotReachHere(ex);
        }
    }
}

