/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;

final class IsolatedRuntimeMethodInfoAccess {
    private static final RuntimeCodeInfoAccess.NonmovableArrayAction TRACK_ACTION = new RuntimeCodeInfoAccess.NonmovableArrayAction(){

        @Override
        @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
        public void apply(NonmovableArray<?> array) {
            NonmovableArrays.trackUnmanagedArray(array);
        }
    };
    private static final RuntimeCodeInfoAccess.NonmovableArrayAction UNTRACK_ACTION = new RuntimeCodeInfoAccess.NonmovableArrayAction(){

        @Override
        @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
        public void apply(NonmovableArray<?> array) {
            NonmovableArrays.untrackUnmanagedArray(array);
        }
    };

    public static void startTrackingInCurrentIsolate(CodeInfo info) {
        RuntimeCodeInfoAccess.forEachArray(info, TRACK_ACTION);
        InstalledCodeObserverSupport.attachToCurrentIsolate(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        RuntimeCodeInfoMemory.singleton().add(info);
    }

    public static void untrackInCurrentIsolate(CodeInfo info) {
        RuntimeCodeInfoMemory.singleton().remove(info);
        InstalledCodeObserverSupport.detachFromCurrentIsolate(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        RuntimeCodeInfoAccess.forEachArray(info, UNTRACK_ACTION);
    }

    private IsolatedRuntimeMethodInfoAccess() {
    }
}

