/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.thread.JavaThreadsFeature;
import com.oracle.svm.core.thread.PlatformThreads;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ThreadGroupNUnstartedThreadsRecomputation
implements FieldValueTransformer {
    ThreadGroupNUnstartedThreadsRecomputation() {
    }

    public Object transform(Object receiver, Object originalValue) {
        ThreadGroup group = (ThreadGroup)receiver;
        int result = 0;
        for (Thread thread : JavaThreadsFeature.singleton().reachableThreads.keySet()) {
            if (thread.getThreadGroup() != group || thread == PlatformThreads.singleton().mainThread) continue;
            ++result;
        }
        return result;
    }
}

