/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.JavaMonitorEnterEvent;
import com.oracle.svm.core.monitor.JavaMonitorQueuedSynchronizer;
import com.oracle.svm.core.util.VMError;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.CurrentIsolate;

public final class JavaMonitor
extends JavaMonitorQueuedSynchronizer {
    private long latestJfrTid = 0L;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long CONDITION_FIELD_OFFSET = U.objectFieldOffset(JavaMonitor.class, "condition");
    private JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject condition;

    public void monitorEnter(Object obj) {
        if (!this.tryLock()) {
            long startTicks = JfrTicks.elapsedTicks();
            this.lock();
            JavaMonitorEnterEvent.emit(obj, this.latestJfrTid, startTicks);
        }
        this.latestJfrTid = SubstrateJVM.getThreadId(CurrentIsolate.getCurrentThread());
    }

    public void monitorExit() {
        this.release(1);
    }

    public boolean isHeldByCurrentThread() {
        return this.isHeldExclusively();
    }

    protected JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject getOrCreateCondition(boolean createIfNotExisting) {
        JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject existingCondition = this.condition;
        if (existingCondition != null || !createIfNotExisting) {
            return existingCondition;
        }
        JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject newCondition = new JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject(this);
        if (!U.compareAndSetObject(this, CONDITION_FIELD_OFFSET, null, newCondition)) {
            newCondition = this.condition;
        }
        return newCondition;
    }

    public static JavaMonitor newLockedMonitorForThread(Thread thread, int recursionDepth) {
        JavaMonitor result = new JavaMonitor();
        for (int i = 0; i < recursionDepth; ++i) {
            result.lock();
        }
        result.latestJfrTid = SubstrateJVM.getThreadId(thread);
        assert (result.getExclusiveOwnerThread() == Thread.currentThread()) : "Must be locked by current thread";
        result.setExclusiveOwnerThread(thread);
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void relockObject() {
        Thread currentThread = Thread.currentThread();
        Thread ownerThread = this.getExclusiveOwnerThread();
        VMError.guarantee(ownerThread == null || ownerThread == currentThread, "Object that needs re-locking during deoptimization is already locked by another thread");
        int oldState = this.getState();
        int newState = oldState + 1;
        VMError.guarantee(newState > 0, "Maximum lock count exceeded");
        boolean success = U.compareAndSetInt(this, JavaMonitorQueuedSynchronizer.STATE, oldState, newState);
        VMError.guarantee(success, "Could not re-lock object during deoptimization");
        this.setExclusiveOwnerThread(currentThread);
    }

    boolean initialTryLock() {
        Thread current = Thread.currentThread();
        if (this.compareAndSetState(0, 1)) {
            this.setExclusiveOwnerThread(current);
            return true;
        }
        if (this.getExclusiveOwnerThread() == current) {
            int c = this.getState() + 1;
            if (c < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.setState(c);
            return true;
        }
        return false;
    }

    @Override
    protected boolean tryAcquire(int acquires) {
        if (this.getState() == 0 && this.compareAndSetState(0, acquires)) {
            this.setExclusiveOwnerThread(Thread.currentThread());
            return true;
        }
        return false;
    }

    boolean tryLock() {
        Thread current = Thread.currentThread();
        int c = this.getState();
        if (c == 0) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(current);
                return true;
            }
        } else if (this.getExclusiveOwnerThread() == current) {
            if (++c < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.setState(c);
            return true;
        }
        return false;
    }

    void lock() {
        if (!this.initialTryLock()) {
            this.acquire(1);
        }
    }

    @Override
    protected boolean tryRelease(int releases) {
        boolean free;
        int c = this.getState() - releases;
        if (this.getExclusiveOwnerThread() != Thread.currentThread()) {
            throw new IllegalMonitorStateException();
        }
        boolean bl = free = c == 0;
        if (free) {
            this.setExclusiveOwnerThread(null);
        }
        this.setState(c);
        return free;
    }

    @Override
    protected boolean isHeldExclusively() {
        return this.getExclusiveOwnerThread() == Thread.currentThread();
    }

    boolean isLocked() {
        return this.getState() != 0;
    }
}

