/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.jvmstat.AbstractPerfDataEntry;
import com.oracle.svm.core.jvmstat.MutablePerfDataEntry;
import com.oracle.svm.core.jvmstat.PerfString;
import com.oracle.svm.core.jvmstat.PerfVariability;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class PerfStringVariable
extends PerfString
implements MutablePerfDataEntry {
    private final byte[] nullTerminatedValue;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    PerfStringVariable(String name, int lengthInBytes) {
        super(name);
        assert (lengthInBytes > 0) : "at least the null terminator must fit into the array";
        this.nullTerminatedValue = new byte[lengthInBytes];
    }

    public void allocate() {
        this.allocate(PerfVariability.VARIABLE, JavaKind.Byte, this.nullTerminatedValue.length);
    }

    public void allocate(String initialValue) {
        this.allocate();
        byte[] stringBytes = AbstractPerfDataEntry.getBytes(initialValue, this.nullTerminatedValue.length - 1);
        System.arraycopy(stringBytes, 0, this.nullTerminatedValue, 0, stringBytes.length);
        this.nullTerminatedValue[stringBytes.length] = 0;
        PerfStringVariable.writeBytes(this.valuePtr, this.nullTerminatedValue);
    }

    @Override
    public void publish() {
        PerfStringVariable.writeBytes(this.valuePtr, this.nullTerminatedValue);
    }
}

