/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.traceid;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.hub.DynamicHub;
import java.util.Arrays;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrTraceIdMap {
    @UnknownObjectField(types={long[].class})
    private long[] traceIDs;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrTraceIdMap() {
    }

    @Fold
    static JfrTraceIdMap singleton() {
        return (JfrTraceIdMap)ImageSingletons.lookup(JfrTraceIdMap.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initialize(int size) {
        this.traceIDs = new long[size];
        Arrays.fill(this.traceIDs, -1L);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    long getId(int index) {
        return this.traceIDs[index];
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void setId(int index, long id) {
        this.traceIDs[index] = id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getId(Class<?> clazz) {
        long id = this.traceIDs[JfrTraceIdMap.getIndex(clazz)];
        assert (id != -1L);
        return id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void setId(Class<?> clazz, long id) {
        this.traceIDs[JfrTraceIdMap.getIndex(clazz)] = id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getIndex(Class<?> clazz) {
        DynamicHub hub = DynamicHub.fromClass(clazz);
        return hub.getTypeID() + 1;
    }
}

