/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

public class SafepointEndEvent {
    public static void emit(UnsignedWord safepointId, long startTick) {
        if (!HasJfrSupport.get() || startTick == 0L) {
            return;
        }
        SafepointEndEvent.emit0(safepointId, startTick);
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emit0(UnsignedWord safepointId, long startTick) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.SafepointEnd)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.SafepointEnd);
            JfrNativeEventWriter.putLong(data, startTick);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks() - startTick);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, safepointId.rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

