/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.Target_java_util_ServiceLoader;
import com.oracle.svm.core.jdk.Target_java_util_ServiceLoader_ProviderImpl;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.graalvm.compiler.core.common.SuppressFBWarnings;

@TargetClass(value=ServiceLoader.class, innerClass={"LazyClassPathLookupIterator"})
final class Target_java_util_ServiceLoader_LazyClassPathLookupIterator {
    @Alias
    ServiceLoader.Provider<?> nextProvider;
    @Alias
    ServiceConfigurationError nextError;
    @Alias
    Set<String> providerNames = new HashSet<String>();
    @Alias
    @TargetElement(name="this$0")
    Target_java_util_ServiceLoader outer;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Enumeration<URL> configs;

    @Substitute
    Target_java_util_ServiceLoader_LazyClassPathLookupIterator(Target_java_util_ServiceLoader outer) {
        this.outer = outer;
    }

    @Alias
    private native Class<?> nextProviderClass();

    @Substitute
    @SuppressFBWarnings(value={"BC_IMPOSSIBLE_CAST"}, justification="substitution hides acual type")
    private boolean hasNextService() {
        while (this.nextProvider == null && this.nextError == null) {
            try {
                Class<?> clazz = this.nextProviderClass();
                if (clazz == null) {
                    return false;
                }
                if (this.outer.service.isAssignableFrom(clazz)) {
                    Constructor<?> ctor = this.outer.getConstructor(clazz);
                    this.nextProvider = (ServiceLoader.Provider)((Object)new Target_java_util_ServiceLoader_ProviderImpl(this.outer.service, clazz, ctor, this.outer.acc));
                    continue;
                }
                Target_java_util_ServiceLoader.fail(this.outer.service, clazz.getName() + " not a subtype");
            }
            catch (ServiceConfigurationError e) {
                this.nextError = e;
            }
        }
        return true;
    }
}

