/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticallyRegisteredFeature
class SimpleWebServerFeature
implements InternalFeature {
    SimpleWebServerFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JavaVersionUtil.JAVA_SPEC >= 19;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.initializeAtRunTime("sun.net.httpserver.simpleserver.SimpleFileServerImpl", "Allocates InetAddress in class initializer");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(a -> ((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class)).addResourceBundles(ConfigurationCondition.alwaysTrue(), "sun.net.httpserver.simpleserver.resources.simpleserver"), new Object[]{access.findClassByName("sun.net.httpserver.simpleserver.SimpleFileServerImpl")});
    }
}

