/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.option.HostedOptionKey;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class FileSystemProviderSupport {
    final List<FileSystemProvider> installedProvidersMutable;
    final List<FileSystemProvider> installedProvidersImmutable;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    FileSystemProviderSupport(List<FileSystemProvider> installedProviders) {
        this.installedProvidersMutable = installedProviders;
        this.installedProvidersImmutable = Collections.unmodifiableList(installedProviders);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void register(FileSystemProvider provider) {
        List<FileSystemProvider> installedProviders = ((FileSystemProviderSupport)ImageSingletons.lookup(FileSystemProviderSupport.class)).installedProvidersMutable;
        String scheme = provider.getScheme();
        for (int i = 0; i < installedProviders.size(); ++i) {
            if (!installedProviders.get(i).getScheme().equalsIgnoreCase(scheme)) continue;
            installedProviders.set(i, provider);
            return;
        }
        installedProviders.add(provider);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void remove(String scheme) {
        List<FileSystemProvider> installedProviders = ((FileSystemProviderSupport)ImageSingletons.lookup(FileSystemProviderSupport.class)).installedProvidersMutable;
        for (int i = 0; i < installedProviders.size(); ++i) {
            if (!installedProviders.get(i).getScheme().equalsIgnoreCase(scheme)) continue;
            installedProviders.remove(i);
            return;
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> AddAllFileSystemProviders = new HostedOptionKey<Boolean>(true);
    }
}

