/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public final class CGlobalDataInfo {
    public static final String CGLOBALDATA_BASE_SYMBOL_NAME = "__svm_cglobaldata_base";
    public static final CGlobalData<Pointer> CGLOBALDATA_RUNTIME_BASE_ADDRESS = CGlobalDataFactory.forSymbol("__svm_cglobaldata_base");
    private final CGlobalDataImpl<?> data;
    private final boolean isSymbolReference;
    private boolean isGlobalSymbol;
    private boolean isHiddenSymbol;
    private int offset = -1;
    private int size = -1;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private byte[] bytes;

    public CGlobalDataInfo(CGlobalDataImpl<?> data) {
        assert (data != null);
        this.data = data;
        boolean bl = this.isSymbolReference = data.bytesSupplier == null && data.sizeSupplier == null;
        assert (!this.isSymbolReference || data.symbolName != null);
    }

    public CGlobalDataImpl<?> getData() {
        return this.data;
    }

    public void assignOffset(int offset) {
        assert (this.offset == -1) : "already initialized";
        assert (offset >= 0);
        this.offset = offset;
    }

    public void assignSize(int size) {
        assert (this.size == -1) : "already initialized";
        assert (this.bytes == null || this.bytes.length == size);
        assert (size >= 0);
        this.size = size;
    }

    public void assignBytes(byte[] bytes) {
        assert (this.bytes == null) : "already initialized";
        assert (this.size == -1 || this.size == bytes.length);
        this.bytes = bytes;
    }

    public int getOffset() {
        VMError.guarantee(this.offset >= 0, "Offset has not been initialized");
        return this.offset;
    }

    public int getSize() {
        VMError.guarantee(this.size >= 0, "size has not been initialized");
        return this.size;
    }

    public void makeGlobalSymbol() {
        VMError.guarantee(!this.isSymbolReference && this.data.symbolName != null, "Cannot change the local/global status of a symbol reference");
        this.isGlobalSymbol = true;
    }

    public boolean isGlobalSymbol() {
        return this.isGlobalSymbol;
    }

    public void makeHiddenSymbol() {
        this.isHiddenSymbol = true;
    }

    public boolean isHiddenSymbol() {
        return this.isHiddenSymbol;
    }

    public boolean isSymbolReference() {
        return this.isSymbolReference;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return this.data.toString();
    }
}

