/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.amd64.AMD64CPUFeatureAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.cpufeature.Stubs;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.amd64.AMD64CGlobalDataLoadAddressOp;
import com.oracle.svm.core.graal.amd64.AMD64CalleeSavedRegisters;
import com.oracle.svm.core.graal.amd64.AMD64FarReturnOp;
import com.oracle.svm.core.graal.amd64.AMD64LoadMethodPointerConstantOp;
import com.oracle.svm.core.graal.amd64.AMD64ReturnOp;
import com.oracle.svm.core.graal.amd64.AMD64SafepointCheckOp;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64AddressLowering;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.graal.code.SubstrateDebugInfoBuilder;
import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.graal.code.SubstrateNodeLIRBuilder;
import com.oracle.svm.core.graal.lir.VerificationMarkerOp;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.graal.nodes.ComputedIndirectCallTargetNode;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMapBuilder;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64LIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64LIRKindTool;
import org.graalvm.compiler.core.amd64.AMD64MoveFactory;
import org.graalvm.compiler.core.amd64.AMD64MoveFactoryBase;
import org.graalvm.compiler.core.amd64.AMD64NodeLIRBuilder;
import org.graalvm.compiler.core.amd64.AMD64NodeMatchRules;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.memory.MemoryExtendKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.core.gen.LIRGenerationProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64BreakpointOp;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.amd64.AMD64ControlFlow;
import org.graalvm.compiler.lir.amd64.AMD64FrameMap;
import org.graalvm.compiler.lir.amd64.AMD64FrameMapBuilder;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.amd64.AMD64PrefetchOp;
import org.graalvm.compiler.lir.amd64.AMD64VZeroUpper;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.framemap.FrameMapBuilderTool;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.gen.MoveFactory;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.amd64.AMD64IntrinsicStubs;
import org.graalvm.nativeimage.ImageSingletons;

public class SubstrateAMD64Backend
extends SubstrateBackend
implements LIRGenerationProvider {
    protected static CompressEncoding getCompressEncoding() {
        return (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
    }

    public SubstrateAMD64Backend(Providers providers) {
        super(providers);
    }

    public static boolean runtimeToAOTIsAvxSseTransition(TargetDescription target) {
        if (SubstrateUtil.HOSTED) {
            return false;
        }
        if (!AMD64CPUFeatureAccess.canUpdateCPUFeatures()) {
            return false;
        }
        AMD64 arch = (AMD64)target.arch;
        EnumSet<?> hostedCPUFeatures = ((CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class)).buildtimeCPUFeatures();
        EnumSet runtimeCPUFeatures = arch.getFeatures();
        return !hostedCPUFeatures.contains(AMD64.CPUFeature.AVX) && runtimeCPUFeatures.contains(AMD64.CPUFeature.AVX);
    }

    public static Object addressDisplacementAnnotation(SubstrateObjectConstant constant) {
        if (SubstrateUtil.HOSTED) {
            return constant;
        }
        return null;
    }

    public static int addressDisplacement(SubstrateObjectConstant constant, SharedConstantReflectionProvider constantReflection) {
        if (SubstrateUtil.HOSTED) {
            return 0;
        }
        return constantReflection.getImageHeapOffset(constant);
    }

    static void maybeTransitionToNative(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value javaFrameAnchor, Value temp, LIRFrameState state, int newThreadStatus) {
        if (ValueUtil.isIllegal((Value)javaFrameAnchor)) {
            assert (newThreadStatus == -1);
            return;
        }
        assert (VMThreads.StatusSupport.isValidStatus(newThreadStatus));
        Register anchor = ValueUtil.asRegister((Value)javaFrameAnchor);
        Register lastJavaIP = ValueUtil.asRegister((Value)temp);
        int startPos = masm.position();
        masm.leaq(lastJavaIP, new AMD64Address(AMD64.rip));
        crb.recordIndirectCall(startPos, masm.position(), null, state);
        KnownOffsets knownOffsets = KnownOffsets.singleton();
        masm.movq(new AMD64Address(anchor, knownOffsets.getJavaFrameAnchorLastIPOffset()), lastJavaIP);
        masm.movq(new AMD64Address(anchor, knownOffsets.getJavaFrameAnchorLastSPOffset()), AMD64.rsp);
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            masm.movl(new AMD64Address(ReservedRegisters.singleton().getThreadRegister(), knownOffsets.getVMThreadStatusOffset()), newThreadStatus);
        }
    }

    private void vzeroupperBeforeCall(SubstrateAMD64LIRGenerator gen, Value[] arguments, LIRFrameState callState, SharedMethod targetMethod) {
        if (SubstrateAMD64Backend.runtimeToAOTIsAvxSseTransition(gen.target()) && gen.getDestroysCallerSavedRegisters(targetMethod) && !this.isRuntimeToRuntimeCall(callState)) {
            gen.append((LIRInstruction)new AMD64VZeroUpper(arguments, (RegisterConfig)gen.getRegisterConfig()));
        }
    }

    private static ForeignCallDescriptor chooseCPUFeatureVariant(ForeignCallDescriptor descriptor, TargetDescription target, EnumSet<?> runtimeCheckedCPUFeatures) {
        EnumSet<?> buildtimeCPUFeatures = ((CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class)).buildtimeCPUFeatures();
        if (buildtimeCPUFeatures.containsAll(runtimeCheckedCPUFeatures) || !((AMD64)target.arch).getFeatures().containsAll(runtimeCheckedCPUFeatures)) {
            return descriptor;
        }
        GraalError.guarantee((boolean)DeoptimizationSupport.enabled(), (String)"should be reached in JIT mode only");
        return new ForeignCallDescriptor(descriptor.getName() + "RTC", descriptor.getResultType(), descriptor.getArgumentTypes(), descriptor.isReexecutable(), descriptor.getKilledLocations(), descriptor.canDeoptimize(), descriptor.isGuaranteedSafepoint());
    }

    private FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        AMD64FrameMap frameMap = new AMD64FrameMap(this.getProviders().getCodeCache(), registerConfigNonNull, (FrameMap.ReferenceMapBuilderFactory)new SubstrateReferenceMapBuilderFactory(), ((SubstrateAMD64RegisterConfig)registerConfigNonNull).shouldUseBasePointer());
        return new AMD64FrameMapBuilder((FrameMap)frameMap, this.getCodeCache(), registerConfigNonNull);
    }

    public LIRGenerationResult newLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, RegisterAllocationConfig registerAllocationConfig, StructuredGraph graph, Object stub) {
        SharedMethod method = (SharedMethod)graph.method();
        CallingConvention callingConvention = CodeUtil.getCallingConvention((CodeCacheProvider)this.getCodeCache(), (CallingConvention.Type)method.getCallingConventionKind().toType(false), (ResolvedJavaMethod)method, (ValueKindFactory)this);
        return new SubstrateLIRGenerationResult(compilationId, lir, this.newFrameMapBuilder(registerAllocationConfig.getRegisterConfig()), callingConvention, registerAllocationConfig, method);
    }

    protected AMD64ArithmeticLIRGenerator createArithmeticLIRGen(RegisterValue nullRegisterValue) {
        return new AMD64ArithmeticLIRGenerator((AllocatableValue)nullRegisterValue);
    }

    protected AMD64MoveFactoryBase createMoveFactory(LIRGenerationResult lirGenRes, MoveFactory.BackupSlotProvider backupSlotProvider) {
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenRes).getMethod();
        return new SubstrateAMD64MoveFactory(backupSlotProvider, method, this.createLirKindTool());
    }

    protected LIRKindTool createLirKindTool() {
        return new SubstrateAMD64LIRKindTool();
    }

    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        RegisterValue nullRegisterValue = SubstrateAMD64Backend.useLinearPointerCompression() ? ReservedRegisters.singleton().getHeapBaseRegister().asValue() : null;
        AMD64ArithmeticLIRGenerator arithmeticLIRGen = this.createArithmeticLIRGen(nullRegisterValue);
        MoveFactory.BackupSlotProvider backupSlotProvider = new MoveFactory.BackupSlotProvider(lirGenRes.getFrameMapBuilder());
        AMD64MoveFactoryBase moveFactory = this.createMoveFactory(lirGenRes, backupSlotProvider);
        return new SubstrateAMD64LIRGenerator(this.createLirKindTool(), arithmeticLIRGen, (MoveFactory)moveFactory, this.getProviders(), lirGenRes);
    }

    protected AMD64NodeMatchRules createMatchRules(LIRGeneratorTool lirGen) {
        return new AMD64NodeMatchRules(lirGen);
    }

    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        AMD64NodeMatchRules nodeMatchRules = this.createMatchRules(lirGen);
        return new SubstrateAMD64NodeLIRBuilder(graph, lirGen, nodeMatchRules);
    }

    protected static boolean useLinearPointerCompression() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenResult, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory) {
        LIR lir = lirGenResult.getLIR();
        OptionValues options = lir.getOptions();
        AMD64MacroAssembler masm = new AMD64MacroAssembler(this.getTarget(), options);
        PatchConsumerFactory patchConsumerFactory = SubstrateUtil.HOSTED ? PatchConsumerFactory.HostedPatchConsumerFactory.factory() : PatchConsumerFactory.NativePatchConsumerFactory.factory();
        masm.setCodePatchingAnnotationConsumer(patchConsumerFactory.newConsumer(compilationResult));
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenResult).getMethod();
        Deoptimizer.StubType stubType = method.getDeoptStubType();
        SubstrateDataBuilder dataBuilder = new SubstrateDataBuilder();
        CallingConvention callingConvention = lirGenResult.getCallingConvention();
        SubstrateAMD64FrameContext frameContext = stubType == Deoptimizer.StubType.EntryStub ? new DeoptEntryStubContext(method, callingConvention) : (stubType == Deoptimizer.StubType.ExitStub ? new DeoptExitStubContext(method, callingConvention) : this.createFrameContext(method, callingConvention));
        DebugContext debug = lir.getDebug();
        Register uncompressedNullRegister = SubstrateAMD64Backend.useLinearPointerCompression() ? ReservedRegisters.singleton().getHeapBaseRegister() : Register.None;
        CompilationResultBuilder tasm = factory.createBuilder((CodeGenProviders)this.getProviders(), lirGenResult.getFrameMap(), (Assembler)masm, (DataBuilder)dataBuilder, (FrameContext)frameContext, options, debug, compilationResult, uncompressedNullRegister);
        tasm.setTotalFrameSize(lirGenResult.getFrameMap().totalFrameSize());
        return tasm;
    }

    protected FrameContext createFrameContext(SharedMethod method, CallingConvention callingConvention) {
        return new SubstrateAMD64FrameContext(method, callingConvention);
    }

    @Override
    public BasePhase<CoreProviders> newAddressLoweringPhase(CodeCacheProvider codeCache) {
        CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
        return new AddressLoweringPhase((AddressLoweringPhase.AddressLowering)new SubstrateAMD64AddressLowering(compressEncoding));
    }

    public CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, boolean isDefault, OptionValues options) {
        return new SubstrateCompiledCode(compilationResult);
    }

    public void emitCode(CompilationResultBuilder crb, LIR lir, ResolvedJavaMethod installedCodeOwner) {
        crb.emit(lir);
    }

    @Override
    public CompilationResult createJNITrampolineMethod(ResolvedJavaMethod method, CompilationIdentifier identifier, RegisterValue threadArg, int threadIsolateOffset, RegisterValue methodIdArg, int methodObjEntryPointOffset) {
        CompilationResult result = new CompilationResult(identifier);
        AMD64Assembler asm = new AMD64Assembler(this.getTarget());
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            asm.movq(AMD64.rax, new AMD64Address(threadArg.getRegister(), threadIsolateOffset));
            asm.addq(AMD64.rax, methodIdArg.getRegister());
            asm.jmp(new AMD64Address(AMD64.rax, methodObjEntryPointOffset));
        } else {
            asm.jmp(new AMD64Address(methodIdArg.getRegister(), methodObjEntryPointOffset));
        }
        result.recordMark(asm.position(), (CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
        result.recordMark(asm.position(), (CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
        byte[] instructions = asm.close(true);
        result.setTargetCode(instructions, instructions.length);
        result.setTotalFrameSize(this.getTarget().wordSize);
        return result;
    }

    protected static class SubstrateAMD64LIRKindTool
    extends AMD64LIRKindTool {
        protected SubstrateAMD64LIRKindTool() {
        }

        public LIRKind getNarrowOopKind() {
            return LIRKind.compressedReference((PlatformKind)AMD64Kind.QWORD);
        }

        public LIRKind getNarrowPointerKind() {
            throw VMError.shouldNotReachHere();
        }
    }

    protected static class SubstrateAMD64MoveFactory
    extends AMD64MoveFactory {
        private final SharedMethod method;
        protected final LIRKindTool lirKindTool;

        protected SubstrateAMD64MoveFactory(MoveFactory.BackupSlotProvider backupSlotProvider, SharedMethod method, LIRKindTool lirKindTool) {
            super(backupSlotProvider);
            this.method = method;
            this.lirKindTool = lirKindTool;
        }

        public boolean allowConstantToStackMove(Constant constant) {
            if (constant instanceof SubstrateObjectConstant && this.method.isDeoptTarget()) {
                return false;
            }
            return super.allowConstantToStackMove(constant);
        }

        private static JavaConstant getZeroConstant(AllocatableValue dst) {
            int size = dst.getPlatformKind().getSizeInBytes() * 8;
            switch (size) {
                case 32: {
                    return JavaConstant.INT_0;
                }
                case 64: {
                    return JavaConstant.LONG_0;
                }
            }
            throw VMError.shouldNotReachHere();
        }

        public AMD64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals(src)) {
                return super.createLoad(dst, (Constant)SubstrateAMD64MoveFactory.getZeroConstant(dst));
            }
            if (src instanceof SubstrateObjectConstant) {
                return this.loadObjectConstant(dst, (SubstrateObjectConstant)src);
            }
            if (src instanceof SubstrateMethodPointerConstant) {
                return new AMD64LoadMethodPointerConstantOp(dst, (SubstrateMethodPointerConstant)src);
            }
            return super.createLoad(dst, src);
        }

        public LIRInstruction createStackLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals(src)) {
                return super.createStackLoad(dst, (Constant)SubstrateAMD64MoveFactory.getZeroConstant(dst));
            }
            if (src instanceof SubstrateObjectConstant) {
                return this.loadObjectConstant(dst, (SubstrateObjectConstant)src);
            }
            if (src instanceof SubstrateMethodPointerConstant) {
                return new AMD64LoadMethodPointerConstantOp(dst, (SubstrateMethodPointerConstant)src);
            }
            return super.createStackLoad(dst, src);
        }

        protected AMD64LIRInstruction loadObjectConstant(AllocatableValue dst, SubstrateObjectConstant constant) {
            if (ReferenceAccess.singleton().haveCompressedReferences()) {
                RegisterValue heapBase = ReservedRegisters.singleton().getHeapBaseRegister().asValue();
                return new LoadCompressedObjectConstantOp(dst, constant, (AllocatableValue)heapBase, SubstrateAMD64Backend.getCompressEncoding(), this.lirKindTool);
            }
            return new AMD64Move.MoveFromConstOp(dst, (JavaConstant)constant);
        }

        public static final class LoadCompressedObjectConstantOp
        extends AMD64Move.PointerCompressionOp
        implements StandardOp.LoadConstantOp {
            public static final LIRInstructionClass<LoadCompressedObjectConstantOp> TYPE = LIRInstructionClass.create(LoadCompressedObjectConstantOp.class);
            private final SubstrateObjectConstant constant;

            static JavaConstant asCompressed(SubstrateObjectConstant constant) {
                return constant.isCompressed() ? constant : constant.compress();
            }

            LoadCompressedObjectConstantOp(AllocatableValue result, SubstrateObjectConstant constant, AllocatableValue baseRegister, CompressEncoding encoding, LIRKindTool lirKindTool) {
                super(TYPE, result, (Value)new ConstantValue((ValueKind)lirKindTool.getNarrowOopKind(), (Constant)LoadCompressedObjectConstantOp.asCompressed(constant)), baseRegister, encoding, true, lirKindTool);
                this.constant = constant;
            }

            public Constant getConstant() {
                return this.constant;
            }

            public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
                Register resultReg = this.getResultRegister();
                int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
                Constant inputConstant = LIRValueUtil.asConstantValue((Value)this.getInput()).getConstant();
                if (masm.inlineObjects()) {
                    crb.recordInlineDataInCode(inputConstant);
                    if (referenceSize == 4) {
                        masm.movl(resultReg, -559030611, true);
                    } else {
                        masm.movq(resultReg, -2401018187971961171L, true);
                    }
                } else {
                    AMD64Address address = (AMD64Address)crb.recordDataReferenceInCode(inputConstant, referenceSize);
                    if (referenceSize == 4) {
                        masm.movl(resultReg, address);
                    } else {
                        masm.movq(resultReg, address);
                    }
                }
                if (!this.constant.isCompressed()) {
                    Register baseReg = this.getBaseRegister();
                    boolean preserveFlagsRegister = true;
                    LoadCompressedObjectConstantOp.emitUncompressWithBaseRegister((AMD64MacroAssembler)masm, (Register)resultReg, (Register)baseReg, (int)this.getShift(), (boolean)preserveFlagsRegister);
                }
            }
        }
    }

    static class SubstrateReferenceMapBuilderFactory
    implements FrameMap.ReferenceMapBuilderFactory {
        SubstrateReferenceMapBuilderFactory() {
        }

        public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
            return new SubstrateReferenceMapBuilder(totalFrameSize);
        }
    }

    protected static class DeoptExitStubContext
    extends SubstrateAMD64FrameContext {
        protected DeoptExitStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method, callingConvention);
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            Register firstParameter = ValueUtil.asRegister((Value)this.callingConvention.getArgument(0));
            asm.movq(AMD64.rsp, firstParameter);
            asm.subq(AMD64.rsp, FrameAccess.returnAddressSize());
            super.enter(tasm);
        }

        @Override
        public void leave(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            RegisterConfig registerConfig = tasm.frameMap.getRegisterConfig();
            Register gpReturnReg = registerConfig.getReturnRegister(JavaKind.Long);
            Register fpReturnReg = registerConfig.getReturnRegister(JavaKind.Double);
            super.leave(tasm);
            int scratchOffset = DeoptimizedFrame.getScratchSpaceOffset();
            asm.movq(fpReturnReg, new AMD64Address(gpReturnReg, scratchOffset + 8));
            asm.movq(gpReturnReg, new AMD64Address(gpReturnReg, scratchOffset));
        }
    }

    protected static class DeoptEntryStubContext
    extends SubstrateAMD64FrameContext {
        protected DeoptEntryStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method, callingConvention);
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            RegisterConfig registerConfig = tasm.frameMap.getRegisterConfig();
            Register gpReturnReg = registerConfig.getReturnRegister(JavaKind.Long);
            Register fpReturnReg = registerConfig.getReturnRegister(JavaKind.Double);
            Register deoptimizedFrame = ValueUtil.asRegister((Value)this.callingConvention.getArgument(0));
            assert (!deoptimizedFrame.equals((Object)gpReturnReg)) : "overwriting return reg";
            asm.movq(deoptimizedFrame, new AMD64Address(registerConfig.getFrameRegister(), 0));
            int scratchOffset = DeoptimizedFrame.getScratchSpaceOffset();
            asm.movq(new AMD64Address(deoptimizedFrame, scratchOffset), gpReturnReg);
            asm.movq(new AMD64Address(deoptimizedFrame, scratchOffset + 8), fpReturnReg);
            super.enter(tasm);
        }
    }

    protected static class SubstrateAMD64FrameContext
    implements FrameContext {
        protected final SharedMethod method;
        protected final CallingConvention callingConvention;

        protected SubstrateAMD64FrameContext(SharedMethod method, CallingConvention callingConvention) {
            this.method = method;
            this.callingConvention = callingConvention;
        }

        public void enter(CompilationResultBuilder crb) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            this.makeFrame(crb, asm);
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
            if (this.method.hasCalleeSavedRegisters()) {
                VMError.guarantee(!this.method.isDeoptTarget(), "Deoptimization runtime cannot fill the callee saved registers");
                AMD64CalleeSavedRegisters.singleton().emitSave((AMD64MacroAssembler)crb.asm, crb.frameMap.totalFrameSize(), crb);
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
        }

        protected void makeFrame(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            this.maybePushBasePointer(crb, asm);
            asm.decrementq(AMD64.rsp, crb.frameMap.frameSize());
        }

        protected void maybePushBasePointer(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
            if (((SubstrateAMD64RegisterConfig)crb.frameMap.getRegisterConfig()).shouldUseBasePointer()) {
                asm.push(AMD64.rbp);
                asm.movq(AMD64.rbp, AMD64.rsp);
            }
        }

        public void leave(CompilationResultBuilder crb) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_START);
            if (this.method.hasCalleeSavedRegisters()) {
                JavaKind returnKind = this.method.getSignature().getReturnKind();
                Register returnRegister = null;
                if (returnKind != JavaKind.Void) {
                    returnRegister = crb.frameMap.getRegisterConfig().getReturnRegister(returnKind);
                }
                AMD64CalleeSavedRegisters.singleton().emitRestore((AMD64MacroAssembler)crb.asm, crb.frameMap.totalFrameSize(), returnRegister, crb);
            }
            if (((SubstrateAMD64RegisterConfig)crb.frameMap.getRegisterConfig()).shouldUseBasePointer()) {
                asm.movq(AMD64.rsp, AMD64.rbp);
                asm.pop(AMD64.rbp);
            } else {
                asm.incrementq(AMD64.rsp, crb.frameMap.frameSize());
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_INCD_RSP);
        }

        public void returned(CompilationResultBuilder crb) {
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_END);
        }

        public boolean hasFrame() {
            return true;
        }
    }

    public final class SubstrateAMD64NodeLIRBuilder
    extends AMD64NodeLIRBuilder
    implements SubstrateNodeLIRBuilder {
        public SubstrateAMD64NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AMD64NodeMatchRules nodeMatchRules) {
            super(graph, gen, nodeMatchRules);
        }

        public void visitSafepointNode(SafepointNode node) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void visitBreakpointNode(BreakpointNode node) {
            JavaType[] sig = new JavaType[node.arguments().size()];
            for (int i = 0; i < sig.length; ++i) {
                sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
            }
            CallingConvention convention = this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), null, sig, (ValueKindFactory)this.gen);
            this.append((LIRInstruction)new AMD64BreakpointOp(this.visitInvokeArguments(convention, (Collection<ValueNode>)node.arguments())));
        }

        protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
            return new SubstrateDebugInfoBuilder(graph, this.gen.getProviders().getMetaAccessExtensionProvider(), nodeValueMap);
        }

        protected void prologSetParameterNodes(StructuredGraph graph, Value[] params) {
            SubstrateCallingConvention convention = (SubstrateCallingConvention)this.gen.getResult().getCallingConvention();
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                Value inputValue = params[param.index()];
                Variable paramValue = this.gen.emitMove(inputValue);
                if (inputValue.getPlatformKind().getSizeInBytes() < 4) {
                    SubstrateCallingConventionType type = (SubstrateCallingConventionType)convention.getType();
                    assert (!type.outgoing && type.nativeABI());
                    JavaKind kind = convention.getArgumentStorageKinds()[param.index()];
                    JavaKind stackKind = kind.getStackKind();
                    paramValue = kind.isUnsigned() ? this.gen.getArithmetic().emitZeroExtend((Value)paramValue, kind.getBitCount(), stackKind.getBitCount()) : this.gen.getArithmetic().emitSignExtend((Value)paramValue, kind.getBitCount(), stackKind.getBitCount());
                }
                assert (paramValue.getValueKind().equals(this.gen.getLIRKind(param.stamp(NodeView.DEFAULT))));
                this.setResult((ValueNode)param, (Value)paramValue);
            }
        }

        public Value[] visitInvokeArguments(CallingConvention invokeCc, Collection<ValueNode> arguments) {
            Value[] values = super.visitInvokeArguments(invokeCc, arguments);
            SubstrateCallingConventionType type = (SubstrateCallingConventionType)((SubstrateCallingConvention)invokeCc).getType();
            if (type.nativeABI()) {
                int xmmCount = 0;
                for (Value v : values) {
                    if (!ValueUtil.isRegister((Value)v) || !ValueUtil.asRegister((Value)v).getRegisterCategory().equals((Object)AMD64.XMM)) continue;
                    ++xmmCount;
                }
                assert (xmmCount <= 8);
                RegisterValue xmmCountRegister = AMD64.rax.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.DWORD));
                this.gen.emitMoveConstant((AllocatableValue)xmmCountRegister, (Constant)JavaConstant.forInt((int)xmmCount));
            }
            return values;
        }

        private boolean getDestroysCallerSavedRegisters(ResolvedJavaMethod targetMethod) {
            return ((SubstrateAMD64LIRGenerator)this.gen).getDestroysCallerSavedRegisters(targetMethod);
        }

        private Value getExceptionTemp(CallTargetNode callTarget) {
            if (callTarget.invoke() instanceof InvokeWithExceptionNode) {
                return this.gen.getRegisterConfig().getReturnRegister(JavaKind.Object).asValue();
            }
            return Value.ILLEGAL;
        }

        protected void emitInvoke(LoweredCallTargetNode callTarget, Value[] parameters, LIRFrameState callState, Value result) {
            SubstrateAMD64Backend.verifyCallTarget(callTarget);
            if (callTarget instanceof ComputedIndirectCallTargetNode) {
                this.emitComputedIndirectCall((ComputedIndirectCallTargetNode)callTarget, result, parameters, (Value[])AllocatableValue.NONE, callState);
            } else {
                super.emitInvoke(callTarget, parameters, callState, result);
            }
        }

        protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            this.append((LIRInstruction)new SubstrateAMD64DirectCallOp(targetMethod, result, parameters, temps, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget), (Value)this.setupJavaFrameAnchorTemp((CallTargetNode)callTarget), SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget), this.getDestroysCallerSavedRegisters(targetMethod), this.getExceptionTemp((CallTargetNode)callTarget)));
        }

        protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            Register targetRegister = AMD64.rax;
            if (((SubstrateCallingConventionType)callTarget.callType()).nativeABI()) {
                targetRegister = AMD64.r10;
            }
            RegisterValue targetAddress = targetRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)targetAddress, this.operand((Node)callTarget.computedAddress()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            this.append((LIRInstruction)new SubstrateAMD64IndirectCallOp(targetMethod, result, parameters, temps, (Value)targetAddress, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget), (Value)this.setupJavaFrameAnchorTemp((CallTargetNode)callTarget), SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget), this.getDestroysCallerSavedRegisters(targetMethod), this.getExceptionTemp((CallTargetNode)callTarget)));
        }

        protected void emitComputedIndirectCall(ComputedIndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            assert (!((SubstrateCallingConventionType)callTarget.callType()).nativeABI());
            RegisterValue addressBase = AMD64.rax.asValue((ValueKind)callTarget.getAddressBase().stamp(NodeView.DEFAULT).getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)addressBase, this.operand((Node)callTarget.getAddressBase()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall((SubstrateAMD64LIRGenerator)this.getLIRGeneratorTool(), parameters, callState, (SharedMethod)targetMethod);
            this.append((LIRInstruction)new SubstrateAMD64ComputedIndirectCallOp(targetMethod, result, parameters, temps, (Value)addressBase, callTarget.getAddressComputation(), callState, this.getExceptionTemp((CallTargetNode)callTarget), this.gen.getLIRKindTool(), (SharedConstantReflectionProvider)SubstrateAMD64Backend.this.getConstantReflection()));
        }

        private AllocatableValue setupJavaFrameAnchor(CallTargetNode callTarget) {
            if (!SubstrateBackend.hasJavaFrameAnchor(callTarget)) {
                return Value.ILLEGAL;
            }
            Register frameAnchorRegister = AMD64.r13;
            RegisterValue frameAnchor = frameAnchorRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)frameAnchor, this.operand((Node)SubstrateBackend.getJavaFrameAnchor(callTarget)));
            return frameAnchor;
        }

        private AllocatableValue setupJavaFrameAnchorTemp(CallTargetNode callTarget) {
            if (!SubstrateBackend.hasJavaFrameAnchor(callTarget)) {
                return Value.ILLEGAL;
            }
            return AMD64.r12.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
        }

        public void emitBranch(LogicNode node, LabelRef trueSuccessor, LabelRef falseSuccessor, double trueSuccessorProbability) {
            if (node instanceof SafepointCheckNode) {
                AMD64SafepointCheckOp op = new AMD64SafepointCheckOp();
                this.append((LIRInstruction)op);
                this.append((LIRInstruction)new AMD64ControlFlow.BranchOp(op.getConditionFlag(), trueSuccessor, falseSuccessor, trueSuccessorProbability));
            } else {
                super.emitBranch(node, trueSuccessor, falseSuccessor, trueSuccessorProbability);
            }
        }

        @Override
        public void emitCGlobalDataLoadAddress(CGlobalDataLoadAddressNode node) {
            Variable result = this.gen.newVariable((ValueKind)this.gen.getLIRKindTool().getWordKind());
            this.append((LIRInstruction)new AMD64CGlobalDataLoadAddressOp(node.getDataInfo(), (AllocatableValue)result));
            this.setResult((ValueNode)node, (Value)result);
        }

        @Override
        public Variable emitReadReturnAddress() {
            assert (FrameAccess.returnAddressSize() > 0);
            return this.getLIRGeneratorTool().emitMove((Value)StackSlot.get((ValueKind)this.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (int)(-FrameAccess.returnAddressSize()), (boolean)true));
        }

        public ForeignCallLinkage lookupGraalStub(ValueNode valueNode, ForeignCallDescriptor foreignCallDescriptor) {
            ResolvedJavaMethod method = valueNode.graph().method();
            if (method != null && GuardedAnnotationAccess.getAnnotation((AnnotatedElement)method, SubstrateForeignCallTarget.class) != null) {
                return null;
            }
            if (AMD64IntrinsicStubs.shouldInlineIntrinsic((ValueNode)valueNode, (LIRGenerator)this.gen)) {
                return null;
            }
            return this.gen.getForeignCalls().lookupForeignCall(SubstrateAMD64Backend.chooseCPUFeatureVariant(foreignCallDescriptor, this.gen.target(), Stubs.getRequiredCPUFeatures(valueNode.getClass())));
        }
    }

    protected class SubstrateAMD64LIRGenerator
    extends AMD64LIRGenerator
    implements SubstrateLIRGenerator {
        public SubstrateAMD64LIRGenerator(LIRKindTool lirKindTool, AMD64ArithmeticLIRGenerator arithmeticLIRGen, MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
            super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes);
        }

        public void emitReturn(JavaKind kind, Value input) {
            AllocatableValue operand = Value.ILLEGAL;
            if (input != null) {
                operand = this.resultOperandFor(kind, input.getValueKind());
                this.emitMove(operand, input);
            }
            this.append((LIRInstruction)new AMD64ReturnOp((Value)operand));
        }

        public SubstrateLIRGenerationResult getResult() {
            return (SubstrateLIRGenerationResult)super.getResult();
        }

        public SubstrateRegisterConfig getRegisterConfig() {
            return (SubstrateRegisterConfig)super.getRegisterConfig();
        }

        protected boolean getDestroysCallerSavedRegisters(ResolvedJavaMethod targetMethod) {
            if (this.getResult().getMethod().isDeoptTarget()) {
                return true;
            }
            return targetMethod == null || !((SharedMethod)targetMethod).hasCalleeSavedRegisters();
        }

        protected Value emitIndirectForeignCallAddress(ForeignCallLinkage linkage) {
            if (!SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                return null;
            }
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            SharedMethod targetMethod = (SharedMethod)callTarget.getMethod();
            Value codeOffsetInImage = this.emitConstant(this.getLIRKindTool().getWordKind(), (Constant)JavaConstant.forLong((long)targetMethod.getCodeOffsetInImage()));
            Value codeInfo = this.emitJavaConstant(SubstrateObjectConstant.forObject(CodeInfoTable.getImageCodeCache()));
            AMD64AddressValue codeStartField = new AMD64AddressValue((ValueKind)this.getLIRKindTool().getWordKind(), this.asAllocatable(codeInfo), KnownOffsets.singleton().getImageCodeInfoCodeStartOffset());
            Variable codeStart = this.getArithmetic().emitLoad(this.getLIRKindTool().getWordKind(), (Value)codeStartField, null, MemoryOrderMode.PLAIN, MemoryExtendKind.DEFAULT);
            return this.getArithmetic().emitAdd((Value)codeStart, codeOffsetInImage, false);
        }

        protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            SharedMethod targetMethod = (SharedMethod)callTarget.getMethod();
            SubstrateAMD64Backend.this.vzeroupperBeforeCall(this, arguments, info, targetMethod);
            if (SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                RegisterValue targetRegister = AMD64.rax.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRKindTool()));
                this.emitMove((AllocatableValue)targetRegister, targetAddress);
                this.append((LIRInstruction)new SubstrateAMD64IndirectCallOp(targetMethod, result, arguments, temps, (Value)targetRegister, info, (Value)Value.ILLEGAL, (Value)Value.ILLEGAL, -1, this.getDestroysCallerSavedRegisters(targetMethod), (Value)Value.ILLEGAL));
            } else {
                assert (targetAddress == null);
                this.append((LIRInstruction)new SubstrateAMD64DirectCallOp(targetMethod, result, arguments, temps, info, (Value)Value.ILLEGAL, (Value)Value.ILLEGAL, -1, this.getDestroysCallerSavedRegisters(targetMethod), (Value)Value.ILLEGAL));
            }
        }

        public void emitUnwind(Value operand) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
            throw VMError.shouldNotReachHere("Substrate VM does not use deoptimization");
        }

        public void emitCCall(long address, CallingConvention nativeCallingConvention, Value[] args, int numberOfFloatingPointArguments) {
            throw VMError.unimplemented();
        }

        @Override
        public void emitVerificationMarker(Object marker) {
            this.append(new VerificationMarkerOp(marker));
        }

        @Override
        public void emitInstructionSynchronizationBarrier() {
            throw VMError.shouldNotReachHere("AMD64 does not need instruction synchronization");
        }

        @Override
        public void emitFarReturn(AllocatableValue result, Value sp, Value ip, boolean fromMethodWithCalleeSavedRegisters) {
            this.append((LIRInstruction)new AMD64FarReturnOp(result, this.asAllocatable(sp), this.asAllocatable(ip), fromMethodWithCalleeSavedRegisters));
        }

        @Override
        public void emitDeadEnd() {
            this.append(new DeadEndOp());
        }

        public void emitPrefetchAllocate(Value address) {
            this.append((LIRInstruction)new AMD64PrefetchOp(this.asAddressValue(address), SubstrateOptions.AllocatePrefetchInstr.getValue().intValue()));
        }

        public Value emitCompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getNarrowOopKind());
            boolean nonNull = SubstrateAMD64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AMD64Move.CompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)ReservedRegisters.singleton().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            assert (((LIRKind)pointer.getValueKind(LIRKind.class)).getPlatformKind() == this.getLIRKindTool().getNarrowOopKind().getPlatformKind());
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getObjectKind());
            boolean nonNull = SubstrateAMD64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AMD64Move.UncompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)ReservedRegisters.singleton().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public void emitConvertNullToZero(AllocatableValue result, AllocatableValue value) {
            if (SubstrateAMD64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AMD64Move.ConvertNullToZeroOp(result, value));
            } else {
                this.emitMove(result, (Value)value);
            }
        }

        public void emitConvertZeroToNull(AllocatableValue result, Value value) {
            if (SubstrateAMD64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AMD64Move.ConvertZeroToNullOp(result, (AllocatableValue)value));
            } else {
                this.emitMove(result, value);
            }
        }

        public int getArrayLengthOffset() {
            return ConfigurationValues.getObjectLayout().getArrayLengthOffset();
        }
    }

    protected static final class SubstrateLIRGenerationResult
    extends LIRGenerationResult {
        private final SharedMethod method;

        public SubstrateLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, CallingConvention callingConvention, RegisterAllocationConfig registerAllocationConfig, SharedMethod method) {
            super(compilationId, lir, frameMapBuilder, registerAllocationConfig, callingConvention);
            this.method = method;
            if (method.hasCalleeSavedRegisters()) {
                AMD64CalleeSavedRegisters calleeSavedRegisters = AMD64CalleeSavedRegisters.singleton();
                FrameMap frameMap = ((FrameMapBuilderTool)frameMapBuilder).getFrameMap();
                int registerSaveAreaSizeInBytes = calleeSavedRegisters.getSaveAreaSize();
                StackSlot calleeSaveArea = frameMap.allocateStackMemory(registerSaveAreaSizeInBytes, frameMap.getTarget().wordSize);
                calleeSavedRegisters.verifySaveAreaOffsetInFrame(calleeSaveArea.getRawOffset());
            }
            if (method.canDeoptimize() || method.isDeoptTarget()) {
                ((FrameMapBuilderTool)frameMapBuilder).getFrameMap().reserveOutgoing(16);
            }
        }

        public SharedMethod getMethod() {
            return this.method;
        }
    }

    @Opcode(value="DEAD_END")
    public static class DeadEndOp
    extends LIRInstruction
    implements StandardOp.BlockEndOp {
        public static final LIRInstructionClass<DeadEndOp> TYPE = LIRInstructionClass.create(DeadEndOp.class);

        public DeadEndOp() {
            super(TYPE);
        }

        public void emitCode(CompilationResultBuilder crb) {
            if (SubstrateUtil.assertionsEnabled()) {
                ((AMD64Assembler)crb.asm).int3();
            }
        }
    }

    @Opcode(value="CALL_COMPUTED_INDIRECT")
    public static class SubstrateAMD64ComputedIndirectCallOp
    extends AMD64Call.MethodCallOp {
        public static final LIRInstructionClass<SubstrateAMD64ComputedIndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64ComputedIndirectCallOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        private Value addressBase;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        private Value addressBaseTemp;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        private final ComputedIndirectCallTargetNode.Computation[] addressComputation;
        private final LIRKindTool lirKindTool;
        private final SharedConstantReflectionProvider constantReflection;

        public SubstrateAMD64ComputedIndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value addressBase, ComputedIndirectCallTargetNode.Computation[] addressComputation, LIRFrameState state, Value exceptionTemp, LIRKindTool lirKindTool, SharedConstantReflectionProvider constantReflection) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.addressBase = this.addressBaseTemp = addressBase;
            this.exceptionTemp = exceptionTemp;
            this.addressComputation = addressComputation;
            this.lirKindTool = lirKindTool;
            this.constantReflection = constantReflection;
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, addressBase}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            VMError.guarantee(SubstrateOptions.SpawnIsolates.getValue(), "Memory access without isolates is not implemented");
            CompressEncoding compressEncoding = ReferenceAccess.singleton().getCompressEncoding();
            Register computeRegister = ValueUtil.asRegister((Value)this.addressBase);
            AMD64BaseAssembler.OperandSize lastOperandSize = AMD64BaseAssembler.OperandSize.get((PlatformKind)this.addressBase.getPlatformKind());
            boolean nextMemoryAccessNeedsDecompress = false;
            for (ComputedIndirectCallTargetNode.Computation computation : this.addressComputation) {
                AMD64Address memoryAddress;
                SharedField field;
                Label done = null;
                if (computation instanceof ComputedIndirectCallTargetNode.FieldLoad) {
                    field = (SharedField)((ComputedIndirectCallTargetNode.FieldLoad)computation).getField();
                    memoryAddress = nextMemoryAccessNeedsDecompress ? new AMD64Address(ReservedRegisters.singleton().getHeapBaseRegister(), computeRegister, Stride.fromLog2((int)compressEncoding.getShift()), field.getOffset()) : new AMD64Address(computeRegister, field.getOffset());
                } else if (computation instanceof ComputedIndirectCallTargetNode.FieldLoadIfZero) {
                    done = new Label();
                    VMError.guarantee(!nextMemoryAccessNeedsDecompress, "Comparison with compressed null value not implemented");
                    masm.cmpAndJcc(lastOperandSize, computeRegister, 0, AMD64Assembler.ConditionFlag.NotEqual, done, true);
                    SubstrateObjectConstant object = (SubstrateObjectConstant)((ComputedIndirectCallTargetNode.FieldLoadIfZero)computation).getObject();
                    field = (SharedField)((ComputedIndirectCallTargetNode.FieldLoadIfZero)computation).getField();
                    memoryAddress = new AMD64Address(ReservedRegisters.singleton().getHeapBaseRegister(), Register.None, Stride.S1, field.getOffset() + SubstrateAMD64Backend.addressDisplacement(object, this.constantReflection), SubstrateAMD64Backend.addressDisplacementAnnotation(object));
                } else {
                    throw VMError.shouldNotReachHere("Computation is not supported yet: " + computation.getClass().getTypeName());
                }
                switch (field.getStorageKind()) {
                    case Int: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.DWORD;
                        nextMemoryAccessNeedsDecompress = false;
                        break;
                    }
                    case Long: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.QWORD;
                        nextMemoryAccessNeedsDecompress = false;
                        break;
                    }
                    case Object: {
                        lastOperandSize = AMD64BaseAssembler.OperandSize.get((PlatformKind)this.lirKindTool.getNarrowOopKind().getPlatformKind());
                        nextMemoryAccessNeedsDecompress = true;
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere("Kind is not supported yet: " + field.getStorageKind());
                    }
                }
                AMD64Assembler.AMD64RMOp.MOV.emit((AMD64Assembler)masm, lastOperandSize, computeRegister, memoryAddress);
                if (done == null) continue;
                masm.bind(done);
            }
            VMError.guarantee(!nextMemoryAccessNeedsDecompress, "Final computed call target address is not a primitive value");
            AMD64Call.indirectCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (Register)computeRegister, (InvokeTarget)this.callTarget, (LIRFrameState)this.state);
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static class SubstrateAMD64IndirectCallOp
    extends AMD64Call.IndirectCallOp {
        public static final LIRInstructionClass<SubstrateAMD64IndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64IndirectCallOp.class);
        private final int newThreadStatus;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchorTemp;
        private final boolean destroysCallerSavedRegisters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;

        public SubstrateAMD64IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state, Value javaFrameAnchor, Value javaFrameAnchorTemp, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp) {
            super(TYPE, callTarget, result, parameters, temps, targetAddress, state);
            this.newThreadStatus = newThreadStatus;
            this.javaFrameAnchor = javaFrameAnchor;
            this.javaFrameAnchorTemp = javaFrameAnchorTemp;
            this.destroysCallerSavedRegisters = destroysCallerSavedRegisters;
            this.exceptionTemp = exceptionTemp;
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, targetAddress, javaFrameAnchor, javaFrameAnchorTemp}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            SubstrateAMD64Backend.maybeTransitionToNative(crb, masm, this.javaFrameAnchor, this.javaFrameAnchorTemp, this.state, this.newThreadStatus);
            AMD64Call.indirectCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (Register)ValueUtil.asRegister((Value)this.targetAddress), (InvokeTarget)this.callTarget, (LIRFrameState)this.state);
        }

        public boolean destroysCallerSavedRegisters() {
            return this.destroysCallerSavedRegisters;
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static class SubstrateAMD64DirectCallOp
    extends AMD64Call.DirectCallOp {
        public static final LIRInstructionClass<SubstrateAMD64DirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64DirectCallOp.class);
        private final int newThreadStatus;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchorTemp;
        private final boolean destroysCallerSavedRegisters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;

        public SubstrateAMD64DirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state, Value javaFrameAnchor, Value javaFrameAnchorTemp, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.newThreadStatus = newThreadStatus;
            this.javaFrameAnchor = javaFrameAnchor;
            this.javaFrameAnchorTemp = javaFrameAnchorTemp;
            this.destroysCallerSavedRegisters = destroysCallerSavedRegisters;
            this.exceptionTemp = exceptionTemp;
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, javaFrameAnchor, javaFrameAnchorTemp}));
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            SubstrateAMD64Backend.maybeTransitionToNative(crb, masm, this.javaFrameAnchor, this.javaFrameAnchorTemp, this.state, this.newThreadStatus);
            AMD64Call.directCall((CompilationResultBuilder)crb, (AMD64MacroAssembler)masm, (InvokeTarget)this.callTarget, null, (boolean)false, (LIRFrameState)this.state);
        }

        public boolean destroysCallerSavedRegisters() {
            return this.destroysCallerSavedRegisters;
        }
    }
}

