/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.amd64.AMD64NativeImagePatcher;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.util.VMError;
import java.util.function.Consumer;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton(value={PatchConsumerFactory.NativePatchConsumerFactory.class})
@Platforms(value={Platform.AMD64.class})
final class AMD64NativePatchConsumerFactory
extends PatchConsumerFactory.NativePatchConsumerFactory {
    AMD64NativePatchConsumerFactory() {
    }

    @Override
    public Consumer<Assembler.CodeAnnotation> newConsumer(final CompilationResult compilationResult) {
        return new Consumer<Assembler.CodeAnnotation>(){

            @Override
            public void accept(Assembler.CodeAnnotation annotation) {
                if (annotation instanceof AMD64BaseAssembler.OperandDataAnnotation) {
                    compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AMD64NativeImagePatcher((AMD64BaseAssembler.OperandDataAnnotation)annotation));
                } else if (annotation instanceof AMD64BaseAssembler.AddressDisplacementAnnotation) {
                    throw VMError.shouldNotReachHere("Image heap constants do not need patching in runtime compiled code");
                }
            }
        };
    }
}

