/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AbstractCollectionPolicy;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class ProportionateSpacesPolicy
extends AbstractCollectionPolicy {
    static final int MIN_HEAP_FREE_RATIO = 40;
    static final int MAX_HEAP_FREE_RATIO = 70;
    static final boolean SHRINK_HEAP_IN_STEPS = true;
    static final int SURVIVOR_RATIO = 8;
    static final int MAX_TENURING_THRESHOLD = 15;
    static final int TARGET_SURVIVOR_RATIO = 50;
    private int totalCollections;
    private boolean oldSizeExceededInPreviousCollection;
    private int shrinkFactor;

    ProportionateSpacesPolicy() {
        super(2, 15);
    }

    @Override
    public String getName() {
        return "proportionate";
    }

    @Override
    public boolean shouldCollectCompletely(boolean followingIncrementalCollection) {
        this.guaranteeSizeParametersInitialized();
        if (!followingIncrementalCollection && CollectionPolicy.shouldCollectYoungGenSeparately(false)) {
            return false;
        }
        return followingIncrementalCollection && this.oldSizeExceededInPreviousCollection;
    }

    @Override
    public void onCollectionBegin(boolean completeCollection, long requestingNanoTime) {
    }

    @Override
    public void onCollectionEnd(boolean completeCollection, GCCause cause) {
        UnsignedWord oldLive = GCImpl.getGCImpl().getAccounting().getOldGenerationAfterChunkBytes();
        this.oldSizeExceededInPreviousCollection = oldLive.aboveThan(this.oldSize);
        boolean resizeOldOnlyForPromotions = !completeCollection;
        this.computeNewOldGenSize(resizeOldOnlyForPromotions);
        this.computeNewYoungGenSize();
        this.adjustDesiredTenuringThreshold();
        ++this.totalCollections;
    }

    private void adjustDesiredTenuringThreshold() {
        Space space;
        int i;
        UnsignedWord desiredSurvivorSize = UnsignedUtils.fromDouble(UnsignedUtils.toDouble(this.survivorSize) * 50.0 / 100.0);
        YoungGeneration youngGen = HeapImpl.getHeapImpl().getYoungGeneration();
        UnsignedWord total = (UnsignedWord)WordFactory.zero();
        for (i = 0; i < HeapParameters.getMaxSurvivorSpaces() && !(total = total.add((space = youngGen.getSurvivorFromSpaceAt(0)).getChunkBytes())).aboveThan(desiredSurvivorSize); ++i) {
            ++i;
        }
        this.tenuringThreshold = Math.min(i + 1, 15);
    }

    private void computeNewOldGenSize(boolean resizeOnlyForPromotions) {
        UnsignedWord capacityAtPrologue = this.oldSize;
        UnsignedWord usedAfterGc = GCImpl.getGCImpl().getAccounting().getOldGenerationAfterChunkBytes();
        if (this.oldSize.belowThan(usedAfterGc)) {
            this.oldSize = usedAfterGc;
        }
        if (resizeOnlyForPromotions) {
            return;
        }
        int currentShrinkFactor = this.shrinkFactor;
        this.shrinkFactor = 0;
        double minimumFreePercentage = 0.4;
        double maximumUsedPercentage = 1.0 - minimumFreePercentage;
        UnsignedWord minimumDesiredCapacity = UnsignedUtils.fromDouble(UnsignedUtils.toDouble(usedAfterGc) / maximumUsedPercentage);
        if (this.oldSize.belowThan(minimumDesiredCapacity = UnsignedUtils.max(minimumDesiredCapacity, this.sizes.initialOldSize()))) {
            this.oldSize = ProportionateSpacesPolicy.alignUp(minimumDesiredCapacity);
            return;
        }
        UnsignedWord maxShrinkBytes = this.oldSize.subtract(minimumDesiredCapacity);
        UnsignedWord shrinkBytes = (UnsignedWord)WordFactory.zero();
        double maximumFreePercentage = 0.7;
        double minimumUsedPercentage = 1.0 - maximumFreePercentage;
        UnsignedWord maximumDesiredCapacity = UnsignedUtils.fromDouble(UnsignedUtils.toDouble(usedAfterGc) / minimumUsedPercentage);
        maximumDesiredCapacity = UnsignedUtils.max(maximumDesiredCapacity, this.sizes.initialOldSize());
        assert (minimumDesiredCapacity.belowOrEqual(maximumDesiredCapacity));
        if (this.oldSize.aboveThan(maximumDesiredCapacity)) {
            shrinkBytes = this.oldSize.subtract(maximumDesiredCapacity);
            shrinkBytes = shrinkBytes.unsignedDivide(100).multiply(currentShrinkFactor);
            this.shrinkFactor = currentShrinkFactor == 0 ? 10 : Math.min(currentShrinkFactor * 4, 100);
            assert (shrinkBytes.belowOrEqual(maxShrinkBytes));
        }
        if (this.oldSize.aboveThan(capacityAtPrologue)) {
            UnsignedWord expansionForPromotion = this.oldSize.subtract(capacityAtPrologue);
            expansionForPromotion = UnsignedUtils.min(expansionForPromotion, maxShrinkBytes);
            shrinkBytes = UnsignedUtils.max(shrinkBytes, expansionForPromotion);
        }
        if (shrinkBytes.aboveThan(40)) {
            this.oldSize = this.oldSize.subtract(shrinkBytes);
        }
    }

    private void computeNewYoungGenSize() {
        UnsignedWord desiredNewSize = this.oldSize.unsignedDivide(2);
        desiredNewSize = UnsignedUtils.clamp(desiredNewSize, this.sizes.initialYoungSize(), this.sizes.maxYoungSize);
        this.survivorSize = ProportionateSpacesPolicy.minSpaceSize(ProportionateSpacesPolicy.alignDown(desiredNewSize.unsignedDivide(8)));
        UnsignedWord desiredEdenSize = (UnsignedWord)WordFactory.zero();
        if (desiredNewSize.aboveThan(this.survivorSize.multiply(2))) {
            desiredEdenSize = desiredNewSize.subtract(this.survivorSize.multiply(2));
        }
        this.edenSize = ProportionateSpacesPolicy.minSpaceSize(ProportionateSpacesPolicy.alignDown(desiredEdenSize));
        assert (this.edenSize.aboveThan(0) && this.survivorSize.belowOrEqual(this.edenSize));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected long gcCount() {
        return this.totalCollections;
    }
}

