/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class GreyToBlackObjectVisitor
implements ObjectVisitor {
    private final GreyToBlackObjRefVisitor objRefVisitor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GreyToBlackObjectVisitor(GreyToBlackObjRefVisitor greyToBlackObjRefVisitor) {
        this.objRefVisitor = greyToBlackObjRefVisitor;
    }

    @Override
    @NeverInline(value="Non-performance critical version")
    public boolean visitObject(Object o) {
        throw VMError.shouldNotReachHere("For performance reasons, this should not be called.");
    }

    @Override
    @AlwaysInline(value="GC performance")
    public boolean visitObjectInline(Object o) {
        ReferenceObjectProcessing.discoverIfReference(o, this.objRefVisitor);
        InteriorObjRefWalker.walkObjectInline(o, this.objRefVisitor);
        return true;
    }
}

