/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import com.oracle.graal.reachability.ReachabilityAnalysisType;
import com.oracle.graal.reachability.ReachabilityMethodProcessingHandler;
import java.lang.reflect.Executable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;

public abstract class ReachabilityAnalysisEngine
extends AbstractAnalysisEngine {
    private final Timer reachabilityTimer;
    private final Set<AnalysisType> allInstantiatedTypes;
    private final ReachabilityMethodProcessingHandler reachabilityMethodProcessingHandler;

    public ReachabilityAnalysisEngine(OptionValues options, AnalysisUniverse universe, HostedProviders providers, HostVM hostVM, ForkJoinPool executorService, Runnable heartbeatCallback, UnsupportedFeatures unsupportedFeatures, TimerCollection timerCollection, ReachabilityMethodProcessingHandler reachabilityMethodProcessingHandler) {
        super(options, universe, providers, hostVM, executorService, heartbeatCallback, unsupportedFeatures, timerCollection);
        this.executor.init(this.getTiming());
        this.reachabilityTimer = timerCollection.createTimer("(reachability)");
        ReachabilityAnalysisType objectType = (ReachabilityAnalysisType)this.metaAccess.lookupJavaType(Object.class);
        this.allInstantiatedTypes = Collections.unmodifiableSet(objectType.getInstantiatedSubtypes());
        this.reachabilityMethodProcessingHandler = reachabilityMethodProcessingHandler;
    }

    protected CompletionExecutor.Timing getTiming() {
        return null;
    }

    public AnalysisType addRootClass(Class<?> clazz, boolean addFields, boolean addArrayClass) {
        AnalysisType type = this.metaAccess.lookupJavaType(clazz);
        type.registerAsReachable();
        return this.addRootClass(type, addFields, addArrayClass);
    }

    public AnalysisMethod addRootMethod(Executable method, boolean invokeSpecial) {
        return this.addRootMethod(this.metaAccess.lookupJavaMethod(method), invokeSpecial);
    }

    public AnalysisType addRootClass(AnalysisType type, boolean addFields, boolean addArrayClass) {
        try (Indent indent = this.debug.logAndIndent("add root class %s", (Object)type.getName());){
            for (AnalysisField field : type.getInstanceFields(false)) {
                if (!addFields) continue;
                field.registerAsAccessed();
            }
            this.markTypeReachable(type);
            if (type.getSuperclass() != null) {
                this.addRootClass(type.getSuperclass(), addFields, addArrayClass);
            }
            if (addArrayClass) {
                this.addRootClass(type.getArrayClass(), false, false);
            }
        }
        return type;
    }

    public AnalysisType addRootField(Class<?> clazz, String fieldName) {
        AnalysisType type = this.addRootClass(clazz, false, false);
        for (AnalysisField field : type.getInstanceFields(true)) {
            if (!field.getName().equals(fieldName)) continue;
            try (Indent indent = this.debug.logAndIndent("add root field %s in class %s", (Object)fieldName, (Object)clazz.getName());){
                field.registerAsAccessed();
            }
            return field.getType();
        }
        throw AnalysisError.userError((String)("Field not found: " + fieldName));
    }

    public AnalysisMethod addRootMethod(AnalysisMethod m, boolean invokeSpecial) {
        ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)m;
        if (m.isStatic()) {
            if (!method.registerAsDirectRootMethod()) {
                return method;
            }
            this.markMethodImplementationInvoked(method);
        } else if (invokeSpecial) {
            AnalysisError.guarantee((!method.isAbstract() ? 1 : 0) != 0, (String)"Abstract methods cannot be registered as special invoke entry point.", (Object[])new Object[0]);
            if (!method.registerAsDirectRootMethod()) {
                return method;
            }
            this.markMethodImplementationInvoked(method);
        } else {
            if (!method.registerAsVirtualRootMethod()) {
                return method;
            }
            this.markMethodInvoked(method);
        }
        return method;
    }

    public void markMethodImplementationInvoked(ReachabilityAnalysisMethod method) {
        if (!method.getWrapped().getDeclaringClass().isLinked()) {
            return;
        }
        if (!method.registerAsImplementationInvoked()) {
            return;
        }
        this.schedule(() -> this.onMethodImplementationInvoked(method));
    }

    private void onMethodImplementationInvoked(ReachabilityAnalysisMethod method) {
        try {
            this.reachabilityMethodProcessingHandler.onMethodReachable(this, method);
        }
        catch (Throwable ex) {
            this.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), (AnalysisMethod)method, ex.getLocalizedMessage(), null, ex);
        }
    }

    public boolean markTypeInHeap(AnalysisType t) {
        ReachabilityAnalysisType type = (ReachabilityAnalysisType)t;
        if (!type.registerAsInHeap()) {
            return false;
        }
        if (type.registerAsInstantiated()) {
            this.schedule(() -> this.onTypeInstantiated(type));
        }
        return true;
    }

    public boolean markTypeInstantiated(AnalysisType t) {
        ReachabilityAnalysisType type = (ReachabilityAnalysisType)t;
        if (!type.registerAsAllocated(null)) {
            return false;
        }
        if (type.registerAsInstantiated()) {
            this.schedule(() -> this.onTypeInstantiated(type));
        }
        return true;
    }

    public void handleEmbeddedConstant(ReachabilityAnalysisMethod method, JavaConstant constant) {
        if (constant.getJavaKind() == JavaKind.Object && constant.isNonNull() && this.scanningPolicy().trackConstant((BigBang)this, constant)) {
            BytecodePosition position = new BytecodePosition(null, (ResolvedJavaMethod)method, 0);
            this.getUniverse().registerEmbeddedRoot(constant, position);
            Object obj = this.getSnippetReflectionProvider().asObject(Object.class, constant);
            AnalysisType type = this.getMetaAccess().lookupJavaType(obj.getClass());
            this.markTypeInHeap(type);
        }
    }

    private void onMethodInvoked(ReachabilityAnalysisMethod method) {
        ReachabilityAnalysisType clazz = method.getDeclaringClass();
        if (method.isStatic()) {
            this.markMethodImplementationInvoked(method);
            return;
        }
        Set<ReachabilityAnalysisType> instantiatedSubtypes = clazz.getInstantiatedSubtypes();
        for (ReachabilityAnalysisType subtype : instantiatedSubtypes) {
            ReachabilityAnalysisMethod resolvedMethod = subtype.resolveConcreteMethod((ResolvedJavaMethod)method, (ResolvedJavaType)clazz);
            if (resolvedMethod == null) continue;
            this.markMethodImplementationInvoked(resolvedMethod);
        }
    }

    private void onTypeInstantiated(ReachabilityAnalysisType type) {
        type.forAllSuperTypes(current -> {
            Set<ReachabilityAnalysisMethod> invokedMethods = ((ReachabilityAnalysisType)((Object)current)).getInvokedVirtualMethods();
            for (ReachabilityAnalysisMethod curr : invokedMethods) {
                ReachabilityAnalysisMethod method = type.resolveConcreteMethod((ResolvedJavaMethod)curr, (ResolvedJavaType)current);
                if (method == null) continue;
                this.markMethodImplementationInvoked(method);
            }
        });
    }

    public void markMethodInvoked(ReachabilityAnalysisMethod method) {
        if (!method.registerAsInvoked()) {
            return;
        }
        this.schedule(() -> this.onMethodInvoked(method));
    }

    public boolean finish() throws InterruptedException {
        this.universe.setAnalysisDataValid(false);
        this.runReachability();
        assert (this.executor.getPostedOperations() == 0L);
        this.universe.setAnalysisDataValid(true);
        return true;
    }

    private void runReachability() throws InterruptedException {
        try (Timer.StopTimer t = this.reachabilityTimer.start();){
            this.executor.start();
            this.executor.complete();
            this.executor.shutdown();
            this.executor.init(this.getTiming());
        }
    }

    public void afterAnalysis() {
        this.computeCallers();
    }

    private void computeCallers() {
        HashSet<ReachabilityAnalysisMethod> seen = new HashSet<ReachabilityAnalysisMethod>();
        ArrayDeque<ReachabilityAnalysisMethod> queue = new ArrayDeque<ReachabilityAnalysisMethod>();
        for (AnalysisMethod m : this.universe.getMethods()) {
            ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)m;
            if ((method.isDirectRootMethod() || method.isEntryPoint()) && seen.add(method)) {
                queue.add(method);
            }
            if (!method.isVirtualRootMethod()) continue;
            for (ReachabilityAnalysisType subtype : method.getDeclaringClass().getInstantiatedSubtypes()) {
                ReachabilityAnalysisMethod resolved = subtype.resolveConcreteMethod((ResolvedJavaMethod)method, (ResolvedJavaType)subtype);
                if (resolved == null || !seen.add(resolved)) continue;
                queue.add(resolved);
            }
        }
        while (!queue.isEmpty()) {
            ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)((Object)queue.removeFirst());
            for (InvokeInfo invoke : method.getInvokes()) {
                for (AnalysisMethod c : invoke.getCallees()) {
                    ReachabilityAnalysisMethod callee = (ReachabilityAnalysisMethod)c;
                    callee.addCaller(invoke.getPosition());
                    if (!seen.add(callee)) continue;
                    callee.setReason(invoke.getPosition());
                    queue.add(callee);
                }
            }
        }
    }

    public void forceUnsafeUpdate(AnalysisField field) {
    }

    public void registerAsJNIAccessed(AnalysisField field, boolean writable) {
    }

    public Iterable<AnalysisType> getAllSynchronizedTypes() {
        return this.getAllInstantiatedTypes();
    }

    public Iterable<AnalysisType> getAllInstantiatedTypes() {
        return this.allInstantiatedTypes;
    }

    public void processGraph(StructuredGraph graph) {
        this.reachabilityMethodProcessingHandler.processGraph(this, graph);
    }
}

