/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.thread.VMThreadMTFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public final class KnownOffsetsFeature
implements InternalFeature {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return Arrays.asList(VMThreadMTFeature.class);
        }
        return Collections.emptyList();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(KnownOffsets.class, (Object)new KnownOffsets());
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        HybridLayout<DynamicHub> hubLayout = new HybridLayout<DynamicHub>(DynamicHub.class, ConfigurationValues.getObjectLayout(), access.getMetaAccess());
        int vtableBaseOffset = hubLayout.getArrayBaseOffset();
        int vtableEntrySize = ConfigurationValues.getObjectLayout().sizeInBytes(hubLayout.getArrayElementStorageKind());
        int typeIDSlotsOffset = HybridLayout.getTypeIDSlotsFieldOffset(ConfigurationValues.getObjectLayout());
        int componentHubOffset = KnownOffsetsFeature.findFieldOffset(access, DynamicHub.class, "componentType");
        int javaFrameAnchorLastSPOffset = KnownOffsetsFeature.findStructOffset(access, JavaFrameAnchor.class, "getLastJavaSP");
        int javaFrameAnchorLastIPOffset = KnownOffsetsFeature.findStructOffset(access, JavaFrameAnchor.class, "getLastJavaIP");
        int vmThreadStatusOffset = -1;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            vmThreadStatusOffset = ((VMThreadMTFeature)ImageSingletons.lookup(VMThreadMTFeature.class)).offsetOf(VMThreads.StatusSupport.statusTL);
        }
        int imageCodeInfoCodeStartOffset = KnownOffsetsFeature.findFieldOffset(access, ImageCodeInfo.class, "codeStart");
        KnownOffsets.singleton().setLazyState(vtableBaseOffset, vtableEntrySize, typeIDSlotsOffset, componentHubOffset, javaFrameAnchorLastSPOffset, javaFrameAnchorLastIPOffset, vmThreadStatusOffset, imageCodeInfoCodeStartOffset);
    }

    private static int findFieldOffset(FeatureImpl.BeforeCompilationAccessImpl access, Class<?> clazz, String fieldName) {
        return access.getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(clazz, (String)fieldName)).getLocation();
    }

    private static int findStructOffset(FeatureImpl.BeforeCompilationAccessImpl access, Class<?> clazz, String accessorName) {
        AccessorInfo accessorInfo = (AccessorInfo)access.getNativeLibraries().findElementInfo((AnnotatedElement)((Object)access.getMetaAccess().lookupJavaMethod(ReflectionUtil.lookupMethod(clazz, (String)accessorName, (Class[])new Class[0]))));
        StructFieldInfo structFieldInfo = (StructFieldInfo)accessorInfo.getParent();
        return structFieldInfo.getOffsetInfo().getProperty();
    }
}

