/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;

public class NativeMethodSubstitutionProcessor
extends SubstitutionProcessor {
    private final SubstitutionProcessor processor;
    private final Replacements replacements;

    public NativeMethodSubstitutionProcessor(SubstitutionProcessor processor, Replacements replacements) {
        this.processor = processor;
        this.replacements = replacements;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        boolean isHandledByPlugin;
        if (!method.isNative()) {
            return method;
        }
        if (method.getCodeSize() != 0 || method instanceof GraphProvider) {
            assert (!(method instanceof WrappedJavaMethod)) : "Must not see AnalysisMethod or HostedMethod here";
            return method;
        }
        assert (!GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, CFunction.class)) : "CFunction must have been handled by another SubstitutionProcessor";
        if (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, Node.NodeIntrinsic.class) || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, Word.Operation.class) || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, CConstant.class)) {
            return method;
        }
        boolean bl = isHandledByPlugin = this.replacements.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation(method, HostedOptionValues.singleton()) != null;
        if (isHandledByPlugin) {
            return method;
        }
        return this.processor.lookup(method);
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        return this.processor.resolve(method);
    }
}

