/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.SubstrateOptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.ValueProxy;

public class InliningUtilities {
    public static boolean isTrivialMethod(StructuredGraph graph) {
        int numInvokes = 0;
        int numOthers = 0;
        for (Node n : graph.getNodes()) {
            if (n instanceof StartNode || n instanceof ParameterNode || n instanceof FullInfopointNode || n instanceof ValueProxy || n instanceof ValueAnchorNode || n instanceof FrameState) continue;
            if (n instanceof MethodCallTargetNode) {
                ++numInvokes;
            } else {
                ++numOthers;
            }
            if (InliningUtilities.shouldBeTrivial(numInvokes, numOthers, graph)) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldBeTrivial(int numInvokes, int numOthers, StructuredGraph graph) {
        if (numInvokes == 0) {
            return numOthers <= (Integer)SubstrateOptions.MaxNodesInTrivialLeafMethod.getValue(graph.getOptions());
        }
        if (numInvokes <= (Integer)SubstrateOptions.MaxInvokesInTrivialMethod.getValue(graph.getOptions())) {
            return numOthers <= (Integer)SubstrateOptions.MaxNodesInTrivialMethod.getValue(graph.getOptions());
        }
        return false;
    }

    public static int recursionDepth(Invoke invoke, ResolvedJavaMethod callee) {
        FrameState state = invoke.stateAfter();
        int result = 0;
        do {
            if (!state.getMethod().equals(callee)) continue;
            ++result;
        } while ((state = state.outerFrameState()) != null);
        return result;
    }
}

