/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Target_java_io_FilterInputStream;
import com.oracle.svm.core.Target_sun_security_provider_NativePRNG;
import com.oracle.svm.core.Target_sun_security_provider_NativePRNG_RandomIO;
import com.oracle.svm.core.jdk.RuntimeSupport;
import java.io.Closeable;
import java.io.FilterInputStream;

final class NativeSecureRandomFilesCloserTearDownHook
implements RuntimeSupport.Hook {
    NativeSecureRandomFilesCloserTearDownHook() {
    }

    @Override
    public void execute(boolean isFirstIsolate) {
        Target_sun_security_provider_NativePRNG_RandomIO instance = Target_sun_security_provider_NativePRNG.INSTANCE;
        if (instance != null) {
            NativeSecureRandomFilesCloserTearDownHook.close(instance.nextIn);
            NativeSecureRandomFilesCloserTearDownHook.close(instance.seedIn);
            NativeSecureRandomFilesCloserTearDownHook.close(instance.seedOut);
        }
    }

    private static void close(Closeable stream) {
        if (stream != null) {
            Closeable c = stream;
            if (stream instanceof FilterInputStream) {
                Target_java_io_FilterInputStream outer = SubstrateUtil.cast(c, Target_java_io_FilterInputStream.class);
                c = outer.in;
            }
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

