/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@TargetClass(className="com.oracle.truffle.api.nodes.NodeClassImpl", innerClass={"NodeFieldData"}, onlyWith={TruffleBaseFeature.IsEnabled.class})
final class Target_com_oracle_truffle_api_nodes_NodeClassImpl_NodeFieldData {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OffsetComputer.class)
    private long offset;

    Target_com_oracle_truffle_api_nodes_NodeClassImpl_NodeFieldData() {
    }

    private static class OffsetComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        private OffsetComputer() {
        }

        @Override
        public RecomputeFieldValue.ValueAvailability valueAvailability() {
            return RecomputeFieldValue.ValueAvailability.AfterAnalysis;
        }

        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Class declaringClass = (Class)ReflectionUtil.readField(receiver.getClass(), (String)"declaringClass", (Object)receiver);
            String name = (String)ReflectionUtil.readField(receiver.getClass(), (String)"name", (Object)receiver);
            Field field = ReflectionUtil.lookupField((Class)declaringClass, (String)name);
            return (long)metaAccess.lookupJavaField(field).getOffset();
        }

        @Override
        public Class<?>[] types() {
            return new Class[]{Long.TYPE};
        }
    }
}

