/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.graal.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.reflect.ReflectionAccessorHolder;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.reflect.SubstrateConstructorAccessor;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtracter;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.meta.InternalRuntimeReflectionSupport;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.reflect.hosted.ReflectionDataBuilder;
import com.oracle.svm.reflect.hosted.ReflectionExpandSignatureMethod;
import com.oracle.svm.reflect.hosted.SignatureKey;
import com.oracle.svm.util.AnnotationExtracter;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@AutomaticFeature
public class ReflectionFeature
implements InternalFeature {
    private AnnotationSubstitutionProcessor annotationSubstitutions;
    private ReflectionDataBuilder reflectionData;
    private ImageClassLoader loader;
    private AnalysisUniverse aUniverse;
    private int loadedConfigurations;
    final Map<Executable, SubstrateAccessor> accessors = new ConcurrentHashMap<Executable, SubstrateAccessor>();
    private final Map<SignatureKey, MethodPointer> expandSignatureMethods = new ConcurrentHashMap<SignatureKey, MethodPointer>();
    private static final Method invokePrototype = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"invokePrototype", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    private static final Method methodHandleInvokeErrorMethod = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"methodHandleInvokeError", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    private static final Method newInstanceErrorMethod = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"newInstanceError", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    FeatureImpl.BeforeAnalysisAccessImpl analysisAccess;

    SubstrateAccessor getOrCreateAccessor(Executable member) {
        SubstrateAccessor existing = this.accessors.get(member);
        if (existing != null) {
            return existing;
        }
        if (this.analysisAccess == null) {
            throw VMError.shouldNotReachHere("New Method or Constructor found as reachable after static analysis: " + member);
        }
        return this.accessors.computeIfAbsent(member, this::createAccessor);
    }

    private SubstrateAccessor createAccessor(Executable member) {
        MethodPointer expandSignature;
        MethodPointer directTarget = null;
        DynamicHub initializeBeforeInvoke = null;
        if (member instanceof Method) {
            MethodPointer expandSignature2;
            int vtableOffset = -1;
            Class<?> receiverType = null;
            if (member.getDeclaringClass() == MethodHandle.class && (member.getName().equals("invoke") || member.getName().equals("invokeExact"))) {
                expandSignature2 = this.register((ResolvedJavaMethod)this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)methodHandleInvokeErrorMethod));
            } else {
                expandSignature2 = this.createExpandSignatureMethod(member);
                AnalysisMethod targetMethod = this.analysisAccess.getMetaAccess().lookupJavaMethod(member);
                if (!targetMethod.isAbstract()) {
                    directTarget = this.register((ResolvedJavaMethod)targetMethod);
                }
                if (!targetMethod.canBeStaticallyBound()) {
                    vtableOffset = -559087615;
                    this.analysisAccess.registerAsRoot(targetMethod, false);
                }
                VMError.guarantee(directTarget != null || vtableOffset != -1, "Must have either a directTarget or a vtableOffset");
                if (!targetMethod.isStatic()) {
                    receiverType = member.getDeclaringClass();
                }
                if (targetMethod.isStatic() && !targetMethod.getDeclaringClass().isInitialized()) {
                    initializeBeforeInvoke = this.analysisAccess.getHostVM().dynamicHub((ResolvedJavaType)targetMethod.getDeclaringClass());
                }
            }
            return new SubstrateMethodAccessor(member, receiverType, expandSignature2, directTarget, vtableOffset, initializeBeforeInvoke);
        }
        Class<?> holder = member.getDeclaringClass();
        if (Modifier.isAbstract(holder.getModifiers()) || holder.isInterface() || holder.isPrimitive() || holder.isArray()) {
            expandSignature = this.register((ResolvedJavaMethod)this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)newInstanceErrorMethod));
        } else {
            expandSignature = this.createExpandSignatureMethod(member);
            AnalysisMethod constructor = this.analysisAccess.getMetaAccess().lookupJavaMethod(member);
            AnalysisMethod factoryMethod = (AnalysisMethod)FactoryMethodSupport.singleton().lookup((UniverseMetaAccess)this.analysisAccess.getMetaAccess(), (ResolvedJavaMethod)constructor, false);
            directTarget = this.register((ResolvedJavaMethod)factoryMethod);
            if (!constructor.getDeclaringClass().isInitialized()) {
                initializeBeforeInvoke = this.analysisAccess.getHostVM().dynamicHub((ResolvedJavaType)constructor.getDeclaringClass());
            }
        }
        return new SubstrateConstructorAccessor(member, expandSignature, directTarget, initializeBeforeInvoke);
    }

    private MethodPointer createExpandSignatureMethod(Executable member) {
        return this.expandSignatureMethods.computeIfAbsent(new SignatureKey(member), signatureKey -> {
            ResolvedJavaMethod prototype = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)invokePrototype).getWrapped();
            return this.register(new ReflectionExpandSignatureMethod(signatureKey.uniqueShortName(), prototype, signatureKey.isStatic, signatureKey.argTypes, signatureKey.returnKind));
        });
    }

    private MethodPointer register(ResolvedJavaMethod method) {
        AnalysisMethod aMethod = method instanceof AnalysisMethod ? (AnalysisMethod)method : this.analysisAccess.getUniverse().lookup((JavaMethod)method);
        this.analysisAccess.registerAsRoot(aMethod, true);
        return new MethodPointer((ResolvedJavaMethod)aMethod);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"jdk.internal.reflect"});
        this.reflectionData = new ReflectionDataBuilder((SubstrateAnnotationExtracter)ImageSingletons.lookup(AnnotationExtracter.class));
        ImageSingletons.add(RuntimeReflectionSupport.class, (Object)this.reflectionData);
        ImageSingletons.add(InternalRuntimeReflectionSupport.class, (Object)this.reflectionData);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.aUniverse = access.getUniverse();
        ReflectionConfigurationParser<ConditionalElement<Class<?>>> parser = ConfigurationParserUtils.create((ReflectionRegistry)this.reflectionData, access.getImageClassLoader());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, access.getImageClassLoader(), "reflection", ConfigurationFiles.Options.ReflectionConfigurationFiles, ConfigurationFiles.Options.ReflectionConfigurationResources, ConfigurationFile.REFLECTION.getFileName());
        this.loader = access.getImageClassLoader();
        this.annotationSubstitutions = ((Inflation)access.getBigBang()).getAnnotationSubstitutionProcessor();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.analysisAccess = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        this.reflectionData.flushConditionalConfiguration(access);
        RuntimeReflection.register((Executable[])Object[].class.getMethods());
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.reflectionData.flushConditionalConfiguration(access);
        this.reflectionData.duringAnalysis(access);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.analysisAccess = null;
        this.reflectionData.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest reflectionFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).reflectionFallback;
        if (reflectionFallback != null && this.loadedConfigurations == 0) {
            throw reflectionFallback;
        }
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        ReflectionPlugins.registerInvocationPlugins(this.loader, snippetReflection, this.annotationSubstitutions, plugins.getClassInitializationPlugin(), plugins.getInvocationPlugins(), this.aUniverse, reason);
    }
}

