/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.functions;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.FunctionPointerLogHandler;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.Utf8;
import com.oracle.svm.jni.JNIJavaVMList;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.JNIThreadLocalEnvironment;
import com.oracle.svm.jni.JNIThreadOwnedMonitors;
import com.oracle.svm.jni.functions.JNIFunctionTables;
import com.oracle.svm.jni.functions.JNIFunctions;
import com.oracle.svm.jni.nativeapi.JNIEnvironmentPointer;
import com.oracle.svm.jni.nativeapi.JNIErrors;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNIJavaVMAttachArgs;
import com.oracle.svm.jni.nativeapi.JNIJavaVMInitArgs;
import com.oracle.svm.jni.nativeapi.JNIJavaVMOption;
import com.oracle.svm.jni.nativeapi.JNIJavaVMPointer;
import com.oracle.svm.jni.nativeapi.JNIVersion;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class JNIInvocationInterface {
    JNIInvocationInterface() {
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, exceptionHandler=JNIFunctions.Support.JNIExceptionHandlerDetachAndReturnJniErr.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=JNIFunctions.Support.JNIJavaVMEnterAttachThreadManualJavaThreadPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="Permits omitting an epilogue so we can detach in the exception handler.", calleeMustBe=false)
    static int AttachCurrentThread(JNIJavaVM vm, JNIEnvironmentPointer penv, JNIJavaVMAttachArgs args) {
        Support.attachCurrentThread(vm, penv, args, false);
        CEntryPointActions.leave();
        return JNIErrors.JNI_OK();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, exceptionHandler=JNIFunctions.Support.JNIExceptionHandlerDetachAndReturnJniErr.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=JNIFunctions.Support.JNIJavaVMEnterAttachThreadManualJavaThreadPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="Permits omitting an epilogue so we can detach in the exception handler.", calleeMustBe=false)
    static int AttachCurrentThreadAsDaemon(JNIJavaVM vm, JNIEnvironmentPointer penv, JNIJavaVMAttachArgs args) {
        Support.attachCurrentThread(vm, penv, args, true);
        CEntryPointActions.leave();
        return JNIErrors.JNI_OK();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=JNIFunctions.Support.JNIJavaVMEnterAttachThreadEnsureJavaThreadPrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class)
    static int DetachCurrentThread(JNIJavaVM vm) {
        int result = JNIErrors.JNI_OK();
        if (!vm.equal((ComparableWord)JNIFunctionTables.singleton().getGlobalJavaVM())) {
            result = JNIErrors.JNI_ERR();
        }
        Support.releaseCurrentThreadOwnedMonitors();
        return result;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=JNIFunctions.Support.JNIJavaVMEnterAttachThreadEnsureJavaThreadPrologue.class, epilogue=CEntryPointSetup.LeaveTearDownIsolateEpilogue.class)
    static int DestroyJavaVM(JNIJavaVM vm) {
        PlatformThreads.singleton().joinAllNonDaemons();
        return JNIErrors.JNI_OK();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=Support.JNIGetEnvPrologue.class)
    static int GetEnv(JNIJavaVM vm, WordPointer env, int version) {
        env.write((WordBase)JNIThreadLocalEnvironment.getAddress());
        return JNIErrors.JNI_OK();
    }

    static class Support {
        private static final CGlobalData<CCharPointer> JAVA_VM_ID_OPTION = CGlobalDataFactory.createCString("_javavm_id");

        Support() {
        }

        static void attachCurrentThread(JNIJavaVM vm, JNIEnvironmentPointer penv, JNIJavaVMAttachArgs args, boolean asDaemon) {
            if (penv.isNull() || vm.notEqual((ComparableWord)JNIFunctionTables.singleton().getGlobalJavaVM())) {
                throw ImplicitExceptions.CACHED_ILLEGAL_ARGUMENT_EXCEPTION;
            }
            penv.write(JNIThreadLocalEnvironment.getAddress());
            ThreadGroup group = null;
            String name = null;
            if (args.isNonNull() && args.getVersion() != JNIVersion.JNI_VERSION_1_1()) {
                group = (ThreadGroup)JNIObjectHandles.getObject(args.getGroup());
                name = Utf8.utf8ToString(args.getName());
            }
            PlatformThreads.ensureCurrentAssigned(name, group, asDaemon);
        }

        static void releaseCurrentThreadOwnedMonitors() {
            JNIThreadOwnedMonitors.forEach((obj, depth) -> {
                for (int i = 0; i < depth; ++i) {
                    MonitorSupport.singleton().monitorExit(obj);
                }
                assert (!Thread.holdsLock(obj));
            });
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static boolean isSpecialVMOption(CCharPointer str) {
            return FunctionPointerLogHandler.isJniVMOption(str) || Support.isJavaVmId(str);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static boolean isJavaVmId(CCharPointer str) {
            return LibC.strcmp(str, JAVA_VM_ID_OPTION.get()) == 0;
        }

        @Uninterruptible(reason="Called after creating the isolate, so there is no need to be uninterruptible.", calleeMustBe=false)
        static int finishInitialization(JNIJavaVMPointer vmBuf, JNIEnvironmentPointer penv, JNIJavaVMInitArgs vmArgs, boolean hasSpecialVmOptions) {
            return Support.finishInitialization0(vmBuf, penv, vmArgs, hasSpecialVmOptions);
        }

        private static int finishInitialization0(JNIJavaVMPointer vmBuf, JNIEnvironmentPointer penv, JNIJavaVMInitArgs vmArgs, boolean hasSpecialVmOptions) {
            WordPointer javaVmIdPointer = (WordPointer)WordFactory.nullPointer();
            if (hasSpecialVmOptions) {
                javaVmIdPointer = Support.parseVMOptions(vmArgs);
            }
            JNIJavaVM javaVm = JNIFunctionTables.singleton().getGlobalJavaVM();
            JNIJavaVMList.addJavaVM(javaVm);
            if (javaVmIdPointer.isNonNull()) {
                long javaVmId = IsolateUtil.getIsolateID();
                javaVmIdPointer.write((WordBase)WordFactory.pointer((long)javaVmId));
            }
            RuntimeSupport.getRuntimeSupport().addTearDownHook(isFirstIsolate -> JNIJavaVMList.removeJavaVM(javaVm));
            vmBuf.write(javaVm);
            penv.write(JNIThreadLocalEnvironment.getAddress());
            return JNIErrors.JNI_OK();
        }

        static WordPointer parseVMOptions(JNIJavaVMInitArgs vmArgs) {
            WordPointer javaVmIdPointer = (WordPointer)WordFactory.nullPointer();
            Pointer p = (Pointer)vmArgs.getOptions();
            int vmArgc = vmArgs.getNOptions();
            for (int i = 0; i < vmArgc; ++i) {
                JNIJavaVMOption option = (JNIJavaVMOption)p.add(i * SizeOf.get(JNIJavaVMOption.class));
                CCharPointer optionString = option.getOptionString();
                if (Support.isJavaVmId(optionString)) {
                    javaVmIdPointer = option.getExtraInfo();
                    continue;
                }
                FunctionPointerLogHandler.parseJniVMOption(optionString, option.getExtraInfo());
            }
            FunctionPointerLogHandler.afterParsingJniVMOptions();
            return javaVmIdPointer;
        }

        static class JNIGetEnvPrologue
        implements CEntryPointOptions.Prologue {
            JNIGetEnvPrologue() {
            }

            @Uninterruptible(reason="prologue")
            static int enter(JNIJavaVM vm, WordPointer env, int version) {
                if (vm.isNull() || env.isNull()) {
                    return JNIErrors.JNI_ERR();
                }
                if (!JNIVersion.isSupported(version)) {
                    env.write((WordBase)WordFactory.nullPointer());
                    return JNIErrors.JNI_EVERSION();
                }
                if (!CEntryPointActions.isCurrentThreadAttachedTo(vm.getFunctions().getIsolate())) {
                    env.write((WordBase)WordFactory.nullPointer());
                    return JNIErrors.JNI_EDETACHED();
                }
                if (CEntryPointActions.enterIsolate(vm.getFunctions().getIsolate()) != 0) {
                    return JNIErrors.JNI_ERR();
                }
                return JNIErrors.JNI_OK();
            }
        }
    }

    static class Exports {
        Exports() {
        }

        @CEntryPoint(name="JNI_GetCreatedJavaVMs", include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        @Uninterruptible(reason="No Java context.")
        static int JNI_GetCreatedJavaVMs(JNIJavaVMPointer vmBuf, int bufLen, CIntPointer nVMs) {
            JNIJavaVMList.gather(vmBuf, bufLen, nVMs);
            return JNIErrors.JNI_OK();
        }

        @CEntryPoint(name="JNI_CreateJavaVM", include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=JNICreateJavaVMPrologue.class)
        static int JNI_CreateJavaVM(JNIJavaVMPointer vmBuf, JNIEnvironmentPointer penv, JNIJavaVMInitArgs vmArgs) {
            return JNIErrors.JNI_OK();
        }

        @CEntryPoint(name="JNI_GetDefaultJavaVMInitArgs", include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.SymbolOnly)
        @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        @Uninterruptible(reason="No Java context")
        static int JNI_GetDefaultJavaVMInitArgs(JNIJavaVMInitArgs vmArgs) {
            int version = vmArgs.getVersion();
            if (JNIVersion.isSupported(vmArgs.getVersion()) && version != JNIVersion.JNI_VERSION_1_1()) {
                return JNIErrors.JNI_OK();
            }
            if (version == JNIVersion.JNI_VERSION_1_1()) {
                vmArgs.setVersion(JNIVersion.JNI_VERSION_1_2());
            }
            return JNIErrors.JNI_ERR();
        }

        static class JNICreateJavaVMPrologue
        implements CEntryPointOptions.Prologue {
            JNICreateJavaVMPrologue() {
            }

            @Uninterruptible(reason="prologue")
            static int enter(JNIJavaVMPointer vmBuf, JNIEnvironmentPointer penv, JNIJavaVMInitArgs vmArgs) {
                int vmArgc;
                if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                    int error = CEntryPointActions.enterIsolate((Isolate)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL);
                    if (error == 0) {
                        CEntryPointActions.leave();
                        return JNIErrors.JNI_EEXIST();
                    }
                    if (error != 5) {
                        return JNIErrors.JNI_EEXIST();
                    }
                }
                boolean hasSpecialVmOptions = false;
                CEntryPointCreateIsolateParameters params = (CEntryPointCreateIsolateParameters)WordFactory.nullPointer();
                if (vmArgs.isNonNull() && (vmArgc = vmArgs.getNOptions()) > 0) {
                    UnsignedWord size = SizeOf.unsigned(CCharPointerPointer.class).multiply(vmArgc + 1);
                    CCharPointerPointer argv = (CCharPointerPointer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(size);
                    if (argv.isNull()) {
                        return JNIErrors.JNI_ENOMEM();
                    }
                    int argc = 0;
                    argv.addressOf(argc).write((CCharPointer)WordFactory.nullPointer());
                    ++argc;
                    Pointer p = (Pointer)vmArgs.getOptions();
                    for (int i = 0; i < vmArgc; ++i) {
                        JNIJavaVMOption option = (JNIJavaVMOption)p.add(i * SizeOf.get(JNIJavaVMOption.class));
                        CCharPointer optionString = option.getOptionString();
                        if (!optionString.isNonNull()) continue;
                        if (Support.isSpecialVMOption(optionString)) {
                            hasSpecialVmOptions = true;
                            continue;
                        }
                        argv.addressOf(argc).write(optionString);
                        ++argc;
                    }
                    params = (CEntryPointCreateIsolateParameters)StackValue.get(CEntryPointCreateIsolateParameters.class);
                    UnmanagedMemoryUtil.fill((Pointer)params, SizeOf.unsigned(CEntryPointCreateIsolateParameters.class), (byte)0);
                    params.setVersion(4);
                    params.setArgc(argc);
                    params.setArgv(argv);
                    params.setIgnoreUnrecognizedArguments(vmArgs.getIgnoreUnrecognized());
                    params.setExitWhenArgumentParsingFails(false);
                }
                int code = CEntryPointActions.enterCreateIsolate(params);
                if (params.isNonNull()) {
                    ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)params.getArgv());
                    params = (CEntryPointCreateIsolateParameters)WordFactory.nullPointer();
                }
                if (code == 0) {
                    return Support.finishInitialization(vmBuf, penv, vmArgs, hasSpecialVmOptions);
                }
                if (code == 1 || code == 22) {
                    return JNIErrors.JNI_ERR();
                }
                if (code == 8 || code == 801 || code == 802) {
                    return JNIErrors.JNI_ENOMEM();
                }
                if ((code = -1000000000 - code) == JNIErrors.JNI_OK() || code >= -100) {
                    code = JNIErrors.JNI_ERR();
                }
                return code;
            }
        }
    }
}

