/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.functions;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.EntryPointCallStubMethod;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.jni.access.JNIAccessFeature;
import com.oracle.svm.jni.functions.JNIFunctionTables;
import com.oracle.svm.jni.functions.JNIFunctions;
import com.oracle.svm.jni.functions.JNIInvocationInterface;
import com.oracle.svm.jni.hosted.JNICallTrampolineMethod;
import com.oracle.svm.jni.hosted.JNIFieldAccessorMethod;
import com.oracle.svm.jni.hosted.JNIJavaCallWrapperMethod;
import com.oracle.svm.jni.hosted.JNIPrimitiveArrayOperationMethod;
import com.oracle.svm.jni.nativeapi.JNIInvokeInterface;
import com.oracle.svm.jni.nativeapi.JNINativeInterface;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.reflect.AnnotatedElement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;

public class JNIFunctionTablesFeature
implements Feature {
    private final EnumSet<JavaKind> jniKinds = EnumSet.of(JavaKind.Object, new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double, JavaKind.Void});
    private StructInfo functionTableMetadata;
    private StructInfo invokeInterfaceMetadata;
    private ResolvedJavaMethod[] generatedMethods;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(JNIAccessFeature.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)arg;
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        JNIFunctionTables.create();
        NativeLibraries nativeLibraries = access.getNativeLibraries();
        AnalysisType invokeInterface = metaAccess.lookupJavaType(JNIInvokeInterface.class);
        this.invokeInterfaceMetadata = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)invokeInterface);
        AnalysisType functionTable = metaAccess.lookupJavaType(JNINativeInterface.class);
        this.functionTableMetadata = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)functionTable);
        AnalysisType invokes = metaAccess.lookupJavaType(JNIInvocationInterface.class);
        AnalysisType exports = metaAccess.lookupJavaType(JNIInvocationInterface.Exports.class);
        AnalysisType functions = metaAccess.lookupJavaType(JNIFunctions.class);
        Stream analysisMethods = Stream.of(invokes, functions, exports).flatMap(type -> Stream.of(type.getDeclaredMethods()));
        Stream<AnalysisMethod> unimplementedMethods = Stream.of((AnalysisMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)metaAccess, JNIFunctions.UnimplementedWithJNIEnvArgument.class), (AnalysisMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)metaAccess, JNIFunctions.UnimplementedWithJavaVMArgument.class));
        Stream.concat(analysisMethods, unimplementedMethods).forEach(method -> {
            CEntryPoint annotation = (CEntryPoint)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)method, CEntryPoint.class);
            assert (annotation != null) : "only entry points allowed in class";
            CEntryPointCallStubSupport.singleton().registerStubForMethod((AnalysisMethod)method, () -> {
                CEntryPointData data = CEntryPointData.create((ResolvedJavaMethod)method);
                if (!SubstrateOptions.JNIExportSymbols.getValue().booleanValue() && data.getPublishAs() != CEntryPoint.Publish.NotPublished) {
                    data = data.copyWithPublishAs(CEntryPoint.Publish.NotPublished);
                }
                return data;
            });
        });
        ArrayList<EntryPointCallStubMethod> generated = new ArrayList<EntryPointCallStubMethod>();
        MetaAccessProvider wrappedMetaAccess = metaAccess.getWrapped();
        ResolvedJavaType generatedMethodClass = wrappedMetaAccess.lookupJavaType(JNIFunctions.class);
        ConstantPool constantPool = generatedMethodClass.getDeclaredMethods()[0].getConstantPool();
        Object fldKinds = this.jniKinds.clone();
        ((AbstractCollection)fldKinds).remove(JavaKind.Void);
        Iterator iterator = ((AbstractCollection)fldKinds).iterator();
        while (iterator.hasNext()) {
            boolean[] trueFalse;
            JavaKind kind = (JavaKind)iterator.next();
            for (boolean isSetter : trueFalse = new boolean[]{true, false}) {
                for (boolean isStatic : trueFalse) {
                    JNIFieldAccessorMethod method2 = ((JNIFieldAccessorMethod.Factory)ImageSingletons.lookup(JNIFieldAccessorMethod.Factory.class)).create(kind, isSetter, isStatic, generatedMethodClass, constantPool, wrappedMetaAccess);
                    AnalysisMethod analysisMethod = access.getUniverse().lookup((JavaMethod)method2);
                    access.getBigBang().addRootMethod(analysisMethod, true).registerAsEntryPoint((Object)method2.createEntryPointData());
                    generated.add(method2);
                }
            }
        }
        Object primitiveArrayKinds = this.jniKinds.clone();
        ((AbstractCollection)primitiveArrayKinds).remove(JavaKind.Void);
        ((AbstractCollection)primitiveArrayKinds).remove(JavaKind.Object);
        Iterator iterator2 = ((AbstractCollection)primitiveArrayKinds).iterator();
        while (iterator2.hasNext()) {
            JavaKind kind = (JavaKind)iterator2.next();
            for (JNIPrimitiveArrayOperationMethod.Operation op : JNIPrimitiveArrayOperationMethod.Operation.values()) {
                JNIPrimitiveArrayOperationMethod method3 = new JNIPrimitiveArrayOperationMethod(kind, op, generatedMethodClass, constantPool, wrappedMetaAccess);
                AnalysisMethod analysisMethod = access.getUniverse().lookup((JavaMethod)method3);
                access.getBigBang().addRootMethod(analysisMethod, true).registerAsEntryPoint((Object)method3.createEntryPointData());
                generated.add(method3);
            }
        }
        this.generatedMethods = generated.toArray(new ResolvedJavaMethod[0]);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        HostedMetaAccess metaAccess = access.getMetaAccess();
        CFunctionPointer unimplementedWithJavaVMArgument = JNIFunctionTablesFeature.getStubFunctionPointer(access, (HostedMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)metaAccess, JNIFunctions.UnimplementedWithJavaVMArgument.class));
        this.fillJNIInvocationInterfaceTable(access, JNIFunctionTables.singleton().invokeInterfaceDataPrototype, unimplementedWithJavaVMArgument);
        CFunctionPointer unimplementedWithJNIEnvArgument = JNIFunctionTablesFeature.getStubFunctionPointer(access, (HostedMethod)JNIFunctionTablesFeature.getSingleMethod((MetaAccessProvider)metaAccess, JNIFunctions.UnimplementedWithJNIEnvArgument.class));
        this.fillJNIFunctionsTable(access, JNIFunctionTables.singleton().functionTableData, unimplementedWithJNIEnvArgument);
    }

    private static CFunctionPointer prepareCallTrampoline(FeatureImpl.CompilationAccessImpl access, JNIJavaCallWrapperMethod.CallVariant variant, boolean nonVirtual) {
        JNICallTrampolineMethod trampolineMethod = JNIAccessFeature.singleton().getCallTrampolineMethod(variant, nonVirtual);
        AnalysisMethod analysisTrampoline = access.getUniverse().getBigBang().getUniverse().lookup((JavaMethod)trampolineMethod);
        HostedMethod hostedTrampoline = access.getUniverse().lookup((JavaMethod)analysisTrampoline);
        hostedTrampoline.compilationInfo.setCustomParseFunction(trampolineMethod.createCustomParseFunction());
        hostedTrampoline.compilationInfo.setCustomCompileFunction(trampolineMethod.createCustomCompileFunction());
        return new MethodPointer(hostedTrampoline);
    }

    private static ResolvedJavaMethod getSingleMethod(MetaAccessProvider metaAccess, Class<?> holder) {
        ResolvedJavaMethod[] methods = metaAccess.lookupJavaType(holder).getDeclaredMethods();
        assert (methods.length == 1);
        return methods[0];
    }

    private static CFunctionPointer getStubFunctionPointer(FeatureImpl.CompilationAccessImpl access, HostedMethod method) {
        AnalysisMethod stub = CEntryPointCallStubSupport.singleton().getStubForMethod(method.getWrapped());
        return new MethodPointer(access.getUniverse().lookup((JavaMethod)stub));
    }

    private void fillJNIInvocationInterfaceTable(FeatureImpl.CompilationAccessImpl access, CFunctionPointer[] table, CFunctionPointer defaultValue) {
        HostedMethod[] methods;
        JNIFunctionTablesFeature.initializeFunctionPointerTable(access, table, defaultValue);
        ResolvedJavaType invokes = access.getMetaAccess().lookupJavaType((Class)JNIInvocationInterface.class);
        for (HostedMethod method : methods = invokes.getDeclaredMethods()) {
            StructFieldInfo field = JNIFunctionTablesFeature.findFieldFor(this.invokeInterfaceMetadata, method.getName());
            int offset = field.getOffsetInfo().getProperty();
            JNIFunctionTablesFeature.setFunctionPointerTable(table, offset, JNIFunctionTablesFeature.getStubFunctionPointer(access, method));
        }
    }

    private void fillJNIFunctionsTable(FeatureImpl.CompilationAccessImpl access, CFunctionPointer[] table, CFunctionPointer defaultValue) {
        int offset;
        StructFieldInfo field;
        HostedMethod[] methods;
        JNIFunctionTablesFeature.initializeFunctionPointerTable(access, table, defaultValue);
        ResolvedJavaType functions = access.getMetaAccess().lookupJavaType((Class)JNIFunctions.class);
        for (HostedMethod hostedMethod : methods = functions.getDeclaredMethods()) {
            field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, hostedMethod.getName());
            int offset2 = field.getOffsetInfo().getProperty();
            JNIFunctionTablesFeature.setFunctionPointerTable(table, offset2, JNIFunctionTablesFeature.getStubFunctionPointer(access, hostedMethod));
        }
        for (ResolvedJavaMethod resolvedJavaMethod : this.generatedMethods) {
            field = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, resolvedJavaMethod.getName());
            AnalysisUniverse analysisUniverse = access.getUniverse().getBigBang().getUniverse();
            AnalysisMethod analysisMethod = analysisUniverse.lookup((JavaMethod)resolvedJavaMethod);
            HostedMethod hostedMethod = access.getUniverse().lookup((JavaMethod)analysisMethod);
            offset = field.getOffsetInfo().getProperty();
            JNIFunctionTablesFeature.setFunctionPointerTable(table, offset, new MethodPointer(hostedMethod));
        }
        for (JNIJavaCallWrapperMethod.CallVariant callVariant : JNIJavaCallWrapperMethod.CallVariant.values()) {
            CFunctionPointer trampoline = JNIFunctionTablesFeature.prepareCallTrampoline(access, callVariant, false);
            String suffix = callVariant == JNIJavaCallWrapperMethod.CallVariant.ARRAY ? "A" : (callVariant == JNIJavaCallWrapperMethod.CallVariant.VA_LIST ? "V" : "");
            CFunctionPointer nonvirtualTrampoline = JNIFunctionTablesFeature.prepareCallTrampoline(access, callVariant, true);
            for (JavaKind kind : this.jniKinds) {
                String[] prefixes;
                for (String prefix : prefixes = new String[]{"Call", "CallStatic"}) {
                    StructFieldInfo field2 = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, prefix + kind.name() + "Method" + suffix);
                    int offset3 = field2.getOffsetInfo().getProperty();
                    JNIFunctionTablesFeature.setFunctionPointerTable(table, offset3, trampoline);
                }
                StructFieldInfo field3 = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, "CallNonvirtual" + kind.name() + "Method" + suffix);
                int offset4 = field3.getOffsetInfo().getProperty();
                JNIFunctionTablesFeature.setFunctionPointerTable(table, offset4, nonvirtualTrampoline);
            }
            StructFieldInfo field4 = JNIFunctionTablesFeature.findFieldFor(this.functionTableMetadata, "NewObject" + suffix);
            offset = field4.getOffsetInfo().getProperty();
            JNIFunctionTablesFeature.setFunctionPointerTable(table, offset, trampoline);
        }
    }

    private static StructFieldInfo findFieldFor(StructInfo info, String name) {
        for (ElementInfo element : info.getChildren()) {
            StructFieldInfo field;
            if (!(element instanceof StructFieldInfo) || !(field = (StructFieldInfo)element).getName().equals(name)) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Cannot find JNI function table field for: " + name);
    }

    private static void initializeFunctionPointerTable(FeatureImpl.CompilationAccessImpl access, CFunctionPointer[] table, CFunctionPointer defaultValue) {
        for (int i = 0; i < table.length; ++i) {
            table[i] = defaultValue;
        }
        access.registerAsImmutable(table);
    }

    private static void setFunctionPointerTable(CFunctionPointer[] table, int offsetInBytes, CFunctionPointer value) {
        int wordSize = FrameAccess.wordSize();
        VMError.guarantee(offsetInBytes % wordSize == 0);
        table[offsetInBytes / wordSize] = value;
    }
}

