/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jfr;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.jfr.JfrFeature;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdMap;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.jfr.JfrEventSubstitution;
import com.oracle.svm.util.ModuleSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdk.jfr.Event;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
public class JfrEventFeature
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JfrFeature.isInConfiguration(false);
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(JfrFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, JfrFeature.class, (boolean)false, (String)"jdk.jfr", (String[])new String[]{"jdk.jfr.events"});
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, JfrEventSubstitution.class, (boolean)false, (String)"jdk.internal.vm.ci", (String[])new String[]{"jdk.vm.ci.hotspot"});
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)c;
        MetaAccessProvider metaAccess = config.getMetaAccess().getWrapped();
        for (Class<Event> eventSubClass : config.findSubclasses(Event.class)) {
            RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{eventSubClass.getName()});
        }
        config.registerSubstitutionProcessor(new JfrEventSubstitution(metaAccess));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class eventClass = access.findClassByName("jdk.internal.event.Event");
        if (eventClass != null) {
            access.registerSubtypeReachabilityHandler(JfrEventFeature::eventSubtypeReachable, eventClass);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        int mapSize = ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).getMaxTypeId() + 1;
        ((JfrTraceIdMap)ImageSingletons.lookup(JfrTraceIdMap.class)).initialize(mapSize);
        Collection<? extends SharedType> types = ((FeatureImpl.CompilationAccessImpl)a).getTypes();
        for (SharedType sharedType : types) {
            DynamicHub hub = sharedType.getHub();
            Class<?> clazz = hub.getHostedJavaClass();
            JfrTraceId.assign(clazz, hub.getTypeID() + 1);
        }
    }

    private static void eventSubtypeReachable(Feature.DuringAnalysisAccess a, Class<?> c) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (c.getCanonicalName().equals("jdk.jfr.Event") || c.getCanonicalName().equals("jdk.internal.event.Event") || c.getCanonicalName().equals("jdk.jfr.events.AbstractJDKEvent") || c.getCanonicalName().equals("jdk.jfr.events.AbstractBufferStatisticsEvent") || Modifier.isAbstract(c.getModifiers())) {
            return;
        }
        try {
            Field f = c.getDeclaredField("eventHandler");
            RuntimeReflection.register((Field[])new Field[]{f});
            access.rescanRoot(f);
            if (!access.concurrentReachabilityHandlers()) {
                access.requireAnalysisIteration();
            }
        }
        catch (Exception e) {
            throw VMError.shouldNotReachHere("Unable to register eventHandler for: " + c.getCanonicalName(), e);
        }
    }
}

